/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.odftoolkit.simple.style.GraphicProperties;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class FrameStyleHandler
extends DefaultStyleHandler {
    private Frame mFrame;

    public FrameStyleHandler(Frame frame) {
        super(frame.getDrawFrameElement());
        this.mFrame = frame;
    }

    public void setBorders(Border border, StyleTypeDefinitions.CellBordersType bordersType) {
        this.getGraphicPropertiesForWrite().setBorders(bordersType, border);
    }

    public void setStroke(StyleTypeDefinitions.OdfDrawStroke stroke, Color color, String widthDesc, String dashStyleName) {
        this.getGraphicPropertiesForWrite().setStroke(stroke, color, widthDesc, dashStyleName);
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.getGraphicPropertiesForWrite().setFill(StyleTypeDefinitions.OdfDrawFill.NONE, null);
        } else {
            this.getGraphicPropertiesForWrite().setFill(StyleTypeDefinitions.OdfDrawFill.SOLID, color);
        }
    }

    public void setBackgroundFrame(boolean isBackgroundFrame) {
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        graphicPropertiesForWrite.setStyleRunThrough(isBackgroundFrame);
    }

    public void setAchorType(StyleTypeDefinitions.AnchorType achorType) {
        if (!this.mDocument.getMediaTypeString().equals(Document.OdfMediaType.TEXT.getMediaTypeString()) && !this.mDocument.getMediaTypeString().equals(Document.OdfMediaType.TEXT_TEMPLATE.getMediaTypeString())) {
            return;
        }
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        DrawFrameElement frameElement = (DrawFrameElement)this.mOdfElement;
        frameElement.setTextAnchorTypeAttribute(achorType.toString());
        switch (achorType) {
            case AS_CHARACTER: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.BASELINE);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                break;
            }
            case TO_CHARACTER: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                graphicPropertiesForWrite.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.CENTER);
                break;
            }
            case TO_PAGE: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PAGE);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                graphicPropertiesForWrite.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PAGE);
                graphicPropertiesForWrite.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.CENTER);
                break;
            }
            case TO_PARAGRAPH: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                graphicPropertiesForWrite.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.CENTER);
                break;
            }
        }
    }

    public void setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition horizontalPos) {
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        graphicPropertiesForWrite.setHorizontalPosition(horizontalPos);
    }

    public void setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative relative) {
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        graphicPropertiesForWrite.setHorizontalRelative(relative);
    }

    public void setVerticalRelative(StyleTypeDefinitions.VerticalRelative relative) {
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        graphicPropertiesForWrite.setVerticalRelative(relative);
    }

    public void setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition verticalPos) {
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        graphicPropertiesForWrite.setVerticalPosition(verticalPos);
    }

    public StyleTypeDefinitions.FrameHorizontalPosition getHorizontalPosition() {
        GraphicProperties graphicPropertiesForRead = this.getGraphicPropertiesForRead();
        return graphicPropertiesForRead.getHorizontalPosition();
    }

    public StyleTypeDefinitions.FrameVerticalPosition getVerticalPosition() {
        GraphicProperties graphicPropertiesForRead = this.getGraphicPropertiesForRead();
        return graphicPropertiesForRead.getVerticalPosition();
    }

    public StyleTypeDefinitions.VerticalRelative getVerticalRelative() {
        GraphicProperties graphicPropertiesForRead = this.getGraphicPropertiesForRead();
        return graphicPropertiesForRead.getVerticalRelative();
    }

    public StyleTypeDefinitions.HorizontalRelative getHorizontalRelative() {
        GraphicProperties graphicPropertiesForRead = this.getGraphicPropertiesForRead();
        return graphicPropertiesForRead.getHorizontalRelative();
    }
}

