/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextMetaElement;
import org.odftoolkit.odfdom.dom.element.text.TextMetaFieldElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextReferenceMarkEndElement;
import org.odftoolkit.odfdom.dom.element.text.TextReferenceMarkStartElement;
import org.odftoolkit.odfdom.dom.element.text.TextReferenceRefElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.field.Field;
import org.w3c.dom.Node;

public class ReferenceField
extends Field {
    private OdfElement referencedElement;
    private String name;
    private TextReferenceMarkStartElement referenceMarkStartElement;
    private TextReferenceMarkEndElement referenceMarkEndElement;

    ReferenceField(OdfElement odfElement, String referenceName) {
        OdfElement parentEle = (OdfElement)odfElement.getParentNode();
        if (parentEle instanceof TextAElement || parentEle instanceof TextHElement || parentEle instanceof TextMetaElement || parentEle instanceof TextMetaFieldElement || parentEle instanceof TextPElement || parentEle instanceof TextSpanElement) {
            this.referencedElement = odfElement;
            this.name = referenceName;
            this.referenceMarkStartElement = ((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextReferenceMarkStartElement.class);
            this.referenceMarkStartElement.setTextNameAttribute(referenceName);
            parentEle.insertBefore(this.referenceMarkStartElement, odfElement);
            this.referenceMarkEndElement = ((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextReferenceMarkEndElement.class);
            this.referenceMarkEndElement.setTextNameAttribute(referenceName);
            OdfElement nextSiblingEle = (OdfElement)odfElement.getNextSibling();
            if (nextSiblingEle == null) {
                parentEle.appendChild(this.referenceMarkEndElement);
            } else {
                parentEle.insertBefore(this.referenceMarkEndElement, nextSiblingEle);
            }
        } else {
            throw new IllegalArgumentException("The specific odf element can't own a reference field.");
        }
        Component.registerComponent(this, this.getOdfElement());
    }

    public void setName(String referenceName) {
        this.referenceMarkStartElement.setTextNameAttribute(this.name);
        this.name = referenceName;
    }

    public String getName() {
        return this.referenceMarkStartElement.getTextNameAttribute();
    }

    public void appendReferenceTo(OdfElement odfEle, DisplayType type) {
        TextSpanElement spanElement = ((OdfFileDom)odfEle.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        TextReferenceRefElement referenceRefElement = spanElement.newTextReferenceRefElement();
        referenceRefElement.setTextRefNameAttribute(this.name);
        referenceRefElement.setTextReferenceFormatAttribute(type.toString());
        if (odfEle instanceof TextPElement) {
            odfEle.appendChild(spanElement);
        } else {
            OdfElement parentEle = (OdfElement)odfEle.getParentNode();
            Node nextSiblingEle = odfEle.getNextSibling();
            TextPElement pElement = ((OdfFileDom)odfEle.getOwnerDocument()).newOdfElement(TextPElement.class);
            pElement.appendChild(spanElement);
            if (nextSiblingEle == null) {
                parentEle.appendChild(pElement);
            } else {
                parentEle.insertBefore(pElement, nextSiblingEle);
            }
        }
    }

    public OdfElement getOdfElement() {
        return this.referencedElement;
    }

    public Field.FieldType getFieldType() {
        return Field.FieldType.REFERENCE_FIELD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayType {
        CHAPTER("chapter"),
        DIRECTION("direction"),
        PAGE("page"),
        TEXT("text");

        private final String displayType;

        private DisplayType(String type) {
            this.displayType = type;
        }

        public String toString() {
            return this.displayType;
        }
    }
}

