/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextAuthorInitialsElement;
import org.odftoolkit.odfdom.dom.element.text.TextAuthorNameElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.field.Field;

public class AuthorField
extends Field {
    private final boolean isInitials;
    private TextAuthorNameElement authorNameElement;
    private TextAuthorInitialsElement authorInitialsElement;

    AuthorField(OdfElement odfElement, boolean isAuthorInitials) {
        this.isInitials = isAuthorInitials;
        TextSpanElement spanElement = ((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        odfElement.appendChild(spanElement);
        if (isAuthorInitials) {
            this.authorInitialsElement = spanElement.newTextAuthorInitialsElement();
            this.authorInitialsElement.setTextFixedAttribute(false);
        } else {
            this.authorNameElement = spanElement.newTextAuthorNameElement();
            this.authorNameElement.setTextFixedAttribute(false);
        }
        Component.registerComponent(this, this.getOdfElement());
    }

    public OdfElement getOdfElement() {
        if (this.isInitials) {
            return this.authorInitialsElement;
        }
        return this.authorNameElement;
    }

    public Field.FieldType getFieldType() {
        return this.isInitials ? Field.FieldType.AUTHOR_INITIALS_FIELD : Field.FieldType.AUTHOR_NAME_FIELD;
    }
}

