/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.xml.sax.SAXParseException;

public class OdfValidationException
extends SAXParseException {
    private ValidationConstraint mConstraint;
    private static final String NO_SOURCE = "";
    private static final String SOURCE_PREFIX = " '";
    private static final String SOURCE_SUFFIX = "'";

    public OdfValidationException(ValidationConstraint constraint) {
        super(String.format(constraint.getMessage(), NO_SOURCE), null, null, -1, -1);
        this.mConstraint = constraint;
    }

    public OdfValidationException(ValidationConstraint constraint, String sourcePath, Object ... messageParameters) {
        super(OdfValidationException.formatMessage(constraint, sourcePath, messageParameters), null, null, -1, -1);
        this.mConstraint = constraint;
    }

    public OdfValidationException(ValidationConstraint constraint, String sourcePath, Exception e2, Object ... messageParameters) {
        super(OdfValidationException.formatMessage(constraint, sourcePath, messageParameters), null, null, -1, -1, e2);
        this.mConstraint = constraint;
    }

    public ValidationConstraint getConstraint() {
        return this.mConstraint;
    }

    private static String formatMessage(ValidationConstraint constraint, String sourcePath, Object ... messageParameters) {
        String formattedString = NO_SOURCE;
        int varCount = 0;
        if (messageParameters != null) {
            varCount = messageParameters.length;
        }
        switch (varCount) {
            case 0: {
                formattedString = String.format(constraint.getMessage(), sourcePath == null || sourcePath.equals(NO_SOURCE) ? NO_SOURCE : SOURCE_PREFIX + sourcePath + SOURCE_SUFFIX);
                break;
            }
            case 1: {
                formattedString = String.format(constraint.getMessage(), sourcePath == null || sourcePath.equals(NO_SOURCE) ? NO_SOURCE : SOURCE_PREFIX + sourcePath + SOURCE_SUFFIX, messageParameters[0]);
                break;
            }
            case 2: {
                formattedString = String.format(constraint.getMessage(), sourcePath == null || sourcePath.equals(NO_SOURCE) ? NO_SOURCE : SOURCE_PREFIX + sourcePath + SOURCE_SUFFIX, messageParameters[0], messageParameters[1]);
                break;
            }
            case 3: {
                formattedString = String.format(constraint.getMessage(), sourcePath == null || sourcePath.equals(NO_SOURCE) ? NO_SOURCE : SOURCE_PREFIX + sourcePath + SOURCE_SUFFIX, messageParameters[0], messageParameters[1], messageParameters[2]);
                break;
            }
            case 4: {
                formattedString = String.format(constraint.getMessage(), sourcePath == null || sourcePath.equals(NO_SOURCE) ? NO_SOURCE : SOURCE_PREFIX + sourcePath + SOURCE_SUFFIX, messageParameters[0], messageParameters[1], messageParameters[2], messageParameters[3]);
                break;
            }
            case 5: {
                formattedString = String.format(constraint.getMessage(), sourcePath == null || sourcePath.equals(NO_SOURCE) ? NO_SOURCE : SOURCE_PREFIX + sourcePath + SOURCE_SUFFIX, messageParameters[0], messageParameters[1], messageParameters[2], messageParameters[3], messageParameters[4]);
            }
        }
        return formattedString;
    }
}

