/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.InputStream;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class EmbeddedObjects {
    public static void main(String[] args) throws Exception {
        OPCPackage pkg = OPCPackage.open(args[0]);
        XSSFWorkbook workbook = new XSSFWorkbook(pkg);
        for (PackagePart pPart : workbook.getAllEmbedds()) {
            Object document;
            Workbook embeddedWorkbook;
            String contentType = pPart.getContentType();
            if (contentType.equals("application/vnd.ms-excel")) {
                embeddedWorkbook = new HSSFWorkbook(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                embeddedWorkbook = new XSSFWorkbook(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/msword")) {
                document = new HWPFDocument(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                document = new XWPFDocument(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.ms-powerpoint")) {
                HSLFSlideShow slideShow = new HSLFSlideShow(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                OPCPackage docPackage = OPCPackage.open(pPart.getInputStream());
                XSLFSlideShow slideShow = new XSLFSlideShow(docPackage);
                continue;
            }
            System.out.println("Unknown Embedded Document: " + contentType);
            InputStream inputStream = pPart.getInputStream();
        }
        pkg.close();
    }
}

