/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.LittleEndianInput;

public class LittleEndianInputStream
extends FilterInputStream
implements LittleEndianInput {
    public LittleEndianInputStream(InputStream is) {
        super(is);
    }

    public int available() {
        try {
            return super.available();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public byte readByte() {
        return (byte)this.readUByte();
    }

    public int readUByte() {
        int ch;
        try {
            ch = this.in.read();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        LittleEndianInputStream.checkEOF(ch);
        return ch;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readInt() {
        int ch4;
        int ch3;
        int ch2;
        int ch1;
        try {
            ch1 = this.in.read();
            ch2 = this.in.read();
            ch3 = this.in.read();
            ch4 = this.in.read();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        LittleEndianInputStream.checkEOF(ch1 | ch2 | ch3 | ch4);
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public long readLong() {
        int b7;
        int b6;
        int b5;
        int b4;
        int b3;
        int b2;
        int b1;
        int b0;
        try {
            b0 = this.in.read();
            b1 = this.in.read();
            b2 = this.in.read();
            b3 = this.in.read();
            b4 = this.in.read();
            b5 = this.in.read();
            b6 = this.in.read();
            b7 = this.in.read();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        LittleEndianInputStream.checkEOF(b0 | b1 | b2 | b3 | b4 | b5 | b6 | b7);
        return ((long)b7 << 56) + ((long)b6 << 48) + ((long)b5 << 40) + ((long)b4 << 32) + ((long)b3 << 24) + (long)(b2 << 16) + (long)(b1 << 8) + (long)(b0 << 0);
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public int readUShort() {
        int ch2;
        int ch1;
        try {
            ch1 = this.in.read();
            ch2 = this.in.read();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        LittleEndianInputStream.checkEOF(ch1 | ch2);
        return (ch2 << 8) + (ch1 << 0);
    }

    private static void checkEOF(int value) {
        if (value < 0) {
            throw new RuntimeException("Unexpected end-of-file");
        }
    }

    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    public void readFully(byte[] buf, int off, int len) {
        int max2 = off + len;
        for (int i = off; i < max2; ++i) {
            int ch;
            try {
                ch = this.in.read();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            LittleEndianInputStream.checkEOF(ch);
            buf[i] = (byte)ch;
        }
    }
}

