/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import com.hp.hpl.jena.shared.JenaException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.stream.Locator;
import org.apache.jena.riot.stream.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorZip
implements Locator {
    private static Logger log = LoggerFactory.getLogger(LocatorZip.class);
    private final String zipFileName;
    private final ZipFile zipFile;

    public LocatorZip(String zfn) {
        try {
            this.zipFileName = zfn;
            this.zipFile = new ZipFile(this.zipFileName);
        }
        catch (IOException ex) {
            throw new JenaException("Problems accessing " + zfn, ex);
        }
    }

    @Override
    public TypedInputStream open(String filenameOrURI) {
        ZipEntry entry = this.zipFile.getEntry(filenameOrURI);
        if (entry == null) {
            if (StreamManager.logAllLookups && log.isDebugEnabled()) {
                log.debug("Not found: " + this.zipFileName + " : " + filenameOrURI);
            }
            return null;
        }
        try {
            InputStream in = this.zipFile.getInputStream(entry);
            if (in == null) {
                if (StreamManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameOrURI);
                }
                return null;
            }
            if (StreamManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI);
            }
            ContentType ct = RDFLanguages.guessContentType(filenameOrURI);
            return new TypedInputStream(in, ct, filenameOrURI);
        }
        catch (IOException ex) {
            log.warn("IO Exception opening zip entry: " + filenameOrURI);
            return null;
        }
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    @Override
    public String getName() {
        return "LocatorZip(" + this.zipFileName + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.zipFileName == null ? 0 : this.zipFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocatorZip other = (LocatorZip)obj;
        return !(this.zipFileName == null ? other.zipFileName != null : !this.zipFileName.equals(other.zipFileName));
    }
}

