/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.EvalContext;
import net.rootdev.javardfa.ProfileCollector;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import net.rootdev.javardfa.literal.LiteralCollector;
import net.rootdev.javardfa.uri.IRIResolver;
import net.rootdev.javardfa.uri.URIExtractor;
import net.rootdev.javardfa.uri.URIExtractor10;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements ContentHandler {
    private final XMLEventFactory eventFactory;
    private final StatementSink sink;
    private final Set<Setting> settings;
    private final LiteralCollector literalCollector;
    private final URIExtractor extractor;
    private final ProfileCollector profileCollector;
    int bnodeId = 0;
    private Locator locator;
    private EvalContext context;

    public Parser(StatementSink sink) {
        this(sink, XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), new URIExtractor10(new IRIResolver()), ProfileCollector.EMPTY_COLLECTOR);
    }

    public Parser(StatementSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, URIExtractor extractor, ProfileCollector profileCollector) {
        this.sink = sink;
        this.eventFactory = eventFactory;
        this.settings = EnumSet.noneOf(Setting.class);
        this.extractor = extractor;
        this.literalCollector = new LiteralCollector(this, eventFactory, outputFactory);
        this.profileCollector = profileCollector;
        extractor.setSettings(this.settings);
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    public void enable(Setting setting) {
        this.settings.add(setting);
    }

    public void disable(Setting setting) {
        this.settings.remove((Object)setting);
    }

    public void setBase(String base) {
        this.context = new EvalContext(base);
        this.sink.setBase(this.context.getBase());
    }

    EvalContext parse(EvalContext context, StartElement element) throws XMLStreamException {
        Attribute nSubj;
        boolean skipElement = false;
        String newSubject = null;
        String currentObject = null;
        LinkedList<String> forwardProperties = new LinkedList<String>();
        LinkedList<String> backwardProperties = new LinkedList<String>();
        String currentLanguage = context.language;
        if (this.settings.contains((Object)Setting.OnePointOne)) {
            if (element.getAttributeByName(Constants.vocab) != null) {
                context.vocab = element.getAttributeByName(Constants.vocab).getValue().trim();
            }
            if (element.getAttributeByName(Constants.prefix) != null) {
                this.parsePrefixes(element.getAttributeByName(Constants.prefix).getValue(), context);
            }
            if (element.getAttributeByName(Constants.profile) != null) {
                String profileURI = this.extractor.resolveURI(element.getAttributeByName(Constants.profile).getValue(), context);
                this.profileCollector.getProfile(profileURI, context);
            }
        }
        if (this.settings.contains((Object)Setting.ManualNamespaces)) {
            if (element.getAttributeByName(Constants.xmllang) != null) {
                currentLanguage = element.getAttributeByName(Constants.xmllang).getValue();
                if (currentLanguage.length() == 0) {
                    currentLanguage = null;
                }
            } else if (element.getAttributeByName(Constants.lang) != null && (currentLanguage = element.getAttributeByName(Constants.lang).getValue()).length() == 0) {
                currentLanguage = null;
            }
        } else if (element.getAttributeByName(Constants.xmllangNS) != null && (currentLanguage = element.getAttributeByName(Constants.xmllangNS).getValue()).length() == 0) {
            currentLanguage = null;
        }
        if (Constants.base.equals(element.getName()) && element.getAttributeByName(Constants.href) != null) {
            context.setBase(element.getAttributeByName(Constants.href).getValue());
            this.sink.setBase(context.getBase());
        }
        if (element.getAttributeByName(Constants.rev) == null && element.getAttributeByName(Constants.rel) == null) {
            nSubj = this.findAttribute(element, Constants.about, Constants.src, Constants.resource, Constants.href);
            if (nSubj != null) {
                newSubject = this.extractor.getURI(element, nSubj, context);
            }
            if (newSubject == null) {
                if (Constants.body.equals(element.getName()) || Constants.head.equals(element.getName())) {
                    newSubject = context.base;
                } else if (element.getAttributeByName(Constants.typeof) != null) {
                    newSubject = this.createBNode();
                } else {
                    if (context.parentObject != null) {
                        newSubject = context.parentObject;
                    }
                    if (element.getAttributeByName(Constants.property) == null) {
                        skipElement = true;
                    }
                }
            }
        } else {
            Attribute cObj;
            nSubj = this.findAttribute(element, Constants.about, Constants.src);
            if (nSubj != null) {
                newSubject = this.extractor.getURI(element, nSubj, context);
            }
            if (newSubject == null) {
                if (Constants.head.equals(element.getName()) || Constants.body.equals(element.getName())) {
                    newSubject = context.base;
                } else if (element.getAttributeByName(Constants.typeof) != null) {
                    newSubject = this.createBNode();
                } else if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
            }
            if ((cObj = this.findAttribute(element, Constants.resource, Constants.href)) != null) {
                currentObject = this.extractor.getURI(element, cObj, context);
            }
        }
        if (newSubject != null && element.getAttributeByName(Constants.typeof) != null) {
            List<String> types = this.extractor.getURIs(element, element.getAttributeByName(Constants.typeof), context);
            for (String type : types) {
                this.emitTriples(newSubject, Constants.rdfType, type);
            }
        }
        if (this.settings.contains((Object)Setting.FormMode)) {
            if (Constants.form.equals(element.getName())) {
                this.emitTriples(newSubject, Constants.rdfType, "http://www.w3.org/1999/xhtml/vocab/#form");
            }
            if (Constants.input.equals(element.getName()) && element.getAttributeByName(Constants.name) != null) {
                currentObject = "?" + element.getAttributeByName(Constants.name).getValue();
            }
        }
        if (currentObject != null) {
            if (element.getAttributeByName(Constants.rel) != null) {
                this.emitTriples(newSubject, this.extractor.getURIs(element, element.getAttributeByName(Constants.rel), context), currentObject);
            }
            if (element.getAttributeByName(Constants.rev) != null) {
                this.emitTriples(currentObject, this.extractor.getURIs(element, element.getAttributeByName(Constants.rev), context), newSubject);
            }
        } else {
            if (element.getAttributeByName(Constants.rel) != null) {
                forwardProperties.addAll(this.extractor.getURIs(element, element.getAttributeByName(Constants.rel), context));
            }
            if (element.getAttributeByName(Constants.rev) != null) {
                backwardProperties.addAll(this.extractor.getURIs(element, element.getAttributeByName(Constants.rev), context));
            }
            if (!forwardProperties.isEmpty() || !backwardProperties.isEmpty()) {
                currentObject = this.createBNode();
            }
        }
        if (element.getAttributeByName(Constants.property) != null) {
            List<String> props = this.extractor.getURIs(element, element.getAttributeByName(Constants.property), context);
            String dt = this.getDatatype(element);
            if (element.getAttributeByName(Constants.content) != null) {
                String lex = element.getAttributeByName(Constants.content).getValue();
                if (dt == null || dt.length() == 0) {
                    this.emitTriplesPlainLiteral(newSubject, props, lex, currentLanguage);
                } else {
                    this.emitTriplesDatatypeLiteral(newSubject, props, lex, dt);
                }
            } else {
                this.literalCollector.collect(newSubject, props, dt, currentLanguage);
            }
        }
        if (!skipElement && newSubject != null) {
            this.emitTriples(context.parentSubject, context.forwardProperties, newSubject);
            this.emitTriples(newSubject, context.backwardProperties, context.parentSubject);
        }
        EvalContext ec = new EvalContext(context);
        if (skipElement) {
            ec.language = currentLanguage;
        } else {
            ec.parentSubject = newSubject != null ? newSubject : context.parentSubject;
            ec.parentObject = currentObject != null ? currentObject : (newSubject != null ? newSubject : context.parentSubject);
            ec.language = currentLanguage;
            ec.forwardProperties = forwardProperties;
            ec.backwardProperties = backwardProperties;
        }
        return ec;
    }

    private Attribute findAttribute(StartElement element, QName ... names) {
        for (QName aName : names) {
            Attribute a = element.getAttributeByName(aName);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public void emitTriples(String subj, Collection<String> props, String obj) {
        for (String prop : props) {
            this.sink.addObject(subj, prop, obj);
        }
    }

    public void emitTriplesPlainLiteral(String subj, Collection<String> props, String lex, String language) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, language, null);
        }
    }

    public void emitTriplesDatatypeLiteral(String subj, Collection<String> props, String lex, String datatype) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, null, datatype);
        }
    }

    private String createBNode() {
        return "_:node" + this.bnodeId++;
    }

    private String getDatatype(StartElement element) {
        Attribute de = element.getAttributeByName(Constants.datatype);
        if (de == null) {
            return null;
        }
        String dt = de.getValue();
        if (dt.length() == 0) {
            return dt;
        }
        return this.extractor.expandCURIE(element, dt, this.context);
    }

    private void getNamespaces(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            String prefix = this.getPrefix(qname);
            if (!"xmlns".equals(prefix)) continue;
            String pre = this.getLocal(prefix, qname);
            String uri = attrs.getValue(i);
            if (!this.settings.contains((Object)Setting.ManualNamespaces) && pre.contains("_")) continue;
            this.context.setNamespaceURI(pre, uri);
            this.sink.addPrefix(pre, uri);
        }
    }

    private String getPrefix(String qname) {
        if (!qname.contains(":")) {
            return "";
        }
        return qname.substring(0, qname.indexOf(":"));
    }

    private String getLocal(String prefix, String qname) {
        if (prefix.length() == 0) {
            return qname;
        }
        return qname.substring(prefix.length() + 1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
        if (this.locator.getSystemId() != null) {
            this.setBase(arg0.getSystemId());
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.sink.start();
    }

    @Override
    public void endDocument() throws SAXException {
        this.sink.end();
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.context.setNamespaceURI(arg0, arg1);
        this.sink.addPrefix(arg0, arg1);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void startElement(String arg0, String localname2, String qname, Attributes arg3) throws SAXException {
        try {
            String prefix;
            if (this.context == null) {
                this.setBase(this.locator.getSystemId());
            }
            String string = prefix = qname.indexOf(58) == -1 ? "" : qname.substring(0, qname.indexOf(58));
            if (this.settings.contains((Object)Setting.ManualNamespaces)) {
                this.getNamespaces(arg3);
                if (prefix.length() != 0) {
                    arg0 = this.context.getNamespaceURI(prefix);
                    localname2 = localname2.substring(prefix.length() + 1);
                }
            }
            StartElement e2 = this.eventFactory.createStartElement(prefix, arg0, localname2, this.fromAttributes(arg3), null, this.context);
            if (this.literalCollector.isCollecting()) {
                this.literalCollector.handleEvent(e2);
            }
            if (!this.literalCollector.isCollectingXML()) {
                this.context = this.parse(this.context, e2);
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Streaming issue", ex);
        }
    }

    @Override
    public void endElement(String arg0, String localname2, String qname) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            String prefix = localname2.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            EndElement e2 = this.eventFactory.createEndElement(prefix, arg0, localname2);
            this.literalCollector.handleEvent(e2);
        }
        if (!this.literalCollector.isCollectingXML()) {
            this.context = this.context.parent;
        }
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            Characters e2 = this.eventFactory.createCharacters(String.valueOf(arg0, arg1, arg2));
            this.literalCollector.handleEvent(e2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            Characters e2 = this.eventFactory.createIgnorableSpace(String.valueOf(arg0, arg1, arg2));
            this.literalCollector.handleEvent(e2);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    private Iterator fromAttributes(Attributes attributes) {
        LinkedList<Attribute> toReturn = new LinkedList<Attribute>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String prefix = qname.contains(":") ? qname.substring(0, qname.indexOf(":")) : "";
            Attribute attr = this.eventFactory.createAttribute(prefix, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            if (qname.equals("xmlns") || qname.startsWith("xmlns:")) continue;
            toReturn.add(attr);
        }
        return toReturn.iterator();
    }

    private void parsePrefixes(String value, EvalContext context) {
        String[] parts = value.split("\\s+");
        for (int i = 0; i < parts.length; i += 2) {
            String prefix = parts[i];
            if (i + 1 >= parts.length || !prefix.endsWith(":")) continue;
            String prefixFix = prefix.substring(0, prefix.length() - 1);
            context.setPrefix(prefixFix, parts[i + 1]);
            this.sink.addPrefix(prefixFix, parts[i + 1]);
        }
    }
}

