/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.parser.odf;

import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.parser.ColumnReaderCommand;
import com.janus.qrinvoice.parser.NoObject;
import com.janus.qrinvoice.parser.odf.ODFColumn;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;

public class SingleColumnReaderCommand
implements ColumnReaderCommand {
    private final Logger logger = Logger.getLogger(SingleColumnReaderCommand.class.getName());
    private final ODFColumn columnInfo;
    private final Row row;

    public SingleColumnReaderCommand(ODFColumn oDFColumn, Row row) {
        this.columnInfo = oDFColumn;
        this.row = row;
    }

    @Override
    public Object getValueFromColumnOrColumns() throws InstantiationException, IllegalAccessException {
        Cell cell;
        Object object = new NoObject();
        if (this.row != null && (cell = this.row.getCellByIndex(this.columnInfo.name())) != null) {
            if (cell.getValueType() != null && cell.getValueType().equals(this.columnInfo.cellType())) {
                switch (this.columnInfo.cellType()) {
                    case "string": {
                        object = cell.getStringValue();
                        break;
                    }
                    case "date": {
                        object = cell.getDateValue();
                        break;
                    }
                    case "float": {
                        object = BigDecimal.valueOf(cell.getDoubleValue()).setScale(2, 4);
                        break;
                    }
                    case "currency": {
                        object = BigDecimal.valueOf(cell.getCurrencyValue()).setScale(2, 4);
                        break;
                    }
                    default: {
                        object = "";
                        break;
                    }
                }
            } else {
                switch (this.columnInfo.cellType()) {
                    case "float": {
                        try {
                            object = new BigDecimal(cell.getCurrencyValue()).setScale(2, 4);
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.WARNING, "Could not read Currency value and convert to BigDecimal.", exception);
                        }
                        break;
                    }
                    case "string": {
                        try {
                            object = String.format("%.0f", cell.getDoubleValue());
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.WARNING, "Could not read Double value and convert to String.", exception);
                        }
                        break;
                    }
                    case "currency": {
                        try {
                            object = new BigDecimal(cell.getDoubleValue()).setScale(2, 4);
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.WARNING, "Could not read Double value and convert to BigDecimal.", exception);
                        }
                        break;
                    }
                    case "date": {
                        try {
                            String string = cell.getStringValue();
                            GregorianCalendar gregorianCalendar = new GregorianCalendar();
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
                            try {
                                Date date2 = simpleDateFormat.parse(string.replaceAll(" ", ""));
                                gregorianCalendar.setTime(date2);
                            }
                            catch (ParseException parseException) {
                                this.logger.log(Level.WARNING, "Fehler beim Parsen des Datums (SignatureDate): " + string, parseException);
                            }
                            object = gregorianCalendar;
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.WARNING, "Could not read date value and convert to Date.", exception);
                        }
                        break;
                    }
                    default: {
                        object = new NoObject();
                    }
                }
            }
        }
        if (object.getClass() != NoObject.class && this.columnInfo.whitespacesAction() == ODFColumn.WhiteSpacesActionEnum.DELETE_ALL) {
            object = ((String)object).replace(" ", "");
        }
        return object;
    }
}

