/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.parser;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParserUtils {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final Logger logger = Logger.getLogger(ParserUtils.class.getName());

    public static boolean isExample(String string) {
        boolean bl = false;
        if ("Max Mustermann".equals(string)) {
            bl = true;
        } else if ("John Doe".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isHeader(String string) {
        boolean bl = false;
        if ("Kontoinhaber".equals(string)) {
            bl = true;
        } else if ("Account holder".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static String formatDateForLog(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(1) + "-" + (gregorianCalendar.get(2) + 1) + "-" + gregorianCalendar.get(5);
    }

    public static BigDecimal formatBigDecimalForLog(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2);
    }

    public static String removeBOM(String string) {
        Charset charset = Charset.defaultCharset();
        String string2 = string;
        if (!CHARSET_UTF_8.equals(charset.toString())) {
            logger.log(Level.INFO, "Found charset: " + charset + ", trying to convert to UTF-8...");
            try {
                string2 = new String(string.getBytes(Charset.defaultCharset()), CHARSET_UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.log(Level.SEVERE, "Error while encoding String: " + string, unsupportedEncodingException);
            }
        }
        return string2.replace("\uefbbBF", "").replace("\ufffe", "").replace("\ufeff", "");
    }
}

