/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityQRestriction;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.LanguageConsistencyException;
import com.hp.hpl.jena.ontology.MaxCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityQRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.QualifiedRestriction;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.shared.ConfigException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.UniqueFilter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntModelImpl
extends ModelCom
implements OntModel {
    public static String owlSyntaxCheckerClassName = "com.hp.hpl.jena.ontology.tidy.JenaChecker";
    private static Logger s_log = LoggerFactory.getLogger(OntModelImpl.class);
    private static Class<?> owlSyntaxCheckerClass;
    protected OntModelSpec m_spec;
    protected Set<String> m_imported = new HashSet<String>();
    protected boolean m_strictMode = true;
    protected MultiUnion m_union = new MultiUnion();
    protected ImportsListener m_importsListener = null;
    private Model m_deductionsModel = null;

    public OntModelImpl(OntModelSpec spec, Model model) {
        this(spec, OntModelImpl.makeBaseModel(spec, model), true);
    }

    public OntModelImpl(OntModelSpec spec) {
        this(spec, spec.createBaseModel(), true);
    }

    private OntModelImpl(OntModelSpec spec, Model model, boolean withImports) {
        super(OntModelImpl.generateGraph(spec, model.getGraph()), BuiltinPersonalities.model);
        this.m_spec = spec;
        MultiUnion multiUnion = this.m_union = this.getGraph() instanceof MultiUnion ? (MultiUnion)this.getGraph() : (MultiUnion)((InfGraph)this.getGraph()).getRawGraph();
        if (withImports) {
            this.loadImports();
        }
        if (spec != null && spec.getKnownPrefixes() != null) {
            try {
                String[][] p = spec.getKnownPrefixes();
                for (int i = 0; i < p.length; ++i) {
                    String[] pair = p[i];
                    this.setNsPrefix(pair[0], pair[1]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.rebind();
    }

    @Override
    public OntDocumentManager getDocumentManager() {
        return this.m_spec.getDocumentManager();
    }

    @Override
    public ExtendedIterator<Ontology> listOntologies() {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return this.findByTypeAs(this.getProfile().ONTOLOGY(), Ontology.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<OntProperty> listOntProperties() {
        ExtendedIterator<OntProperty> i = this.findByTypeAs(RDF.Property, OntProperty.class).filterKeep(new UniqueFilter());
        if (this.getReasoner() != null && this.getProfile().equals(ProfileRegistry.getInstance().getProfile(ProfileRegistry.OWL_LANG))) {
            i = i.andThen(this.listAnnotationProperties());
        }
        return i;
    }

    @Override
    public ExtendedIterator<OntProperty> listAllOntProperties() {
        ExtendedIterator<OntProperty> i = this.findByTypeAs(RDF.Property, OntProperty.class).andThen(this.listObjectProperties()).andThen(this.listDatatypeProperties()).andThen(this.listAnnotationProperties()).andThen(this.listFunctionalProperties()).andThen(this.listTransitiveProperties()).andThen(this.listSymmetricProperties());
        return i.filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<ObjectProperty> listObjectProperties() {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        return this.findByTypeAs(this.getProfile().OBJECT_PROPERTY(), ObjectProperty.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<DatatypeProperty> listDatatypeProperties() {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        return this.findByTypeAs(this.getProfile().DATATYPE_PROPERTY(), DatatypeProperty.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<FunctionalProperty> listFunctionalProperties() {
        this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
        return this.findByTypeAs(this.getProfile().FUNCTIONAL_PROPERTY(), FunctionalProperty.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<TransitiveProperty> listTransitiveProperties() {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        return this.findByTypeAs(this.getProfile().TRANSITIVE_PROPERTY(), TransitiveProperty.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<SymmetricProperty> listSymmetricProperties() {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        return this.findByTypeAs(this.getProfile().SYMMETRIC_PROPERTY(), SymmetricProperty.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<InverseFunctionalProperty> listInverseFunctionalProperties() {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        return this.findByTypeAs(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), InverseFunctionalProperty.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<Individual> listIndividuals() {
        boolean supportsIndAsThing = false;
        if (this.getGraph() instanceof InfGraph) {
            supportsIndAsThing = ((InfGraph)this.getGraph()).getReasoner().getReasonerCapabilities().contains(null, ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP);
        }
        if (!supportsIndAsThing || this.getProfile().THING() == null || this.getProfile().CLASS().equals(RDFS.Class)) {
            HashSet<Individual> results = new HashSet<Individual>();
            StmtIterator i = this.listStatements(null, RDF.type, (RDFNode)null);
            while (i.hasNext()) {
                OntResource r = ((Statement)i.next()).getSubject().as(OntResource.class);
                if (!r.isIndividual()) continue;
                results.add(r.as(Individual.class));
            }
            return WrappedIterator.create(results.iterator());
        }
        return this.findByTypeAs(this.getProfile().THING(), Individual.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<Individual> listIndividuals(Resource cls) {
        return this.findByTypeAs(cls, Individual.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<OntClass> listClasses() {
        return this.findByTypeAs(this.getProfile().getClassDescriptionTypes(), OntClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<OntClass> listHierarchyRootClasses() {
        Model conf;
        if (this.getReasoner() != null && (conf = this.getReasoner().getReasonerCapabilities()) != null && conf.contains(null, ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubClassOf) && this.getProfile().THING() != null) {
            return this.listStatements(null, ReasonerVocabulary.directSubClassOf, this.getProfile().THING()).mapWith(new OntResourceImpl.SubjectAsMapper<OntClass>(OntClass.class));
        }
        return this.listClasses().filterDrop(new Filter<OntClass>(){

            @Override
            public boolean accept(OntClass o) {
                return o.isOntLanguageTerm();
            }
        }).filterKeep(new Filter<OntClass>(){

            @Override
            public boolean accept(OntClass o) {
                return o.isHierarchyRoot();
            }
        });
    }

    @Override
    public ExtendedIterator<EnumeratedClass> listEnumeratedClasses() {
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        return this.findByDefiningPropertyAs(this.getProfile().ONE_OF(), EnumeratedClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<UnionClass> listUnionClasses() {
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        return this.findByDefiningPropertyAs(this.getProfile().UNION_OF(), UnionClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<ComplementClass> listComplementClasses() {
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.findByDefiningPropertyAs(this.getProfile().COMPLEMENT_OF(), ComplementClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<IntersectionClass> listIntersectionClasses() {
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.findByDefiningPropertyAs(this.getProfile().INTERSECTION_OF(), IntersectionClass.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<OntClass> listNamedClasses() {
        return this.listClasses().filterDrop(new Filter<OntClass>(){

            @Override
            public boolean accept(OntClass x) {
                return x.isAnon();
            }
        });
    }

    @Override
    public ExtendedIterator<Restriction> listRestrictions() {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.findByTypeAs(this.getProfile().RESTRICTION(), Restriction.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<AllDifferent> listAllDifferent() {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        return this.findByTypeAs(this.getProfile().ALL_DIFFERENT(), AllDifferent.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<DataRange> listDataRanges() {
        this.checkProfileEntry(this.getProfile().DATARANGE(), "DATARANGE");
        return this.findByTypeAs(this.getProfile().DATARANGE(), DataRange.class).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<AnnotationProperty> listAnnotationProperties() {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        Resource r = this.getProfile().ANNOTATION_PROPERTY();
        if (r == null) {
            return new NullIterator<AnnotationProperty>();
        }
        return this.findByType(r).mapWith(new SubjectNodeAs<AnnotationProperty>(AnnotationProperty.class)).filterKeep(new UniqueFilter());
    }

    @Override
    public Ontology getOntology(String uri) {
        return (Ontology)this.findByURIAs(uri, Ontology.class);
    }

    @Override
    public Individual getIndividual(String uri) {
        return (Individual)this.findByURIAs(uri, Individual.class);
    }

    @Override
    public OntProperty getOntProperty(String uri) {
        return (OntProperty)this.findByURIAs(uri, OntProperty.class);
    }

    @Override
    public ObjectProperty getObjectProperty(String uri) {
        return (ObjectProperty)this.findByURIAs(uri, ObjectProperty.class);
    }

    @Override
    public TransitiveProperty getTransitiveProperty(String uri) {
        return (TransitiveProperty)this.findByURIAs(uri, TransitiveProperty.class);
    }

    @Override
    public SymmetricProperty getSymmetricProperty(String uri) {
        return (SymmetricProperty)this.findByURIAs(uri, SymmetricProperty.class);
    }

    @Override
    public InverseFunctionalProperty getInverseFunctionalProperty(String uri) {
        return (InverseFunctionalProperty)this.findByURIAs(uri, InverseFunctionalProperty.class);
    }

    @Override
    public DatatypeProperty getDatatypeProperty(String uri) {
        return (DatatypeProperty)this.findByURIAs(uri, DatatypeProperty.class);
    }

    @Override
    public AnnotationProperty getAnnotationProperty(String uri) {
        return (AnnotationProperty)this.findByURIAs(uri, AnnotationProperty.class);
    }

    @Override
    public OntClass getOntClass(String uri) {
        OntClass c = (OntClass)this.findByURIAs(uri, OntClass.class);
        if (c == null) {
            Resource nothing;
            Resource thing = this.getProfile().THING();
            if (thing != null && thing.getURI().equals(uri)) {
                c = thing.inModel(this).as(OntClass.class);
            }
            if ((nothing = this.getProfile().NOTHING()) != null && nothing.getURI().equals(uri)) {
                c = nothing.inModel(this).as(OntClass.class);
            }
        }
        return c;
    }

    @Override
    public ComplementClass getComplementClass(String uri) {
        return (ComplementClass)this.findByURIAs(uri, ComplementClass.class);
    }

    @Override
    public EnumeratedClass getEnumeratedClass(String uri) {
        return (EnumeratedClass)this.findByURIAs(uri, EnumeratedClass.class);
    }

    @Override
    public UnionClass getUnionClass(String uri) {
        return (UnionClass)this.findByURIAs(uri, UnionClass.class);
    }

    @Override
    public IntersectionClass getIntersectionClass(String uri) {
        return (IntersectionClass)this.findByURIAs(uri, IntersectionClass.class);
    }

    @Override
    public Restriction getRestriction(String uri) {
        return (Restriction)this.findByURIAs(uri, Restriction.class);
    }

    @Override
    public HasValueRestriction getHasValueRestriction(String uri) {
        return (HasValueRestriction)this.findByURIAs(uri, HasValueRestriction.class);
    }

    @Override
    public SomeValuesFromRestriction getSomeValuesFromRestriction(String uri) {
        return (SomeValuesFromRestriction)this.findByURIAs(uri, SomeValuesFromRestriction.class);
    }

    @Override
    public AllValuesFromRestriction getAllValuesFromRestriction(String uri) {
        return (AllValuesFromRestriction)this.findByURIAs(uri, AllValuesFromRestriction.class);
    }

    @Override
    public CardinalityRestriction getCardinalityRestriction(String uri) {
        return (CardinalityRestriction)this.findByURIAs(uri, CardinalityRestriction.class);
    }

    @Override
    public MinCardinalityRestriction getMinCardinalityRestriction(String uri) {
        return (MinCardinalityRestriction)this.findByURIAs(uri, MinCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityRestriction getMaxCardinalityRestriction(String uri) {
        return (MaxCardinalityRestriction)this.findByURIAs(uri, MaxCardinalityRestriction.class);
    }

    @Override
    public QualifiedRestriction getQualifiedRestriction(String uri) {
        return (QualifiedRestriction)this.findByURIAs(uri, QualifiedRestriction.class);
    }

    @Override
    public CardinalityQRestriction getCardinalityQRestriction(String uri) {
        return (CardinalityQRestriction)this.findByURIAs(uri, CardinalityQRestriction.class);
    }

    @Override
    public MinCardinalityQRestriction getMinCardinalityQRestriction(String uri) {
        return (MinCardinalityQRestriction)this.findByURIAs(uri, MinCardinalityQRestriction.class);
    }

    @Override
    public MaxCardinalityQRestriction getMaxCardinalityQRestriction(String uri) {
        return (MaxCardinalityQRestriction)this.findByURIAs(uri, MaxCardinalityQRestriction.class);
    }

    @Override
    public Ontology createOntology(String uri) {
        this.checkProfileEntry(this.getProfile().ONTOLOGY(), "ONTOLOGY");
        return this.createOntResource(Ontology.class, this.getProfile().ONTOLOGY(), uri);
    }

    @Override
    public Individual createIndividual(Resource cls) {
        return this.createOntResource(Individual.class, cls, null);
    }

    @Override
    public Individual createIndividual(String uri, Resource cls) {
        return this.createOntResource(Individual.class, cls, uri);
    }

    @Override
    public OntProperty createOntProperty(String uri) {
        Property p = this.createProperty(uri);
        p.addProperty(RDF.type, this.getProfile().PROPERTY());
        return p.as(OntProperty.class);
    }

    @Override
    public ObjectProperty createObjectProperty(String uri) {
        return this.createObjectProperty(uri, false);
    }

    @Override
    public ObjectProperty createObjectProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY");
        ObjectProperty p = this.createOntResource(ObjectProperty.class, this.getProfile().OBJECT_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    @Override
    public TransitiveProperty createTransitiveProperty(String uri) {
        return this.createTransitiveProperty(uri, false);
    }

    @Override
    public TransitiveProperty createTransitiveProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY");
        TransitiveProperty p = this.createOntResource(TransitiveProperty.class, this.getProfile().TRANSITIVE_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    @Override
    public SymmetricProperty createSymmetricProperty(String uri) {
        return this.createSymmetricProperty(uri, false);
    }

    @Override
    public SymmetricProperty createSymmetricProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY");
        SymmetricProperty p = this.createOntResource(SymmetricProperty.class, this.getProfile().SYMMETRIC_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    @Override
    public InverseFunctionalProperty createInverseFunctionalProperty(String uri) {
        return this.createInverseFunctionalProperty(uri, false);
    }

    @Override
    public InverseFunctionalProperty createInverseFunctionalProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY");
        InverseFunctionalProperty p = this.createOntResource(InverseFunctionalProperty.class, this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    @Override
    public DatatypeProperty createDatatypeProperty(String uri) {
        return this.createDatatypeProperty(uri, false);
    }

    @Override
    public DatatypeProperty createDatatypeProperty(String uri, boolean functional) {
        this.checkProfileEntry(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY");
        DatatypeProperty p = this.createOntResource(DatatypeProperty.class, this.getProfile().DATATYPE_PROPERTY(), uri);
        if (functional) {
            this.checkProfileEntry(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY");
            p.addProperty(RDF.type, this.getProfile().FUNCTIONAL_PROPERTY());
        }
        return p;
    }

    @Override
    public AnnotationProperty createAnnotationProperty(String uri) {
        this.checkProfileEntry(this.getProfile().ANNOTATION_PROPERTY(), "ANNOTATION_PROPERTY");
        return this.createOntResource(AnnotationProperty.class, this.getProfile().ANNOTATION_PROPERTY(), uri);
    }

    @Override
    public OntClass createClass() {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return this.createOntResource(OntClass.class, this.getProfile().CLASS(), null);
    }

    @Override
    public OntClass createClass(String uri) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        return this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
    }

    @Override
    public ComplementClass createComplementClass(String uri, Resource cls) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        c.addProperty(this.getProfile().COMPLEMENT_OF(), cls == null ? this.getProfile().NOTHING() : cls);
        return c.as(ComplementClass.class);
    }

    @Override
    public EnumeratedClass createEnumeratedClass(String uri, RDFList members) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        c.addProperty(this.getProfile().ONE_OF(), members == null ? this.createList() : members);
        return c.as(EnumeratedClass.class);
    }

    @Override
    public UnionClass createUnionClass(String uri, RDFList members) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().UNION_OF(), "UNION_OF");
        c.addProperty(this.getProfile().UNION_OF(), members == null ? this.createList() : members);
        return c.as(UnionClass.class);
    }

    @Override
    public IntersectionClass createIntersectionClass(String uri, RDFList members) {
        this.checkProfileEntry(this.getProfile().CLASS(), "CLASS");
        OntClass c = this.createOntResource(OntClass.class, this.getProfile().CLASS(), uri);
        this.checkProfileEntry(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        c.addProperty(this.getProfile().INTERSECTION_OF(), members == null ? this.createList() : members);
        return c.as(IntersectionClass.class);
    }

    @Override
    public Restriction createRestriction(Property p) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), null);
        if (p != null) {
            r.setOnProperty(p);
        }
        return r;
    }

    @Override
    public Restriction createRestriction(String uri, Property p) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (p != null) {
            r.setOnProperty(p);
        }
        return r;
    }

    @Override
    public HasValueRestriction createHasValueRestriction(String uri, Property prop, RDFNode value) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null || value == null) {
            throw new IllegalArgumentException("Cannot create hasValueRestriction with a null property or value");
        }
        this.checkProfileEntry(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().HAS_VALUE(), value);
        return r.as(HasValueRestriction.class);
    }

    @Override
    public SomeValuesFromRestriction createSomeValuesFromRestriction(String uri, Property prop, Resource cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null || cls == null) {
            throw new IllegalArgumentException("Cannot create someValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().SOME_VALUES_FROM(), cls);
        return r.as(SomeValuesFromRestriction.class);
    }

    @Override
    public AllValuesFromRestriction createAllValuesFromRestriction(String uri, Property prop, Resource cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null || cls == null) {
            throw new IllegalArgumentException("Cannot create allValuesFromRestriction with a null property or class");
        }
        this.checkProfileEntry(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().ALL_VALUES_FROM(), cls);
        return r.as(AllValuesFromRestriction.class);
    }

    @Override
    public CardinalityRestriction createCardinalityRestriction(String uri, Property prop, int cardinality) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create cardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().CARDINALITY(), "CARDINALITY");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().CARDINALITY(), this.createTypedLiteral(cardinality));
        return r.as(CardinalityRestriction.class);
    }

    @Override
    public MinCardinalityRestriction createMinCardinalityRestriction(String uri, Property prop, int cardinality) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create minCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MIN_CARDINALITY(), this.createTypedLiteral(cardinality));
        return r.as(MinCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityRestriction createMaxCardinalityRestriction(String uri, Property prop, int cardinality) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create maxCardinalityRestriction with a null property");
        }
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MAX_CARDINALITY(), this.createTypedLiteral(cardinality));
        return r.as(MaxCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityQRestriction createMaxCardinalityQRestriction(String uri, Property prop, int cardinality, OntClass cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create MaxCardinalityQRestriction with a null property");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot create MaxCardinalityQRestriction with a null class");
        }
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MAX_CARDINALITY_Q(), this.createTypedLiteral(cardinality));
        r.addProperty(this.getProfile().HAS_CLASS_Q(), cls);
        return r.as(MaxCardinalityQRestriction.class);
    }

    @Override
    public MinCardinalityQRestriction createMinCardinalityQRestriction(String uri, Property prop, int cardinality, OntClass cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().MIN_CARDINALITY_Q(), "MIN_CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create MinCardinalityQRestriction with a null property");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot create MinCardinalityQRestriction with a null class");
        }
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().MIN_CARDINALITY_Q(), this.createTypedLiteral(cardinality));
        r.addProperty(this.getProfile().HAS_CLASS_Q(), cls);
        return r.as(MinCardinalityQRestriction.class);
    }

    @Override
    public CardinalityQRestriction createCardinalityQRestriction(String uri, Property prop, int cardinality, OntClass cls) {
        this.checkProfileEntry(this.getProfile().RESTRICTION(), "RESTRICTION");
        this.checkProfileEntry(this.getProfile().ON_PROPERTY(), "ON_PROPERTY");
        this.checkProfileEntry(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q");
        this.checkProfileEntry(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        if (prop == null) {
            throw new IllegalArgumentException("Cannot create CardinalityQRestriction with a null property");
        }
        if (cls == null) {
            throw new IllegalArgumentException("Cannot create CardinalityQRestriction with a null class");
        }
        Restriction r = this.createOntResource(Restriction.class, this.getProfile().RESTRICTION(), uri);
        r.addProperty(this.getProfile().ON_PROPERTY(), prop);
        r.addProperty(this.getProfile().CARDINALITY_Q(), this.createTypedLiteral(cardinality));
        r.addProperty(this.getProfile().HAS_CLASS_Q(), cls);
        return r.as(CardinalityQRestriction.class);
    }

    @Override
    public DataRange createDataRange(RDFList literals) {
        this.checkProfileEntry(this.getProfile().DATARANGE(), "DATARANGE");
        DataRange d = this.createOntResource(DataRange.class, this.getProfile().DATARANGE(), null);
        this.checkProfileEntry(this.getProfile().ONE_OF(), "ONE_OF");
        d.addProperty(this.getProfile().ONE_OF(), literals == null ? this.createList() : literals);
        return d;
    }

    @Override
    public AllDifferent createAllDifferent() {
        return this.createAllDifferent(null);
    }

    @Override
    public AllDifferent createAllDifferent(RDFList differentMembers) {
        this.checkProfileEntry(this.getProfile().ALL_DIFFERENT(), "ALL_DIFFERENT");
        AllDifferent ad = this.createOntResource(AllDifferent.class, this.getProfile().ALL_DIFFERENT(), null);
        ad.setDistinctMembers(differentMembers == null ? this.createList() : differentMembers);
        return ad;
    }

    @Override
    public <T extends OntResource> T createOntResource(Class<T> javaClass, Resource rdfType, String uri) {
        return (T)((OntResource)this.getResourceWithType(uri, rdfType).as(javaClass));
    }

    @Override
    public OntResource createOntResource(String uri) {
        return this.getResource(uri).as(OntResource.class);
    }

    @Override
    public RDFList createList() {
        Resource list = this.getResource(this.getProfile().NIL().getURI());
        return list.as(RDFList.class);
    }

    @Override
    public Profile getProfile() {
        return this.m_spec.getProfile();
    }

    @Override
    public void loadImports() {
        this.getDocumentManager().loadImports(this);
    }

    @Override
    public boolean hasLoadedImport(String uri) {
        return this.m_imported.contains(uri);
    }

    @Override
    public void addLoadedImport(String uri) {
        this.m_imported.add(uri);
    }

    @Override
    public void removeLoadedImport(String uri) {
        this.m_imported.remove(uri);
    }

    @Override
    public Set<String> listImportedOntologyURIs() {
        return this.listImportedOntologyURIs(false);
    }

    @Override
    public Set<String> listImportedOntologyURIs(boolean closure) {
        HashSet<String> results = new HashSet<String>();
        ArrayList<Model> queue = new ArrayList<Model>();
        queue.add(this.getBaseModel());
        while (!queue.isEmpty()) {
            Model m = (Model)queue.remove(0);
            if (this.getProfile().ONTOLOGY() == null || this.getProfile().IMPORTS() == null) continue;
            StmtIterator i = m.listStatements(null, this.getProfile().IMPORTS(), (RDFNode)null);
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                String uri = s.getResource().getURI();
                if (results.contains(uri)) continue;
                results.add(uri);
                Model mi = this.getDocumentManager().getModel(uri);
                if (!closure || mi == null || queue.contains(mi)) continue;
                queue.add(mi);
            }
        }
        return results;
    }

    @Override
    public ModelMaker getImportModelMaker() {
        return this.m_spec.getImportModelMaker();
    }

    @Override
    @Deprecated
    public ModelMaker getModelMaker() {
        return this.getImportModelMaker();
    }

    @Override
    public Model read(String uri) {
        return this.read(uri, null, null);
    }

    @Override
    public Model read(Reader reader, String base) {
        super.read(reader, base);
        this.loadImports();
        this.rebind();
        return this;
    }

    @Override
    public Model read(InputStream reader, String base) {
        super.read(reader, base);
        this.loadImports();
        this.rebind();
        return this;
    }

    @Override
    public Model read(String uri, String syntax) {
        return this.read(uri, null, syntax);
    }

    @Override
    public Model read(String uri, String base, String syntax) {
        this.addLoadedImport(uri);
        OntDocumentManager odm = this.getDocumentManager();
        String sourceURL = odm.doAltURLMapping(uri);
        String source = odm.getReadHook().beforeRead(this, sourceURL, odm);
        if (source == null) {
            s_log.warn("ReadHook returned null, so skipping assuming previous value: " + sourceURL);
            source = sourceURL;
        } else if (base == null && !this.ignoreFileURI(source) && source.equals(uri)) {
            if (syntax == null) {
                this.readDelegate(source);
            } else {
                this.readDelegate(source, syntax);
            }
        } else {
            this.readDelegate(source, base == null ? uri : base, syntax);
        }
        odm.getReadHook().afterRead(this, source, odm);
        this.getDocumentManager().addModel(uri, this);
        this.loadImports();
        this.rebind();
        return this;
    }

    @Override
    public Model read(Reader reader, String base, String syntax) {
        super.read(reader, base, syntax);
        this.loadImports();
        this.rebind();
        return this;
    }

    @Override
    public Model read(InputStream reader, String base, String syntax) {
        super.read(reader, base, syntax);
        this.loadImports();
        this.rebind();
        return this;
    }

    @Override
    public List<Graph> getSubGraphs() {
        return this.getUnionGraph().getSubGraphs();
    }

    @Override
    @Deprecated
    public ExtendedIterator<OntModel> listImportedModels() {
        return this.listSubModels(true);
    }

    @Override
    public ExtendedIterator<OntModel> listSubModels(final boolean withImports) {
        ExtendedIterator<Graph> i = WrappedIterator.create(this.getSubGraphs().iterator());
        return i.mapWith(new Map1<Graph, OntModel>(){

            @Override
            public OntModel map1(Graph o) {
                Model base = ModelFactory.createModelForGraph(o);
                OntModelImpl om = new OntModelImpl(OntModelImpl.this.m_spec, base, withImports);
                return om;
            }
        });
    }

    @Override
    public ExtendedIterator<OntModel> listSubModels() {
        return this.listSubModels(false);
    }

    @Override
    public int countSubModels() {
        int count = 0;
        Iterator<Graph> i = this.getSubGraphs().iterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    @Override
    public OntModel getImportedModel(String uri) {
        Model mi;
        if (this.listImportedOntologyURIs(true).contains(uri) && (mi = this.getDocumentManager().getModel(uri)) != null) {
            if (mi instanceof OntModel) {
                return (OntModel)mi;
            }
            return ModelFactory.createOntologyModel(this.m_spec, mi);
        }
        return null;
    }

    public Graph getBaseGraph() {
        return this.getUnionGraph().getBaseGraph();
    }

    @Override
    public Model getBaseModel() {
        return ModelFactory.createModelForGraph(this.getBaseGraph());
    }

    @Override
    public void addSubModel(Model model) {
        this.addSubModel(model, true);
    }

    @Override
    public void addSubModel(Model model, boolean rebind) {
        this.getUnionGraph().addGraph(model.getGraph());
        if (rebind) {
            this.rebind();
        }
    }

    @Override
    public void removeSubModel(Model model) {
        this.removeSubModel(model, true);
    }

    @Override
    public void removeSubModel(Model model, boolean rebind) {
        Graph subG = model.getGraph();
        this.getUnionGraph().removeGraph(subG);
        if (subG instanceof MultiUnion) {
            this.getUnionGraph().removeGraph(((MultiUnion)subG).getBaseGraph());
        }
        if (rebind) {
            this.rebind();
        }
    }

    @Override
    public boolean isInBaseModel(RDFNode node) {
        Node n = node.asNode();
        Graph b = this.getBaseGraph();
        return b.contains(n, Node.ANY, Node.ANY) || b.contains(Node.ANY, n, Node.ANY) || b.contains(Node.ANY, Node.ANY, n);
    }

    @Override
    public boolean isInBaseModel(Statement stmt) {
        Node s = stmt.getSubject().asNode();
        Node p = stmt.getPredicate().asNode();
        Node o = stmt.getObject().asNode();
        Graph b = this.getBaseGraph();
        return b.contains(s, p, o);
    }

    @Override
    public boolean strictMode() {
        return this.m_strictMode;
    }

    @Override
    public void setStrictMode(boolean strict) {
        this.m_strictMode = strict;
    }

    @Override
    public void setDynamicImports(boolean dynamic) {
        if (dynamic) {
            if (this.m_importsListener == null) {
                this.m_importsListener = new ImportsListener();
                this.register(this.m_importsListener);
            }
        } else if (this.m_importsListener != null) {
            this.unregister(this.m_importsListener);
            this.m_importsListener = null;
        }
    }

    @Override
    public boolean getDynamicImports() {
        return this.m_importsListener != null;
    }

    @Override
    public OntModelSpec getSpecification() {
        return this.m_spec;
    }

    @Override
    public Model write(Writer writer) {
        return this.getBaseModel().write(writer);
    }

    @Override
    public Model write(Writer writer, String lang) {
        return this.getBaseModel().write(writer, lang);
    }

    @Override
    public Model write(Writer writer, String lang, String base) {
        return this.getBaseModel().write(writer, lang, base);
    }

    @Override
    public Model write(OutputStream out) {
        return this.getBaseModel().write(out);
    }

    @Override
    public Model write(OutputStream out, String lang) {
        return this.getBaseModel().write(out, lang);
    }

    @Override
    public Model write(OutputStream out, String lang, String base) {
        return this.getBaseModel().write(out, lang, base);
    }

    @Override
    public Model writeAll(Writer writer, String lang, String base) {
        return super.write(writer, lang, base);
    }

    @Override
    public Model writeAll(OutputStream out, String lang, String base) {
        return super.write(out, lang, base);
    }

    @Override
    public Model writeAll(Writer writer, String lang) {
        return super.write(writer, lang);
    }

    @Override
    public Model writeAll(OutputStream out, String lang) {
        return super.write(out, lang);
    }

    @Override
    public Model getRawModel() {
        return this.getBaseModel();
    }

    @Override
    public Reasoner getReasoner() {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getReasoner() : null;
    }

    @Override
    public void rebind() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).rebind();
        }
    }

    @Override
    public void prepare() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).prepare();
        }
    }

    @Override
    public void reset() {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).reset();
        }
    }

    @Override
    public Model getDeductionsModel() {
        if (this.m_deductionsModel == null) {
            Graph deductionsGraph;
            InfGraph infGraph = this.getInfGraph();
            if (infGraph != null && (deductionsGraph = infGraph.getDeductionsGraph()) != null) {
                this.m_deductionsModel = ModelFactory.createModelForGraph(deductionsGraph);
            }
        } else {
            this.getInfGraph().prepare();
        }
        return this.m_deductionsModel;
    }

    @Override
    public ValidityReport validate() {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).validate() : null;
    }

    @Override
    public StmtIterator listStatements(Resource subject, Property predicate, RDFNode object, Model posit) {
        if (this.getGraph() instanceof InfGraph) {
            Graph gp = posit == null ? ModelFactory.createDefaultModel().getGraph() : posit.getGraph();
            ExtendedIterator<Triple> iter = this.getInfGraph().find(OntModelImpl.asNode(subject), OntModelImpl.asNode(predicate), OntModelImpl.asNode(object), gp);
            return IteratorFactory.asStmtIterator(iter, this);
        }
        return null;
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        if (this.getGraph() instanceof InfGraph) {
            ((InfGraph)this.getGraph()).setDerivationLogging(logOn);
        }
    }

    @Override
    public Iterator<Derivation> getDerivation(Statement statement) {
        return this.getGraph() instanceof InfGraph ? ((InfGraph)this.getGraph()).getDerivation(statement.asTriple()) : null;
    }

    private static void initSyntaxCheckerClass() {
        if (owlSyntaxCheckerClass == null) {
            try {
                owlSyntaxCheckerClass = Class.forName(owlSyntaxCheckerClassName);
                owlSyntaxCheckerClass.newInstance();
            }
            catch (Exception e2) {
                throw new ConfigException("owlsyntax.jar must be on the classpath.", e2);
            }
        }
    }

    private static Graph generateGraph(OntModelSpec spec, Graph base) {
        MultiUnion u = new MultiUnion();
        u.addGraph(base);
        u.setBaseGraph(base);
        Reasoner r = spec.getReasoner();
        return r == null ? u : r.bind(u);
    }

    protected MultiUnion getUnionGraph() {
        return this.m_union;
    }

    protected <T extends Resource> Resource findByURIAs(String uri, Class<T> asKey) {
        if (uri == null) {
            throw new IllegalArgumentException("Cannot get() ontology value with a null URI");
        }
        Node n = NodeFactory.createURI(uri);
        if (this.getGraph().contains(n, Node.ANY, Node.ANY)) {
            try {
                return (Resource)this.getNodeAs(n, asKey);
            }
            catch (ConversionException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    protected ExtendedIterator<Triple> findByType(Resource type) {
        return this.getGraph().find(null, RDF.type.asNode(), type.asNode());
    }

    protected ExtendedIterator<Triple> findByType(Resource type, Iterator<Resource> alternates) {
        ExtendedIterator<Triple> i = this.findByType(type);
        if (alternates != null) {
            while (alternates.hasNext()) {
                i = i.andThen(this.findByType(alternates.next()));
            }
        }
        return i.filterKeep(new UniqueFilter());
    }

    protected <T extends RDFNode> ExtendedIterator<T> findByTypeAs(Resource type, Iterator<Resource> types, Class<T> asKey) {
        return this.findByType(type, types).mapWith(new SubjectNodeAs<T>(asKey));
    }

    protected <T extends RDFNode> ExtendedIterator<T> findByTypeAs(Iterator<Resource> types, Class<T> asKey) {
        return this.findByTypeAs(types.next(), types, asKey);
    }

    protected <T extends RDFNode> ExtendedIterator<T> findByTypeAs(Resource type, Class<T> asKey) {
        return this.findByType(type).mapWith(new SubjectNodeAs<T>(asKey));
    }

    protected ExtendedIterator<Triple> findByDefiningProperty(Property p) {
        return this.getGraph().find(null, p.asNode(), null);
    }

    protected <T extends RDFNode> ExtendedIterator<T> findByDefiningPropertyAs(Property p, Class<T> asKey) {
        return this.findByDefiningProperty(p).mapWith(new SubjectNodeAs<T>(asKey));
    }

    protected Resource getResourceWithType(String uri, Resource rdfType) {
        Resource r = this.getResource(uri);
        if (rdfType != null) {
            r.addProperty(RDF.type, rdfType);
        }
        return r;
    }

    @Override
    public OntResource getOntResource(String uri) {
        Resource r = this.getResource(uri);
        if (this.containsResource(r)) {
            return r.as(OntResource.class);
        }
        return null;
    }

    @Override
    public OntResource getOntResource(Resource res) {
        return res.inModel(this).as(OntResource.class);
    }

    protected void checkProfileEntry(Object profileTerm, String desc) {
        if (profileTerm == null) {
            throw new ProfileException(desc, this.getProfile());
        }
    }

    protected void checkListMembersRdfType(RDFList list, Resource rdfType) {
        if (this.strictMode() && !((Boolean)list.reduce(new RdfTypeTestFn(rdfType), Boolean.TRUE)).booleanValue()) {
            throw new LanguageConsistencyException("The members of the given list are expected to be of rdf:type " + rdfType.toString());
        }
    }

    private static Model makeBaseModel(OntModelSpec spec, Model model) {
        return model == null ? spec.createBaseModel() : model;
    }

    private InfGraph getInfGraph() {
        return this.getGraph() instanceof InfGraph ? (InfGraph)this.getGraph() : null;
    }

    protected boolean ignoreFileURI(String source) {
        return source.startsWith("file:");
    }

    protected Model readDelegate(String url) {
        return super.read(url);
    }

    protected Model readDelegate(String url, String lang) {
        return super.read(url, lang);
    }

    protected Model readDelegate(String url, String base, String lang) {
        return super.read(url, base, lang);
    }

    protected class ImportsListener
    extends StatementListener {
        protected ImportsListener() {
        }

        @Override
        public void addedStatement(Statement added) {
            if (added.getPredicate().equals(OntModelImpl.this.getProfile().IMPORTS())) {
                OntModelImpl.this.getDocumentManager().loadImport(OntModelImpl.this, added.getResource().getURI());
            }
        }

        @Override
        public void removedStatement(Statement removed) {
            if (removed.getPredicate().equals(OntModelImpl.this.getProfile().IMPORTS())) {
                OntModelImpl.this.getDocumentManager().unloadImport(OntModelImpl.this, removed.getResource().getURI());
            }
        }
    }

    protected class RdfTypeTestFn
    implements RDFList.ReduceFn {
        protected Resource m_type;

        protected RdfTypeTestFn(Resource type) {
            this.m_type = type;
        }

        @Override
        public Object reduce(RDFNode node, Object accumulator) {
            Boolean acc = (Boolean)accumulator;
            if (acc.booleanValue()) {
                Resource r = (Resource)node;
                return new Boolean(r.hasProperty(RDF.type, this.m_type));
            }
            return acc;
        }
    }

    protected class SubjectNodeCanAs<T extends RDFNode>
    extends Filter<T> {
        protected Class<T> m_asKey;

        protected SubjectNodeCanAs(Class<T> asKey) {
            this.m_asKey = asKey;
        }

        @Override
        public boolean accept(T x) {
            Node n = x instanceof Triple ? ((Triple)x).getSubject() : (x instanceof EnhNode ? ((EnhNode)x).asNode() : (Node)x);
            try {
                OntModelImpl.this.getNodeAs(n, this.m_asKey);
            }
            catch (Exception ignore) {
                return false;
            }
            return true;
        }
    }

    protected class NodeCanAs<T extends RDFNode>
    extends Filter<Node> {
        protected Class<T> m_asKey;

        protected NodeCanAs(Class<T> asKey) {
            this.m_asKey = asKey;
        }

        @Override
        public boolean accept(Node x) {
            try {
                OntModelImpl.this.getNodeAs(x, this.m_asKey);
            }
            catch (Exception ignore) {
                return false;
            }
            return true;
        }
    }

    protected class NodeAs<To extends RDFNode>
    implements Map1<Node, To> {
        protected Class<To> m_asKey;

        protected NodeAs(Class<To> asKey) {
            this.m_asKey = asKey;
        }

        @Override
        public To map1(Node x) {
            return OntModelImpl.this.getNodeAs(x, this.m_asKey);
        }
    }

    protected class SubjectNodeAs<To extends RDFNode>
    implements Map1<Triple, To> {
        protected Class<To> m_asKey;

        protected SubjectNodeAs(Class<To> asKey) {
            this.m_asKey = asKey;
        }

        @Override
        public To map1(Triple x) {
            return OntModelImpl.this.getNodeAs(x.getSubject(), this.m_asKey);
        }
    }
}

