/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormFixedTextElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
extends FormControl {
    Label(FormFixedTextElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static Label getInstanceOf(FormFixedTextElement element) {
        Label label = new Label(element);
        try {
            label.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e2) {
            Logger.getLogger(Label.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this label.");
        }
        return label;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormFixedTextElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public String getId() {
        return ((FormFixedTextElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public void setId(String id) {
        ((FormFixedTextElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormFixedTextElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    @Override
    public String getName() {
        return ((FormFixedTextElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormFixedTextElement)this.mElement).setFormNameAttribute(name);
    }

    public void setLabel(String label) {
        ((FormFixedTextElement)this.mElement).setFormLabelAttribute(label);
    }

    public String getLabel() {
        return ((FormFixedTextElement)this.mElement).getFormLabelAttribute();
    }

    public static Iterator<FormControl> getSimpleIterator(Form container2) {
        return new SimpleLabelIterator(container2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleLabelIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private Label nextElement = null;
        private Label tempElement = null;

        private SimpleLabelIterator(Form container2) {
            this.containerElement = container2.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Label next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private Label findNext(Label thisLabel) {
            FormFixedTextElement nextLabel = null;
            nextLabel = thisLabel == null ? OdfElement.findFirstChildNode(FormFixedTextElement.class, this.containerElement) : OdfElement.findNextChildNode(FormFixedTextElement.class, thisLabel.getOdfElement());
            if (nextLabel != null) {
                return Label.getInstanceOf(nextLabel);
            }
            return null;
        }
    }
}

