/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.util.LittleEndian;

public class CryptoFunctions {
    public static byte[] hashPassword(String password, HashAlgorithm hashAlgorithm, byte[] salt, int spinCount) {
        if (password == null) {
            password = "VelvetSweatshop";
        }
        MessageDigest hashAlg = CryptoFunctions.getMessageDigest(hashAlgorithm);
        hashAlg.update(salt);
        byte[] hash = hashAlg.digest(CryptoFunctions.getUtf16LeString(password));
        byte[] iterator = new byte[4];
        try {
            for (int i = 0; i < spinCount; ++i) {
                LittleEndian.putInt(iterator, 0, i);
                hashAlg.reset();
                hashAlg.update(iterator);
                hashAlg.update(hash);
                hashAlg.digest(hash, 0, hash.length);
            }
        }
        catch (DigestException e2) {
            throw new EncryptedDocumentException("error in password hashing");
        }
        return hash;
    }

    public static byte[] generateIv(HashAlgorithm hashAlgorithm, byte[] salt, byte[] blockKey, int blockSize) {
        byte[] iv = salt;
        if (blockKey != null) {
            MessageDigest hashAlgo = CryptoFunctions.getMessageDigest(hashAlgorithm);
            hashAlgo.update(salt);
            iv = hashAlgo.digest(blockKey);
        }
        return CryptoFunctions.getBlock36(iv, blockSize);
    }

    public static byte[] generateKey(byte[] passwordHash, HashAlgorithm hashAlgorithm, byte[] blockKey, int keySize) {
        MessageDigest hashAlgo = CryptoFunctions.getMessageDigest(hashAlgorithm);
        hashAlgo.update(passwordHash);
        byte[] key = hashAlgo.digest(blockKey);
        return CryptoFunctions.getBlock36(key, keySize);
    }

    public static Cipher getCipher(SecretKey key, CipherAlgorithm cipherAlgorithm, ChainingMode chain, byte[] vec, int cipherMode) {
        return CryptoFunctions.getCipher(key, cipherAlgorithm, chain, vec, cipherMode, null);
    }

    public static Cipher getCipher(SecretKey key, CipherAlgorithm cipherAlgorithm, ChainingMode chain, byte[] vec, int cipherMode, String padding) {
        int keySizeInBytes = key.getEncoded().length;
        if (padding == null) {
            padding = "NoPadding";
        }
        try {
            Cipher cipher;
            if (Cipher.getMaxAllowedKeyLength(key.getAlgorithm()) < keySizeInBytes * 8) {
                throw new EncryptedDocumentException("Export Restrictions in place - please install JCE Unlimited Strength Jurisdiction Policy files");
            }
            if (cipherAlgorithm.needsBouncyCastle) {
                CryptoFunctions.registerBouncyCastle();
                cipher = Cipher.getInstance(key.getAlgorithm() + "/" + chain.jceId + "/" + padding, "BC");
            } else {
                cipher = Cipher.getInstance(key.getAlgorithm() + "/" + chain.jceId + "/" + padding);
            }
            if (vec == null) {
                cipher.init(cipherMode, key);
            } else {
                AlgorithmParameterSpec aps = cipherAlgorithm == CipherAlgorithm.rc2 ? new RC2ParameterSpec(key.getEncoded().length * 8, vec) : new IvParameterSpec(vec);
                cipher.init(cipherMode, (Key)key, aps);
            }
            return cipher;
        }
        catch (GeneralSecurityException e2) {
            throw new EncryptedDocumentException(e2);
        }
    }

    public static byte[] getBlock36(byte[] hash, int size) {
        return CryptoFunctions.getBlockX(hash, size, (byte)54);
    }

    public static byte[] getBlock0(byte[] hash, int size) {
        return CryptoFunctions.getBlockX(hash, size, (byte)0);
    }

    private static byte[] getBlockX(byte[] hash, int size, byte fill) {
        if (hash.length == size) {
            return hash;
        }
        byte[] result = new byte[size];
        Arrays.fill(result, fill);
        System.arraycopy(hash, 0, result, 0, Math.min(result.length, hash.length));
        return result;
    }

    public static byte[] getUtf16LeString(String str2) {
        try {
            return str2.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e2) {
            throw new EncryptedDocumentException(e2);
        }
    }

    public static MessageDigest getMessageDigest(HashAlgorithm hashAlgorithm) {
        try {
            if (hashAlgorithm.needsBouncyCastle) {
                CryptoFunctions.registerBouncyCastle();
                return MessageDigest.getInstance(hashAlgorithm.jceId, "BC");
            }
            return MessageDigest.getInstance(hashAlgorithm.jceId);
        }
        catch (GeneralSecurityException e2) {
            throw new EncryptedDocumentException("hash algo not supported", e2);
        }
    }

    public static Mac getMac(HashAlgorithm hashAlgorithm) {
        try {
            if (hashAlgorithm.needsBouncyCastle) {
                CryptoFunctions.registerBouncyCastle();
                return Mac.getInstance(hashAlgorithm.jceHmacId, "BC");
            }
            return Mac.getInstance(hashAlgorithm.jceHmacId);
        }
        catch (GeneralSecurityException e2) {
            throw new EncryptedDocumentException("hmac algo not supported", e2);
        }
    }

    private static void registerBouncyCastle() {
        if (Security.getProvider("BC") != null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Security.addProvider((Provider)clazz.newInstance());
        }
        catch (Exception e2) {
            throw new EncryptedDocumentException("Only the BouncyCastle provider supports your encryption settings - please add it to the classpath.");
        }
    }
}

