/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.vocabulary.DC_11;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Map;

public interface PrefixMapping {
    public static final PrefixMapping Standard = Factory.create().setNsPrefix("rdfs", RDFS.getURI()).setNsPrefix("rdf", RDF.getURI()).setNsPrefix("dc", DC_11.getURI()).setNsPrefix("owl", OWL.getURI()).setNsPrefix("xsd", XSD.getURI()).lock();
    public static final PrefixMapping Extended = Factory.create().setNsPrefixes(Standard).setNsPrefix("rss", RSS.getURI()).setNsPrefix("vcard", VCARD.getURI()).setNsPrefix("ja", JA.getURI()).setNsPrefix("eg", "http://www.example.org/").lock();

    public PrefixMapping setNsPrefix(String var1, String var2);

    public PrefixMapping removeNsPrefix(String var1);

    public PrefixMapping setNsPrefixes(PrefixMapping var1);

    public PrefixMapping setNsPrefixes(Map<String, String> var1);

    public PrefixMapping withDefaultMappings(PrefixMapping var1);

    public String getNsPrefixURI(String var1);

    public String getNsURIPrefix(String var1);

    public Map<String, String> getNsPrefixMap();

    public String expandPrefix(String var1);

    public String shortForm(String var1);

    public String qnameFor(String var1);

    public PrefixMapping lock();

    public boolean samePrefixMappingAs(PrefixMapping var1);

    public static class Factory {
        public static PrefixMapping create() {
            return new PrefixMappingImpl();
        }
    }

    public static class JenaLockedException
    extends JenaException {
        public JenaLockedException(PrefixMapping pm) {
            super(pm.toString());
        }
    }

    public static class IllegalPrefixException
    extends JenaException {
        public IllegalPrefixException(String prefixName) {
            super(prefixName);
        }
    }
}

