/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormattedTextElement;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Field;

public class TimeField
extends Field {
    TimeField(FormFormattedTextElement element) {
        super(element);
    }

    public static TimeField getInstanceOf(FormFormattedTextElement element) {
        TimeField field = new TimeField(element);
        try {
            field.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e2) {
            Logger.getLogger(TimeField.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this field.");
        }
        return field;
    }

    public void setTimeFormat(String formatStr, Locale locale) {
        this.setFormatString(formatStr, OfficeValueTypeAttribute.Value.TIME, locale);
    }

    public void formatTime(String formatStr, Locale locale) {
        if (this.drawingShape == null) {
            throw new IllegalStateException("Please call loadDrawControl() first.");
        }
        DrawControlElement element = this.drawingShape.getOdfElement();
        String name = this.getUniqueTimeStyleName();
        OdfNumberTimeStyle timeStyle = new OdfNumberTimeStyle((OdfFileDom)element.getOwnerDocument(), formatStr, name);
        timeStyle.setNumberLanguageAttribute(locale.getLanguage());
        timeStyle.setNumberCountryAttribute(locale.getCountry());
        element.getAutomaticStyles().appendChild(timeStyle);
        OdfStyle styleElement = this.drawingShape.getStyleHandler().getStyleElementForWrite();
        if (styleElement != null) {
            styleElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"), name);
        }
    }

    private String getUniqueTimeStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.getDrawControl().getOdfElement().getAutomaticStyles();
        while (styles.getDateStyle(unique_name = String.format("t%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    public String getTimeFormat() {
        return this.getFormatString(OfficeValueTypeAttribute.Value.TIME);
    }
}

