/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormattedTextElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.CurrencyField;
import org.odftoolkit.simple.form.DateField;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.odftoolkit.simple.form.NumericField;
import org.odftoolkit.simple.form.PatternField;
import org.odftoolkit.simple.form.TimeField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends FormControl {
    Field(FormFormattedTextElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static Field getInstanceOf(FormFormattedTextElement element) {
        Field field = null;
        if (element.getFormControlImplementationAttribute().equals("ooo:com.sun.star.form.component.DateField")) {
            return DateField.getInstanceOf(element);
        }
        if (element.getFormControlImplementationAttribute().equals("ooo:com.sun.star.form.component.TimeField")) {
            return TimeField.getInstanceOf(element);
        }
        if (element.getFormControlImplementationAttribute().equals("ooo:com.sun.star.form.component.NumericField")) {
            return NumericField.getInstanceOf(element);
        }
        if (element.getFormControlImplementationAttribute().equals("ooo:com.sun.star.form.component.PatternField")) {
            return PatternField.getInstanceOf(element);
        }
        if (element.getFormControlImplementationAttribute().equals("ooo:com.sun.star.form.component.CurrencyField")) {
            return CurrencyField.getInstanceOf(element);
        }
        field = new Field(element);
        if (field == null) {
            throw new IllegalStateException("Failed to load and initiate a field.");
        }
        try {
            field.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e2) {
            Logger.getLogger(Field.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this field.");
        }
        return field;
    }

    @Override
    public String getId() {
        return ((FormFormattedTextElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormFormattedTextElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public void setId(String id) {
        ((FormFormattedTextElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormFormattedTextElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    @Override
    public String getName() {
        return ((FormFormattedTextElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormFormattedTextElement)this.mElement).setFormNameAttribute(name);
    }

    public void setValue(String value) {
        ((FormFormattedTextElement)this.mElement).setFormValueAttribute(value);
    }

    public String getValue() {
        return ((FormFormattedTextElement)this.mElement).getFormValueAttribute();
    }

    public void setCurrentValue(String value) {
        ((FormFormattedTextElement)this.mElement).setFormCurrentValueAttribute(value);
    }

    public String getCurrentValue() {
        return ((FormFormattedTextElement)this.mElement).getFormCurrentValueAttribute();
    }

    public void setSpinButonVisible(boolean isVisible) {
        this.setFormProperty("Spin", "boolean", null, isVisible, null, null, null, null);
    }

    protected void setFormatString(String formatStr, OfficeValueTypeAttribute.Value type, Locale locale) {
        if (locale == null) {
            locale = Locale.US;
        }
        if (formatStr == null) {
            throw new IllegalArgumentException("formatStr cannot be null.");
        }
        if (type == OfficeValueTypeAttribute.Value.FLOAT) {
            OdfNumberStyle numberStyle = new OdfNumberStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniqueNumberStyleName());
            numberStyle.setNumberLanguageAttribute(locale.getLanguage());
            numberStyle.setNumberCountryAttribute(locale.getCountry());
            this.drawingShape.getOdfElement().getAutomaticStyles().appendChild(numberStyle);
            this.setDataDisplayStyleName(numberStyle.getStyleNameAttribute());
        } else if (type == OfficeValueTypeAttribute.Value.DATE) {
            OdfNumberDateStyle dateStyle = new OdfNumberDateStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniqueDateStyleName(), null);
            dateStyle.setNumberLanguageAttribute(locale.getLanguage());
            dateStyle.setNumberCountryAttribute(locale.getCountry());
            this.drawingShape.getOdfElement().getAutomaticStyles().appendChild(dateStyle);
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
        } else if (type == OfficeValueTypeAttribute.Value.TIME) {
            OdfNumberTimeStyle timeStyle = new OdfNumberTimeStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniqueDateStyleName());
            timeStyle.setNumberLanguageAttribute(locale.getLanguage());
            timeStyle.setNumberCountryAttribute(locale.getCountry());
            this.drawingShape.getOdfElement().getAutomaticStyles().appendChild(timeStyle);
            this.setDataDisplayStyleName(timeStyle.getStyleNameAttribute());
        } else if (type == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            OdfNumberPercentageStyle dateStyle = new OdfNumberPercentageStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniquePercentageStyleName());
            dateStyle.setNumberLanguageAttribute(locale.getLanguage());
            dateStyle.setNumberCountryAttribute(locale.getCountry());
            this.drawingShape.getOdfElement().getAutomaticStyles().appendChild(dateStyle);
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
        } else {
            throw new IllegalArgumentException("This function doesn't support " + (Object)((Object)type) + " fomat.");
        }
    }

    public String getFormatString(OfficeValueTypeAttribute.Value typeValue) {
        Document mDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
        if (typeValue == OfficeValueTypeAttribute.Value.FLOAT) {
            String name = this.getDataDisplayStyleName();
            OdfNumberStyle style = this.drawingShape.getOdfElement().getAutomaticStyles().getNumberStyle(name);
            if (style == null) {
                style = mDocument.getDocumentStyles().getNumberStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.DATE) {
            String name = this.getDataDisplayStyleName();
            OdfNumberDateStyle style = this.drawingShape.getOdfElement().getAutomaticStyles().getDateStyle(name);
            if (style == null) {
                style = mDocument.getDocumentStyles().getDateStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.TIME) {
            String name = this.getDataDisplayStyleName();
            OdfNumberDateStyle style = this.drawingShape.getOdfElement().getAutomaticStyles().getDateStyle(name);
            if (style == null) {
                style = mDocument.getDocumentStyles().getDateStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            String name = this.getDataDisplayStyleName();
            OdfNumberPercentageStyle style = this.drawingShape.getOdfElement().getAutomaticStyles().getPercentageStyle(name);
            if (style == null) {
                style = mDocument.getDocumentStyles().getPercentageStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        }
        return null;
    }

    private void setDataDisplayStyleName(String name) {
        OdfStyle styleElement = this.drawingShape.getStyleHandler().getStyleElementForWrite();
        if (styleElement != null) {
            styleElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"), name);
        }
    }

    private String getDataDisplayStyleName() {
        String datadisplayStylename = null;
        OdfStyleBase styleElement = this.drawingShape.getStyleHandler().getStyleElementForRead();
        if (styleElement != null) {
            datadisplayStylename = styleElement.getOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"));
        }
        return datadisplayStylename;
    }

    private String getUniqueNumberStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.drawingShape.getOdfElement().getAutomaticStyles();
        while (styles.getNumberStyle(unique_name = String.format("n%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniqueDateStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.drawingShape.getOdfElement().getAutomaticStyles();
        while (styles.getDateStyle(unique_name = String.format("d%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniquePercentageStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.drawingShape.getOdfElement().getAutomaticStyles();
        while (styles.getPercentageStyle(unique_name = String.format("p%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    public static Iterator<FormControl> getSimpleIterator(Form container2) {
        return new SimpleFieldIterator(container2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleFieldIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private Field nextElement = null;
        private Field tempElement = null;

        private SimpleFieldIterator(Form container2) {
            this.containerElement = container2.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Field next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private Field findNext(Field thisField) {
            FormFormattedTextElement nextfield = null;
            nextfield = thisField == null ? OdfElement.findFirstChildNode(FormFormattedTextElement.class, this.containerElement) : OdfElement.findNextChildNode(FormFormattedTextElement.class, thisField.getOdfElement());
            if (nextfield != null) {
                return Field.getInstanceOf(nextfield);
            }
            return null;
        }
    }
}

