/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.draw.ControlContainer;
import org.odftoolkit.simple.draw.ControlStyleHandler;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.w3c.dom.DOMException;

public class Control
extends Component {
    private DrawControlElement mElement;
    private OdfElement containerElement;
    private ControlStyleHandler mStyleHandler;

    public Control(DrawControlElement element) {
        this.mElement = element;
        this.containerElement = (OdfElement)element.getParentNode();
    }

    public OdfElement getContainerElement() {
        return this.containerElement;
    }

    public DrawControlElement getOdfElement() {
        return this.mElement;
    }

    public static Control newDrawControl(ControlContainer container2) {
        OdfElement parent = container2.getDrawControlContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        DrawControlElement element = ownerDom.newOdfElement(DrawControlElement.class);
        parent.appendChild(element);
        Control control = new Control(element);
        Component.registerComponent(control, element);
        return control;
    }

    public static Control getInstanceof(DrawControlElement element) {
        Control control = null;
        control = (Control)Component.getComponentByElement(element);
        if (control != null) {
            return control;
        }
        control = new Control(element);
        Component.registerComponent(control, element);
        return control;
    }

    public boolean remove() {
        try {
            Document mOwnerDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
            mOwnerDocument.removeElementLinkedResource(this.getOdfElement());
            this.containerElement.removeChild(this.mElement);
            return true;
        }
        catch (DOMException exception) {
            Logger.getLogger(Control.class.getName()).log(Level.WARNING, exception.getMessage());
            return false;
        }
    }

    public ControlStyleHandler getStyleHandler() {
        if (this.mStyleHandler == null) {
            this.mStyleHandler = new ControlStyleHandler(this);
        }
        return this.mStyleHandler;
    }

    public void setControl(String formControlId) {
        this.mElement.setDrawControlAttribute(formControlId);
    }

    public void setAchorType(StyleTypeDefinitions.AnchorType achorType) {
        this.getStyleHandler().setAchorType(achorType);
    }

    public void setRectangle(FrameRectangle rectangle) {
        if (rectangle.getWidth() > 0.0) {
            this.mElement.setSvgWidthAttribute(rectangle.getWidthDesc());
        }
        if (rectangle.getHeight() > 0.0) {
            this.mElement.setSvgHeightAttribute(rectangle.getHeigthDesc());
        }
        if (rectangle.getX() > 0.0) {
            this.mElement.setSvgXAttribute(rectangle.getXDesc());
        }
        if (rectangle.getY() > 0.0) {
            this.mElement.setSvgYAttribute(rectangle.getYDesc());
        }
    }

    public FrameRectangle getRectangle() {
        try {
            FrameRectangle rectange = new FrameRectangle(this.mElement.getSvgXAttribute(), this.mElement.getSvgYAttribute(), this.mElement.getSvgWidthAttribute(), this.mElement.getSvgHeightAttribute());
            return rectange;
        }
        catch (Exception e2) {
            Logger.getLogger(Frame.class.getName()).log(Level.FINE, e2.getMessage(), e2);
            return null;
        }
    }

    public void setFormatString(String formatStr, String type) {
        OfficeValueTypeAttribute.Value typeValue = null;
        typeValue = OfficeValueTypeAttribute.Value.enumValueOf(type);
        if (typeValue == OfficeValueTypeAttribute.Value.DATE) {
            OdfNumberDateStyle dateStyle = new OdfNumberDateStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniqueDateStyleName(), null);
            dateStyle.setNumberLanguageAttribute("en");
            dateStyle.setNumberCountryAttribute("US");
            this.mElement.getAutomaticStyles().appendChild(dateStyle);
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
        } else if (typeValue == OfficeValueTypeAttribute.Value.TIME) {
            OdfNumberTimeStyle timeStyle = new OdfNumberTimeStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniqueDateStyleName());
            this.mElement.getAutomaticStyles().appendChild(timeStyle);
            this.setDataDisplayStyleName(timeStyle.getStyleNameAttribute());
        } else if (typeValue == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            OdfNumberPercentageStyle dateStyle = new OdfNumberPercentageStyle((OdfFileDom)this.mElement.getOwnerDocument(), formatStr, this.getUniquePercentageStyleName());
            this.mElement.getAutomaticStyles().appendChild(dateStyle);
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
        } else {
            throw new IllegalArgumentException("This function doesn't support " + type + "formatting.");
        }
    }

    private String getUniqueDateStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mElement.getAutomaticStyles();
        while (styles.getDateStyle(unique_name = String.format("d%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private void setDataDisplayStyleName(String name) {
        OdfStyle styleElement = this.getStyleHandler().getStyleElementForWrite();
        if (styleElement != null) {
            styleElement.setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "data-style-name"), name);
        }
    }

    private String getUniquePercentageStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mElement.getAutomaticStyles();
        while (styles.getDateStyle(unique_name = String.format("p%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }
}

