/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.draw.FrameContainer;
import org.odftoolkit.simple.draw.FrameRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFrameContainer
implements FrameContainer {
    @Override
    public abstract OdfElement getFrameContainerElement();

    public Frame addFrame() {
        Frame frame = Frame.newFrame(this);
        return frame;
    }

    public Frame addFrame(FrameRectangle rectangle) {
        Frame frame = Frame.newFrame(this);
        frame.setRectangle(rectangle);
        return frame;
    }

    public Frame getFrameByName(String name) {
        if (name == null) {
            return null;
        }
        OdfElement container2 = this.getFrameContainerElement();
        DrawFrameElement element = OdfElement.findFirstChildNode(DrawFrameElement.class, container2);
        while (element != null) {
            if (name.equals(element.getDrawNameAttribute())) {
                Frame frame = Frame.getInstanceof(element);
                frame.mFrameContainer = this;
                return frame;
            }
            element = OdfElement.findNextChildNode(DrawFrameElement.class, element);
        }
        return null;
    }

    public List<Frame> getFrameByPresentationclass(PresentationDocument.PresentationClass usage) {
        OdfElement container2 = this.getFrameContainerElement();
        Document doc = (Document)((OdfFileDom)container2.getOwnerDocument()).getDocument();
        if (!(doc instanceof PresentationDocument)) {
            return null;
        }
        ArrayList<Frame> al = new ArrayList<Frame>();
        DrawFrameElement element = OdfElement.findFirstChildNode(DrawFrameElement.class, container2);
        while (element != null) {
            if (usage.toString().equals(element.getPresentationClassAttribute())) {
                Frame frame = Frame.getInstanceof(element);
                frame.mFrameContainer = this;
                al.add(frame);
            }
            element = OdfElement.findNextChildNode(DrawFrameElement.class, element);
        }
        return al;
    }
}

