/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

class URITransformer {
    protected static BitSet safeCharacters;

    public static String encodePath(String path) {
        try {
            StringBuilder pathc = new StringBuilder();
            byte[] bytes = null;
            bytes = path.getBytes("UTF-8");
            for (int i = 0; i < bytes.length; ++i) {
                int v = bytes[i];
                if (v < 0) {
                    v += 256;
                }
                if (v > 0 && v < 256 && safeCharacters.get(v)) {
                    pathc.append((char)v);
                    continue;
                }
                if ((char)v == '/') {
                    pathc.append((char)v);
                    continue;
                }
                pathc.append("%" + Integer.toHexString(v));
            }
            path = pathc.toString();
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(URITransformer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return path;
    }

    public static String decodePath(String path) {
        String pathc = path;
        StringBuilder uri = new StringBuilder();
        int j = pathc.indexOf(37, 0);
        int l = pathc.length();
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] b = new byte[]{0};
        while (j != -1) {
            if (j + 3 <= l) {
                try {
                    b = pathc.substring(0, j).getBytes("UTF-8");
                    ba.write(b, 0, b.length);
                }
                catch (UnsupportedEncodingException e2) {
                    // empty catch block
                }
                String hex = pathc.substring(j + 1, j + 3);
                try {
                    int n = Integer.parseInt(hex, 16);
                    ba.write(n);
                }
                catch (NumberFormatException e3) {
                    String tmp = "=" + hex;
                    try {
                        b = tmp.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e2) {
                        // empty catch block
                    }
                    ba.write(b, 0, b.length);
                }
                pathc = pathc.substring(j + 3);
                l = pathc.length();
                j = pathc.indexOf(37, 0);
                continue;
            }
            j = -1;
        }
        try {
            uri.append(new String(ba.toByteArray(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        uri.append(pathc);
        return uri.toString();
    }

    public static String path2uri(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder uri = new StringBuilder();
        String npath = path.startsWith("/") ? path.substring(1) : path;
        int l = npath.length();
        int i = npath.indexOf(47);
        if (i == -1) {
            if (npath.equals("")) {
                return npath;
            }
            return npath + "://";
        }
        String rpath = "";
        boolean bauth = true;
        if (i == 0) {
            uri.append("/");
        } else {
            if (i == l) {
                return npath + "://";
            }
            String scheme = npath.substring(0, i) + ":";
            if (i + 4 <= l) {
                String hier = npath.substring(i + 1, i + 4);
                if (hier.startsWith("==0/")) {
                    i += 5;
                } else if (hier.startsWith("==0")) {
                    i += 4;
                } else if (hier.startsWith("==1")) {
                    bauth = false;
                    scheme = scheme + "";
                    i += 3;
                } else if (hier.startsWith("==2")) {
                    scheme = scheme + "//";
                    i += 3;
                    bauth = false;
                } else {
                    scheme = scheme + "//";
                }
            }
            uri.append(scheme);
        }
        int j = -1;
        String auth = "";
        if (bauth) {
            if (rpath.equals("")) {
                if (i + 1 <= l) {
                    j = npath.indexOf(47, i + 1);
                }
                if (j == -1) {
                    j = l;
                } else {
                    rpath = npath.substring(j);
                }
                auth = i + 1 <= l ? npath.substring(i + 1, j) : "";
            } else {
                rpath = i + 1 <= l ? rpath + npath.substring(i + 1) : "";
            }
            j = auth.indexOf(61, 0);
            l = auth.length();
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            byte[] b = new byte[]{0};
            while (j != -1) {
                if (j + 3 <= l) {
                    try {
                        b = auth.substring(0, j).getBytes("UTF-8");
                        ba.write(b, 0, b.length);
                    }
                    catch (UnsupportedEncodingException e2) {
                        // empty catch block
                    }
                    String hex = auth.substring(j + 1, j + 3);
                    try {
                        int n = Integer.parseInt(hex, 16);
                        ba.write(n);
                    }
                    catch (NumberFormatException e3) {
                        String tmp = "=" + hex;
                        try {
                            b = tmp.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e2) {
                            // empty catch block
                        }
                        ba.write(b, 0, b.length);
                    }
                    auth = auth.substring(j + 3);
                    l = auth.length();
                    j = auth.indexOf(61, 0);
                    continue;
                }
                j = -1;
            }
            try {
                uri.append(new String(ba.toByteArray(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e2) {
                // empty catch block
            }
            uri.append(auth);
        } else {
            rpath = i + 1 <= l ? npath.substring(i + 1) : "";
        }
        uri.append(URITransformer.encodePath(rpath));
        return uri.toString();
    }

    public static String uri2path(String uri) {
        if (uri == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        int i = uri.indexOf(":");
        if (i == -1) {
            return uri;
        }
        int l = uri.length();
        path.append(uri.substring(0, i)).append("/");
        int sc = 0;
        if (i + 3 <= l && uri.substring(i + 1, i + 3).equals("//")) {
            i += 3;
            sc = 2;
        } else if (i + 2 <= l && uri.substring(i + 1, i + 2).equals("/")) {
            i += 2;
            sc = 1;
        } else {
            ++i;
        }
        int j = uri.indexOf(47, i);
        String ruri = "";
        if (j == -1) {
            j = l;
            ruri = "";
        } else {
            ruri = uri.substring(j);
        }
        String auth = uri.substring(i, j);
        if (sc == 2 && auth.length() == 0) {
            path.append("==2");
        } else if (sc == 1) {
            path.append("==1/");
        } else if (sc == 0) {
            path.append("==0/");
        }
        byte[] bytes = null;
        try {
            bytes = auth.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        for (i = 0; i < bytes.length; ++i) {
            int v = bytes[i];
            if (v < 0) {
                v += 256;
            }
            if (v > 0 && v < 256 && safeCharacters.get(v)) {
                path.append((char)v);
                continue;
            }
            path.append("=" + Integer.toHexString(v));
        }
        path.append(URITransformer.decodePath(ruri));
        return path.toString();
    }

    private URITransformer() {
    }

    static {
        int i;
        safeCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            safeCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            safeCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            safeCharacters.set(i);
        }
        safeCharacters.set(61);
        safeCharacters.set(58);
        safeCharacters.set(64);
        safeCharacters.set(38);
        safeCharacters.set(36);
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(43);
        safeCharacters.set(33);
        safeCharacters.set(42);
        safeCharacters.set(39);
        safeCharacters.set(40);
        safeCharacters.set(41);
        safeCharacters.set(44);
    }
}

