/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipHelper {
    private ZipFile mZipFile = null;
    private byte[] mZipBuffer = null;
    private OdfPackage mPackage = null;

    public ZipHelper(OdfPackage pkg, ZipFile zipFile) {
        this.mZipFile = zipFile;
        this.mZipBuffer = null;
        this.mPackage = pkg;
    }

    public ZipHelper(OdfPackage pkg, byte[] buffer) {
        this.mZipBuffer = buffer;
        this.mZipFile = null;
        this.mPackage = pkg;
    }

    String entriesToMap(Map<String, ZipEntry> zipEntries) throws IOException, SAXException {
        String firstEntryName = null;
        if (this.mZipFile != null) {
            ZipEntry zipEntry;
            Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
            if (entries.hasMoreElements() && (zipEntry = entries.nextElement()) != null) {
                firstEntryName = zipEntry.getName();
                this.addZipEntry(zipEntry, zipEntries);
                while (entries.hasMoreElements()) {
                    zipEntry = entries.nextElement();
                    this.addZipEntry(zipEntry, zipEntries);
                }
            }
        } else {
            ZipInputStream inputStream = new ZipInputStream(new ByteArrayInputStream(this.mZipBuffer));
            if (inputStream.available() == 0) {
                throw new IllegalArgumentException("Could not unzip the given ODF package!");
            }
            ZipEntry zipEntry = inputStream.getNextEntry();
            if (zipEntry != null) {
                firstEntryName = zipEntry.getName();
                this.addZipEntry(zipEntry, zipEntries);
                while (zipEntry != null) {
                    this.addZipEntry(zipEntry, zipEntries);
                    try {
                        zipEntry = inputStream.getNextEntry();
                    }
                    catch (ZipException e2) {
                        if (e2.getMessage().contains("missing entry name") || System.getProperty("Java.version").equals("1.5.0")) continue;
                        Logger.getLogger(ZipHelper.class.getName()).info("ZIP ENTRY not found");
                        throw e2;
                    }
                }
            }
            inputStream.close();
        }
        return firstEntryName;
    }

    private void addZipEntry(ZipEntry zipEntry, Map<String, ZipEntry> zipEntries) {
        String filePath = OdfPackage.normalizePath(zipEntry.getName());
        ErrorHandler errorHandler = this.mPackage.getErrorHandler();
        if (errorHandler != null) {
            try {
                int zipMethod = zipEntry.getMethod();
                if (zipMethod != 0 && zipMethod != 8) {
                    this.mPackage.getErrorHandler().error(new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_ENTRY_USING_INVALID_COMPRESSION, this.mPackage.getBaseURI(), filePath));
                }
            }
            catch (SAXException ex) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        zipEntries.put(filePath, zipEntry);
    }

    InputStream getInputStream(ZipEntry entry) throws IOException {
        if (this.mZipFile != null) {
            return this.mZipFile.getInputStream(entry);
        }
        ZipInputStream inputStream = new ZipInputStream(new ByteArrayInputStream(this.mZipBuffer));
        ZipEntry zipEntry = inputStream.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equalsIgnoreCase(entry.getName())) {
                return this.readAsInputStream(inputStream);
            }
            zipEntry = inputStream.getNextEntry();
        }
        return null;
    }

    private InputStream readAsInputStream(ZipInputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (outputStream != null) {
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = inputStream.read(buf, 0, 4096)) > -1) {
                outputStream.write(buf, 0, r);
            }
            inputStream.close();
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    void close() throws IOException {
        if (this.mZipFile != null) {
            this.mZipFile.close();
        } else {
            this.mZipBuffer = null;
        }
    }
}

