/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.util.ArrayList;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.ParentNode;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OdfElement
extends ElementNSImpl {
    private static final long serialVersionUID = -4939293285696678939L;

    public OdfElement(OdfFileDom ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public OdfElement(OdfFileDom ownerDocument, OdfName aName) throws DOMException {
        super(ownerDocument, aName.getUri(), aName.getQName());
    }

    public abstract OdfName getOdfName();

    protected <T extends OdfElement> T getParentAs(Class<T> clazz) {
        Node parent = this.getParentNode();
        if (parent != null && clazz.isInstance(parent)) {
            return (T)((OdfElement)clazz.cast(parent));
        }
        return null;
    }

    protected <T extends OdfElement> T getAncestorAs(Class<T> clazz) {
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!clazz.isInstance(node)) continue;
            return (T)((OdfElement)clazz.cast(node));
        }
        return null;
    }

    @Override
    public String toString() {
        return OdfElement.mapNode(this, new StringBuilder()).toString();
    }

    private static StringBuilder mapNodeTree(Node node, StringBuilder xml) {
        while (node != null) {
            xml = OdfElement.mapNode(node, xml);
            node = node.getNextSibling();
        }
        return xml;
    }

    private static StringBuilder mapNode(Node node, StringBuilder xml) {
        if (node instanceof Element) {
            xml = OdfElement.mapElementNode(node, xml);
        } else if (node instanceof Text) {
            xml = OdfElement.mapTextNode(node, xml);
        }
        return xml;
    }

    private static StringBuilder mapTextNode(Node node, StringBuilder xml) {
        if (node != null) {
            xml = xml.append(node.getTextContent());
        }
        return xml;
    }

    private static StringBuilder mapElementNode(Node node, StringBuilder xml) {
        if (node != null) {
            xml = xml.append("<");
            xml = xml.append(node.getNodeName());
            xml = OdfElement.mapAttributeNode(node, xml);
            xml = xml.append(">");
            xml = OdfElement.mapNodeTree(node.getFirstChild(), xml);
            xml = xml.append("</");
            xml = xml.append(node.getNodeName());
            xml = xml.append(">");
        }
        return xml;
    }

    private static StringBuilder mapAttributeNode(Node node, StringBuilder xml) {
        int length;
        NamedNodeMap attrs = null;
        attrs = node.getAttributes();
        if (attrs != null && (length = attrs.getLength()) > 0) {
            for (int i = 0; length > i; ++i) {
                xml = xml.append(" ");
                xml = xml.append(attrs.item(i).getNodeName());
                xml = xml.append("=\"");
                xml = xml.append(attrs.item(i).getNodeValue());
                xml = xml.append("\"");
            }
        }
        return xml;
    }

    public void setOdfAttributeValue(OdfName name, String value) {
        this.setAttributeNS(name.getUri(), name.getQName(), value);
    }

    public void setOdfAttribute(OdfAttribute attribute) {
        this.setAttributeNodeNS(attribute);
    }

    public String getOdfAttributeValue(OdfName name) {
        return this.getAttributeNS(name.getUri(), name.getLocalName());
    }

    public OdfAttribute getOdfAttribute(OdfName name) {
        return (OdfAttribute)this.getAttributeNodeNS(name.getUri(), name.getLocalName());
    }

    public OdfAttribute getOdfAttribute(NamespaceName namespace2, String localname2) {
        return (OdfAttribute)this.getAttributeNodeNS(namespace2.getUri(), localname2);
    }

    public boolean hasOdfAttribute(OdfName name) {
        return this.hasAttributeNS(name.getUri(), name.getLocalName());
    }

    public static <T extends OdfElement> T findFirstChildNode(Class<T> clazz, Node parentNode) {
        if (parentNode != null && parentNode instanceof ParentNode) {
            Node node;
            for (node = ((ParentNode)parentNode).getFirstChild(); node != null && !clazz.isInstance(node); node = node.getNextSibling()) {
            }
            if (node != null) {
                return (T)((OdfElement)node);
            }
        }
        return null;
    }

    public static <T extends OdfElement> T findNextChildNode(Class<T> clazz, Node refNode) {
        if (refNode != null) {
            Node node;
            for (node = refNode.getNextSibling(); node != null && !clazz.isInstance(node); node = node.getNextSibling()) {
            }
            if (node != null) {
                return (T)((OdfElement)node);
            }
        }
        return null;
    }

    public static <T extends OdfElement> T findPreviousChildNode(Class<T> clazz, Node refNode) {
        if (refNode != null) {
            Node node;
            for (node = refNode.getPreviousSibling(); node != null && !clazz.isInstance(node); node = node.getPreviousSibling()) {
            }
            if (node != null) {
                return (T)((OdfElement)node);
            }
        }
        return null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        Object cloneElement = ((OdfFileDom)this.ownerDocument).newOdfElement(this.getClass());
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                Node item = this.attributes.item(i);
                String qname = null;
                String prefix = item.getPrefix();
                qname = prefix == null ? item.getLocalName() : prefix + ":" + item.getLocalName();
                ((ElementImpl)cloneElement).setAttributeNS(item.getNamespaceURI(), qname, item.getNodeValue());
            }
        }
        if (deep) {
            for (Node childNode = this.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                ((NodeImpl)cloneElement).appendChild(childNode.cloneNode(true));
            }
        }
        return cloneElement;
    }

    public boolean equals(Object obj) {
        int i;
        int i2;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OdfElement)) {
            return false;
        }
        OdfElement compare = (OdfElement)obj;
        if (!this.localName.equals(compare.localName)) {
            return false;
        }
        if (!this.namespaceURI.equals(compare.namespaceURI)) {
            return false;
        }
        if (this.attributes == compare.attributes) {
            return true;
        }
        if (this.attributes == null || compare.attributes == null) {
            return false;
        }
        int attr_count1 = this.attributes.getLength();
        int attr_count2 = compare.attributes.getLength();
        ArrayList<Node> attr1 = new ArrayList<Node>();
        for (int i3 = 0; i3 < attr_count1; ++i3) {
            Node node = this.attributes.item(i3);
            if (node.getNodeValue().length() == 0) continue;
            attr1.add(node);
        }
        ArrayList<Node> attr2 = new ArrayList<Node>();
        for (i2 = 0; i2 < attr_count2; ++i2) {
            Node node = compare.attributes.item(i2);
            if (node.getNodeValue().length() == 0) continue;
            attr2.add(node);
        }
        if (attr1.size() != attr2.size()) {
            return false;
        }
        for (i2 = 0; i2 < attr1.size(); ++i2) {
            Node n1 = (Node)attr1.get(i2);
            if (n1.getLocalName().equals("name") && n1.getNamespaceURI().equals(OdfDocumentNamespace.STYLE.getUri())) continue;
            Node n2 = null;
            int j = 0;
            for (j = 0; j < attr2.size(); ++j) {
                n2 = (Node)attr2.get(j);
                if (n1.getLocalName().equals(n2.getLocalName()) && n1.getNamespaceURI().equals(n2.getNamespaceURI())) break;
            }
            if (j == attr2.size()) {
                return false;
            }
            if (n1.getTextContent().equals(n2.getTextContent())) continue;
            return false;
        }
        NodeList childs1 = this.getChildNodes();
        NodeList childs2 = compare.getChildNodes();
        int child_count1 = childs1.getLength();
        int child_count2 = childs2.getLength();
        if (child_count1 == 0 && child_count2 == 0) {
            return true;
        }
        ArrayList<Node> nodes1 = new ArrayList<Node>();
        for (int i4 = 0; i4 < child_count1; ++i4) {
            Node node = childs1.item(i4);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) continue;
            nodes1.add(node);
        }
        ArrayList<Node> nodes2 = new ArrayList<Node>();
        for (i = 0; i < child_count2; ++i) {
            Node node = childs2.item(i);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) continue;
            nodes2.add(node);
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (i = 0; i < nodes1.size(); ++i) {
            Node n2;
            Node n1 = (Node)nodes1.get(i);
            if (n1.equals(n2 = (Node)nodes2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void onRemoveNode(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.onRemoveNode(child);
        }
        if (OdfElement.class.isInstance(node)) {
            ((OdfElement)node).onRemoveNode();
        }
    }

    protected void onInsertNode(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.onInsertNode(child);
        }
        if (OdfElement.class.isInstance(node)) {
            ((OdfElement)node).onInsertNode();
        }
    }

    protected void onRemoveNode() {
    }

    protected void onInsertNode() {
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        this.onInsertNode(newChild);
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        this.onRemoveNode(oldChild);
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.onInsertNode(newChild);
        this.onRemoveNode(oldChild);
        return super.replaceChild(newChild, oldChild);
    }

    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

