/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.standard;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionHeader;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionVerifier;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.BoundedInputStream;
import org.apache.poi.util.LittleEndian;

public class StandardDecryptor
extends Decryptor {
    private long _length = -1L;

    protected StandardDecryptor(EncryptionInfo info) {
        super(info);
    }

    public boolean verifyPassword(String password) {
        EncryptionVerifier ver = this.info.getVerifier();
        SecretKey skey = StandardDecryptor.generateSecretKey(password, ver, this.getKeySizeInBytes());
        Cipher cipher = this.getCipher(skey);
        try {
            byte[] encryptedVerifier = ver.getEncryptedVerifier();
            byte[] verifier = cipher.doFinal(encryptedVerifier);
            this.setVerifier(verifier);
            MessageDigest sha1 = MessageDigest.getInstance(ver.getHashAlgorithm().jceId);
            byte[] calcVerifierHash = sha1.digest(verifier);
            byte[] encryptedVerifierHash = ver.getEncryptedVerifierHash();
            byte[] decryptedVerifierHash = cipher.doFinal(encryptedVerifierHash);
            byte[] verifierHash = StandardDecryptor.truncateOrPad(decryptedVerifierHash, calcVerifierHash.length);
            if (Arrays.equals(calcVerifierHash, verifierHash)) {
                this.setSecretKey(skey);
                return true;
            }
            return false;
        }
        catch (GeneralSecurityException e2) {
            throw new EncryptedDocumentException(e2);
        }
    }

    protected static SecretKey generateSecretKey(String password, EncryptionVerifier ver, int keySize) {
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        byte[] pwHash = CryptoFunctions.hashPassword(password, hashAlgo, ver.getSalt(), ver.getSpinCount());
        byte[] blockKey = new byte[4];
        LittleEndian.putInt(blockKey, 0, 0);
        byte[] finalHash = CryptoFunctions.generateKey(pwHash, hashAlgo, blockKey, hashAlgo.hashSize);
        byte[] x1 = StandardDecryptor.fillAndXor(finalHash, (byte)54);
        byte[] x2 = StandardDecryptor.fillAndXor(finalHash, (byte)92);
        byte[] x3 = new byte[x1.length + x2.length];
        System.arraycopy(x1, 0, x3, 0, x1.length);
        System.arraycopy(x2, 0, x3, x1.length, x2.length);
        byte[] key = StandardDecryptor.truncateOrPad(x3, keySize);
        SecretKeySpec skey = new SecretKeySpec(key, ver.getCipherAlgorithm().jceId);
        return skey;
    }

    protected static byte[] fillAndXor(byte[] hash, byte fillByte) {
        byte[] buff = new byte[64];
        Arrays.fill(buff, fillByte);
        for (int i = 0; i < hash.length; ++i) {
            buff[i] = (byte)(buff[i] ^ hash[i]);
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            return sha1.digest(buff);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new EncryptedDocumentException("hash algo not supported", e2);
        }
    }

    protected static byte[] truncateOrPad(byte[] source, int length) {
        byte[] result = new byte[length];
        System.arraycopy(source, 0, result, 0, Math.min(length, source.length));
        if (length > source.length) {
            for (int i = source.length; i < length; ++i) {
                result[i] = 0;
            }
        }
        return result;
    }

    private Cipher getCipher(SecretKey key) {
        EncryptionHeader em = this.info.getHeader();
        ChainingMode cm = em.getChainingMode();
        assert (cm == ChainingMode.ecb);
        return CryptoFunctions.getCipher(key, em.getCipherAlgorithm(), cm, null, 2);
    }

    public InputStream getDataStream(DirectoryNode dir) throws IOException {
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptedPackage");
        this._length = dis.readLong();
        return new BoundedInputStream(new CipherInputStream(dis, this.getCipher(this.getSecretKey())), this._length);
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("Decryptor.getDataStream() was not called");
        }
        return this._length;
    }

    protected int getKeySizeInBytes() {
        return this.info.getHeader().getKeySize() / 8;
    }
}

