/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.agile;

import com.microsoft.schemas.office.x2006.encryption.CTDataIntegrity;
import com.microsoft.schemas.office.x2006.encryption.CTEncryption;
import com.microsoft.schemas.office.x2006.encryption.CTKeyData;
import com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptor;
import com.microsoft.schemas.office.x2006.encryption.CTKeyEncryptors;
import com.microsoft.schemas.office.x2006.encryption.EncryptionDocument;
import com.microsoft.schemas.office.x2006.encryption.STCipherAlgorithm;
import com.microsoft.schemas.office.x2006.encryption.STCipherChaining;
import com.microsoft.schemas.office.x2006.encryption.STHashAlgorithm;
import com.microsoft.schemas.office.x2006.keyEncryptor.certificate.CTCertificateKeyEncryptor;
import com.microsoft.schemas.office.x2006.keyEncryptor.password.CTPasswordKeyEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianOutputStream;
import org.apache.poi.util.TempFile;
import org.apache.xmlbeans.XmlOptions;

public class AgileEncryptor
extends Encryptor {
    private final AgileEncryptionInfoBuilder builder;
    private byte[] integritySalt;
    private Mac integrityMD;
    private byte[] pwHash;

    protected AgileEncryptor(AgileEncryptionInfoBuilder builder) {
        this.builder = builder;
    }

    public void confirmPassword(String password) {
        SecureRandom r = new SecureRandom();
        int blockSize = this.builder.getHeader().getBlockSize();
        int keySize = this.builder.getHeader().getKeySize() / 8;
        int hashSize = this.builder.getHeader().getHashAlgorithmEx().hashSize;
        byte[] verifierSalt = new byte[blockSize];
        byte[] verifier = new byte[blockSize];
        byte[] keySalt = new byte[blockSize];
        byte[] keySpec = new byte[keySize];
        byte[] integritySalt = new byte[hashSize];
        ((Random)r).nextBytes(verifierSalt);
        ((Random)r).nextBytes(verifier);
        ((Random)r).nextBytes(keySalt);
        ((Random)r).nextBytes(keySpec);
        ((Random)r).nextBytes(integritySalt);
        this.confirmPassword(password, keySpec, keySalt, verifierSalt, verifier, integritySalt);
    }

    public void confirmPassword(String password, byte[] keySpec, byte[] keySalt, byte[] verifier, byte[] verifierSalt, byte[] integritySalt) {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        ver.setSalt(verifierSalt);
        AgileEncryptionHeader header = this.builder.getHeader();
        header.setKeySalt(keySalt);
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        int blockSize = header.getBlockSize();
        this.pwHash = CryptoFunctions.hashPassword(password, hashAlgo, verifierSalt, ver.getSpinCount());
        byte[] encryptedVerifier = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kVerifierInputBlock, verifier, 1);
        ver.setEncryptedVerifier(encryptedVerifier);
        MessageDigest hashMD = CryptoFunctions.getMessageDigest(hashAlgo);
        byte[] hashedVerifier = hashMD.digest(verifier);
        byte[] encryptedVerifierHash = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kHashedVerifierBlock, hashedVerifier, 1);
        ver.setEncryptedVerifierHash(encryptedVerifierHash);
        byte[] encryptedKey = AgileDecryptor.hashInput(this.builder, this.pwHash, AgileDecryptor.kCryptoKeyBlock, keySpec, 1);
        ver.setEncryptedKey(encryptedKey);
        SecretKeySpec secretKey = new SecretKeySpec(keySpec, ver.getCipherAlgorithm().jceId);
        this.setSecretKey(secretKey);
        this.integritySalt = integritySalt;
        try {
            byte[] vec = CryptoFunctions.generateIv(hashAlgo, header.getKeySalt(), AgileDecryptor.kIntegrityKeyBlock, header.getBlockSize());
            Cipher cipher = CryptoFunctions.getCipher(secretKey, ver.getCipherAlgorithm(), ver.getChainingMode(), vec, 1);
            byte[] filledSalt = CryptoFunctions.getBlock0(integritySalt, AgileDecryptor.getNextBlockSize(integritySalt.length, blockSize));
            byte[] encryptedHmacKey = cipher.doFinal(filledSalt);
            header.setEncryptedHmacKey(encryptedHmacKey);
            this.integrityMD = CryptoFunctions.getMac(hashAlgo);
            this.integrityMD.init(new SecretKeySpec(integritySalt, hashAlgo.jceHmacId));
            cipher = Cipher.getInstance("RSA");
            for (AgileEncryptionVerifier.AgileCertificateEntry ace : ver.getCertificates()) {
                cipher.init(1, ace.x509.getPublicKey());
                ace.encryptedKey = cipher.doFinal(this.getSecretKey().getEncoded());
                Mac x509Hmac = CryptoFunctions.getMac(hashAlgo);
                x509Hmac.init(this.getSecretKey());
                ace.certVerifier = x509Hmac.doFinal(ace.x509.getEncoded());
            }
        }
        catch (GeneralSecurityException e2) {
            throw new EncryptedDocumentException(e2);
        }
    }

    public OutputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        ChunkedCipherOutputStream countStream = new ChunkedCipherOutputStream(dir);
        return countStream;
    }

    protected void createEncryptionInfoEntry(DirectoryNode dir) throws IOException {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        AgileEncryptionHeader header = this.builder.getHeader();
        EncryptionDocument ed = EncryptionDocument.Factory.newInstance();
        CTEncryption edRoot = ed.addNewEncryption();
        CTKeyData keyData = edRoot.addNewKeyData();
        CTKeyEncryptors keyEncList = edRoot.addNewKeyEncryptors();
        CTKeyEncryptor keyEnc = keyEncList.addNewKeyEncryptor();
        keyEnc.setUri(CTKeyEncryptor.Uri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_PASSWORD);
        CTPasswordKeyEncryptor keyPass = keyEnc.addNewEncryptedPasswordKey();
        keyPass.setSpinCount(ver.getSpinCount());
        keyData.setSaltSize(header.getBlockSize());
        keyPass.setSaltSize(header.getBlockSize());
        keyData.setBlockSize(header.getBlockSize());
        keyPass.setBlockSize(header.getBlockSize());
        keyData.setKeyBits(header.getKeySize());
        keyPass.setKeyBits(header.getKeySize());
        HashAlgorithm hashAlgo = header.getHashAlgorithmEx();
        keyData.setHashSize(hashAlgo.hashSize);
        keyPass.setHashSize(hashAlgo.hashSize);
        STCipherAlgorithm.Enum xmlCipherAlgo = STCipherAlgorithm.Enum.forString(header.getCipherAlgorithm().xmlId);
        if (xmlCipherAlgo == null) {
            throw new EncryptedDocumentException("CipherAlgorithm " + (Object)((Object)header.getCipherAlgorithm()) + " not supported.");
        }
        keyData.setCipherAlgorithm(xmlCipherAlgo);
        keyPass.setCipherAlgorithm(xmlCipherAlgo);
        switch (header.getChainingMode()) {
            case cbc: {
                keyData.setCipherChaining(STCipherChaining.CHAINING_MODE_CBC);
                keyPass.setCipherChaining(STCipherChaining.CHAINING_MODE_CBC);
                break;
            }
            case cfb: {
                keyData.setCipherChaining(STCipherChaining.CHAINING_MODE_CFB);
                keyPass.setCipherChaining(STCipherChaining.CHAINING_MODE_CFB);
                break;
            }
            default: {
                throw new EncryptedDocumentException("ChainingMode " + (Object)((Object)header.getChainingMode()) + " not supported.");
            }
        }
        STHashAlgorithm.Enum xmlHashAlgo = STHashAlgorithm.Enum.forString(hashAlgo.ecmaString);
        if (xmlHashAlgo == null) {
            throw new EncryptedDocumentException("HashAlgorithm " + (Object)((Object)hashAlgo) + " not supported.");
        }
        keyData.setHashAlgorithm(xmlHashAlgo);
        keyPass.setHashAlgorithm(xmlHashAlgo);
        keyData.setSaltValue(header.getKeySalt());
        keyPass.setSaltValue(ver.getSalt());
        keyPass.setEncryptedVerifierHashInput(ver.getEncryptedVerifier());
        keyPass.setEncryptedVerifierHashValue(ver.getEncryptedVerifierHash());
        keyPass.setEncryptedKeyValue(ver.getEncryptedKey());
        CTDataIntegrity hmacData = edRoot.addNewDataIntegrity();
        hmacData.setEncryptedHmacKey(header.getEncryptedHmacKey());
        hmacData.setEncryptedHmacValue(header.getEncryptedHmacValue());
        for (AgileEncryptionVerifier.AgileCertificateEntry ace : ver.getCertificates()) {
            keyEnc = keyEncList.addNewKeyEncryptor();
            keyEnc.setUri(CTKeyEncryptor.Uri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_CERTIFICATE);
            CTCertificateKeyEncryptor certData = keyEnc.addNewEncryptedCertificateKey();
            try {
                certData.setX509Certificate(ace.x509.getEncoded());
            }
            catch (CertificateEncodingException e2) {
                throw new EncryptedDocumentException(e2);
            }
            certData.setEncryptedKeyValue(ace.encryptedKey);
            certData.setCertVerifier(ace.certVerifier);
        }
        XmlOptions xo = new XmlOptions();
        xo.setCharacterEncoding("UTF-8");
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("http://schemas.microsoft.com/office/2006/keyEncryptor/password", "p");
        nsMap.put("http://schemas.microsoft.com/office/2006/keyEncryptor/certificate", "c");
        nsMap.put("http://schemas.microsoft.com/office/2006/encryption", "");
        xo.setSaveSuggestedPrefixes(nsMap);
        xo.setSaveNamespacesFirst();
        xo.setSaveAggressiveNamespaces();
        xo.setSaveNoXmlDecl();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n".getBytes("UTF-8"));
        ed.save(bos, xo);
        final byte[] buf = new byte[5000];
        LittleEndianByteArrayOutputStream leos = new LittleEndianByteArrayOutputStream(buf, 0);
        EncryptionInfo info = this.builder.getInfo();
        leos.writeShort(info.getVersionMajor());
        leos.writeShort(info.getVersionMinor());
        leos.writeInt(64);
        leos.write(bos.toByteArray());
        dir.createDocument("EncryptionInfo", leos.getWriteIndex(), new POIFSWriterListener(){

            public void processPOIFSWriterEvent(POIFSWriterEvent event) {
                try {
                    event.getStream().write(buf, 0, event.getLimit());
                }
                catch (IOException e2) {
                    throw new EncryptedDocumentException(e2);
                }
            }
        });
    }

    private class ChunkedCipherOutputStream
    extends FilterOutputStream
    implements POIFSWriterListener {
        private long _pos;
        private final byte[] _chunk;
        private Cipher _cipher;
        private final File fileOut;
        protected final DirectoryNode dir;

        public ChunkedCipherOutputStream(DirectoryNode dir) throws IOException {
            super(null);
            this._pos = 0L;
            this._chunk = new byte[4096];
            this.fileOut = TempFile.createTempFile("encrypted_package", "crypt");
            this.out = new FileOutputStream(this.fileOut);
            this.dir = dir;
            AgileEncryptionHeader header = AgileEncryptor.this.builder.getHeader();
            this._cipher = CryptoFunctions.getCipher(AgileEncryptor.this.getSecretKey(), header.getCipherAlgorithm(), header.getChainingMode(), null, 1);
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            if (len < 0 || b.length < off + len) {
                throw new IOException("not enough bytes in your input buffer");
            }
            while (len > 0) {
                int posInChunk = (int)(this._pos & 0xFFFL);
                int nextLen = Math.min(4096 - posInChunk, len);
                System.arraycopy(b, off, this._chunk, posInChunk, nextLen);
                this._pos += (long)nextLen;
                off += nextLen;
                len -= nextLen;
                if ((this._pos & 0xFFFL) != 0L) continue;
                this.writeChunk();
            }
        }

        private void writeChunk() throws IOException {
            AgileEncryptionHeader header = AgileEncryptor.this.builder.getHeader();
            int blockSize = header.getBlockSize();
            int posInChunk = (int)(this._pos & 0xFFFL);
            int index = (int)(this._pos >> 12);
            if (posInChunk == 0) {
                --index;
                posInChunk = 4096;
            } else {
                this._cipher = CryptoFunctions.getCipher(AgileEncryptor.this.getSecretKey(), header.getCipherAlgorithm(), header.getChainingMode(), null, 1, "PKCS5Padding");
            }
            byte[] blockKey = new byte[4];
            LittleEndian.putInt(blockKey, 0, index);
            byte[] iv = CryptoFunctions.generateIv(header.getHashAlgorithmEx(), header.getKeySalt(), blockKey, blockSize);
            try {
                AlgorithmParameterSpec aps = header.getCipherAlgorithm() == CipherAlgorithm.rc2 ? new RC2ParameterSpec(AgileEncryptor.this.getSecretKey().getEncoded().length * 8, iv) : new IvParameterSpec(iv);
                this._cipher.init(1, (Key)AgileEncryptor.this.getSecretKey(), aps);
                int ciLen = this._cipher.doFinal(this._chunk, 0, posInChunk, this._chunk);
                this.out.write(this._chunk, 0, ciLen);
            }
            catch (GeneralSecurityException e2) {
                throw (IOException)new IOException().initCause(e2);
            }
        }

        public void close() throws IOException {
            this.writeChunk();
            super.close();
            this.writeToPOIFS();
        }

        void writeToPOIFS() throws IOException {
            int readBytes;
            DataSpaceMapUtils.addDefaultDataSpace(this.dir);
            byte[] buf = new byte[4096];
            LittleEndian.putLong(buf, 0, this._pos);
            AgileEncryptor.this.integrityMD.update(buf, 0, 8);
            FileInputStream fis = new FileInputStream(this.fileOut);
            while ((readBytes = ((InputStream)fis).read(buf)) != -1) {
                AgileEncryptor.this.integrityMD.update(buf, 0, readBytes);
            }
            ((InputStream)fis).close();
            AgileEncryptionHeader header = AgileEncryptor.this.builder.getHeader();
            int blockSize = header.getBlockSize();
            byte[] hmacValue = AgileEncryptor.this.integrityMD.doFinal();
            byte[] iv = CryptoFunctions.generateIv(header.getHashAlgorithmEx(), header.getKeySalt(), AgileDecryptor.kIntegrityValueBlock, header.getBlockSize());
            Cipher cipher = CryptoFunctions.getCipher(AgileEncryptor.this.getSecretKey(), header.getCipherAlgorithm(), header.getChainingMode(), iv, 1);
            try {
                byte[] hmacValueFilled = CryptoFunctions.getBlock0(hmacValue, AgileDecryptor.getNextBlockSize(hmacValue.length, blockSize));
                byte[] encryptedHmacValue = cipher.doFinal(hmacValueFilled);
                header.setEncryptedHmacValue(encryptedHmacValue);
            }
            catch (GeneralSecurityException e2) {
                throw new EncryptedDocumentException(e2);
            }
            AgileEncryptor.this.createEncryptionInfoEntry(this.dir);
            int oleStreamSize = (int)(this.fileOut.length() + 8L);
            this.dir.createDocument("EncryptedPackage", oleStreamSize, this);
        }

        public void processPOIFSWriterEvent(POIFSWriterEvent event) {
            try {
                LittleEndianOutputStream leos = new LittleEndianOutputStream(event.getStream());
                leos.writeLong(this._pos);
                FileInputStream fis = new FileInputStream(this.fileOut);
                IOUtils.copy(fis, leos);
                fis.close();
                this.fileOut.delete();
                leos.close();
            }
            catch (IOException e2) {
                throw new EncryptedDocumentException(e2);
            }
        }
    }
}

