/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;

public class SVFractionalFormat
extends Format {
    private short ONE_DIGIT = 1;
    private short TWO_DIGIT = (short)2;
    private short THREE_DIGIT = (short)3;
    private short UNITS = (short)4;
    private int units = 1;
    private short mode = (short)-1;

    public SVFractionalFormat(String formatStr) {
        if ("# ?/?".equals(formatStr)) {
            this.mode = this.ONE_DIGIT;
        } else if ("# ??/??".equals(formatStr)) {
            this.mode = this.TWO_DIGIT;
        } else if ("# ???/???".equals(formatStr)) {
            this.mode = this.THREE_DIGIT;
        } else if ("# ?/2".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 2;
        } else if ("# ?/4".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 4;
        } else if ("# ?/8".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 8;
        } else if ("# ?/16".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 16;
        } else if ("# ?/10".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 10;
        } else if ("# ?/100".equals(formatStr)) {
            this.mode = this.UNITS;
            this.units = 100;
        }
    }

    private String format(double f, int MaxDen) {
        double Frac;
        double Precision;
        long Whole = (long)f;
        int sign = 1;
        if (f < 0.0) {
            sign = -1;
        }
        double AllowedError = Precision = 1.0E-5;
        double d = Math.abs(f);
        double Diff2 = Frac = (d -= (double)Whole);
        long Num = 1L;
        long Den = 0L;
        long A = 0L;
        long B = 0L;
        long i = 0L;
        if (Frac > Precision) {
            while (true) {
                d = 1.0 / d;
                i = (long)(d + Precision);
                d -= (double)i;
                if (A > 0L) {
                    Num = i * Num + B;
                }
                Den = (long)((double)Num / Frac + 0.5);
                Diff2 = Math.abs((double)Num / (double)Den - Frac);
                if (Den > (long)MaxDen) {
                    if (A > 0L) {
                        Num = A;
                        Den = (long)((double)Num / Frac + 0.5);
                        Diff2 = Math.abs((double)Num / (double)Den - Frac);
                        break;
                    }
                    Num = 1L;
                    Den = MaxDen;
                    Diff2 = Math.abs((double)Num / (double)Den - Frac);
                    if (!(Diff2 > Frac)) break;
                    Num = 0L;
                    Den = 1L;
                    Diff2 = Frac;
                    break;
                }
                if (Diff2 <= AllowedError || d < Precision) break;
                Precision = AllowedError / Diff2;
                B = A;
                A = Num;
            }
        }
        if (Num == Den) {
            ++Whole;
            Num = 0L;
            Den = 0L;
        } else if (Den == 0L) {
            Num = 0L;
        }
        if (sign < 0) {
            if (Whole == 0L) {
                Num = -Num;
            } else {
                Whole = -Whole;
            }
        }
        return new StringBuffer().append(Whole).append(" ").append(Num).append("/").append(Den).toString();
    }

    private String formatUnit(double f, int units) {
        long Whole = (long)f;
        long Num = Math.round((f -= (double)Whole) * (double)units);
        return new StringBuffer().append(Whole).append(" ").append(Num).append("/").append(units).toString();
    }

    public final String format(double val) {
        if (this.mode == this.ONE_DIGIT) {
            return this.format(val, 9);
        }
        if (this.mode == this.TWO_DIGIT) {
            return this.format(val, 99);
        }
        if (this.mode == this.THREE_DIGIT) {
            return this.format(val, 999);
        }
        if (this.mode == this.UNITS) {
            return this.formatUnit(val, this.units);
        }
        throw new RuntimeException("Unexpected Case");
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            toAppendTo.append(this.format(((Number)obj).doubleValue()));
            return toAppendTo;
        }
        throw new IllegalArgumentException("Can only handle Numbers");
    }

    public Object parseObject(String source, ParsePosition status) {
        return null;
    }

    public Object parseObject(String source) throws ParseException {
        return null;
    }

    public Object clone() {
        return null;
    }
}

