/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.PropertiesChunk;
import org.apache.poi.util.LittleEndian;

public class MessagePropertiesChunk
extends PropertiesChunk {
    private long nextRecipientId;
    private long nextAttachmentId;
    private long recipientCount;
    private long attachmentCount;

    public MessagePropertiesChunk(ChunkGroup parentGroup) {
        super(parentGroup);
    }

    public long getNextRecipientId() {
        return this.nextRecipientId;
    }

    public long getNextAttachmentId() {
        return this.nextAttachmentId;
    }

    public long getRecipientCount() {
        return this.recipientCount;
    }

    public long getAttachmentCount() {
        return this.attachmentCount;
    }

    public void readValue(InputStream stream) throws IOException {
        LittleEndian.readLong(stream);
        this.nextRecipientId = LittleEndian.readUInt(stream);
        this.nextAttachmentId = LittleEndian.readUInt(stream);
        this.recipientCount = LittleEndian.readUInt(stream);
        this.attachmentCount = LittleEndian.readUInt(stream);
        LittleEndian.readLong(stream);
        this.readProperties(stream);
    }

    public void writeValue(OutputStream out) throws IOException {
        out.write(new byte[8]);
        LittleEndian.putUInt(this.nextRecipientId, out);
        LittleEndian.putUInt(this.nextAttachmentId, out);
        LittleEndian.putUInt(this.recipientCount, out);
        LittleEndian.putUInt(this.attachmentCount, out);
        out.write(new byte[8]);
        this.writeProperties(out);
    }
}

