/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.PPFont;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TitleMaster;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.DocumentAtom;
import org.apache.poi.hslf.record.ExAviMovie;
import org.apache.poi.hslf.record.ExControl;
import org.apache.poi.hslf.record.ExEmbed;
import org.apache.poi.hslf.record.ExEmbedAtom;
import org.apache.poi.hslf.record.ExHyperlink;
import org.apache.poi.hslf.record.ExHyperlinkAtom;
import org.apache.poi.hslf.record.ExMCIMovie;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.ExObjListAtom;
import org.apache.poi.hslf.record.ExOleObjAtom;
import org.apache.poi.hslf.record.ExOleObjStg;
import org.apache.poi.hslf.record.ExVideoContainer;
import org.apache.poi.hslf.record.FontCollection;
import org.apache.poi.hslf.record.FontEntityAtom;
import org.apache.poi.hslf.record.HeadersFootersContainer;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.PositionDependentRecordContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SoundData;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlideShow {
    private HSLFSlideShow _hslfSlideShow;
    private Record[] _mostRecentCoreRecords;
    private Map<Integer, Integer> _sheetIdToCoreRecordsLookup;
    private Document _documentRecord;
    private SlideMaster[] _masters;
    private TitleMaster[] _titleMasters;
    private org.apache.poi.hslf.model.Slide[] _slides;
    private org.apache.poi.hslf.model.Notes[] _notes;
    private FontCollection _fonts;
    private POILogger logger = POILogFactory.getLogger(this.getClass());

    public SlideShow(HSLFSlideShow hslfSlideShow) {
        this._hslfSlideShow = hslfSlideShow;
        for (Record record : this._hslfSlideShow.getRecords()) {
            if (!(record instanceof RecordContainer)) continue;
            RecordContainer.handleParentAwareRecords((RecordContainer)record);
        }
        this.findMostRecentCoreRecords();
        this.buildSlidesAndNotes();
    }

    public SlideShow() {
        this(HSLFSlideShow.create());
    }

    public SlideShow(InputStream inputStream) throws IOException {
        this(new HSLFSlideShow(inputStream));
    }

    private void findMostRecentCoreRecords() {
        HashMap mostRecentByBytes = new HashMap();
        for (Record record : this._hslfSlideShow.getRecords()) {
            int[] ids;
            if (!(record instanceof PersistPtrHolder)) continue;
            PersistPtrHolder pph = (PersistPtrHolder)record;
            for (int id : ids = pph.getKnownSlideIDs()) {
                if (!mostRecentByBytes.containsKey(id)) continue;
                mostRecentByBytes.remove(id);
            }
            Hashtable<Integer, Integer> thisSetOfLocations = pph.getSlideLocationsLookup();
            for (int id : ids) {
                mostRecentByBytes.put(id, thisSetOfLocations.get(id));
            }
        }
        this._mostRecentCoreRecords = new Record[mostRecentByBytes.size()];
        this._sheetIdToCoreRecordsLookup = new HashMap<Integer, Integer>();
        Object[] allIDs = mostRecentByBytes.keySet().toArray(new Integer[mostRecentByBytes.size()]);
        Arrays.sort(allIDs);
        for (int i = 0; i < allIDs.length; ++i) {
            this._sheetIdToCoreRecordsLookup.put((Integer)allIDs[i], i);
        }
        HashMap mostRecentByBytesRev = new HashMap(mostRecentByBytes.size());
        for (Map.Entry me : mostRecentByBytes.entrySet()) {
            mostRecentByBytesRev.put(me.getValue(), me.getKey());
        }
        for (Record record : this._hslfSlideShow.getRecords()) {
            PositionDependentRecord pdr;
            int recordAt;
            Integer thisID;
            if (!(record instanceof PositionDependentRecord) || (thisID = (Integer)mostRecentByBytesRev.get(recordAt = (pdr = (PositionDependentRecord)((Object)record)).getLastOnDiskOffset())) == null) continue;
            int storeAt = this._sheetIdToCoreRecordsLookup.get(thisID);
            if (pdr instanceof PositionDependentRecordContainer) {
                PositionDependentRecordContainer pdrc = (PositionDependentRecordContainer)record;
                pdrc.setSheetId(thisID);
            }
            this._mostRecentCoreRecords[storeAt] = record;
        }
        for (Record record : this._mostRecentCoreRecords) {
            if (record == null || record.getRecordType() != (long)RecordTypes.Document.typeID) continue;
            this._documentRecord = (Document)record;
            this._fonts = this._documentRecord.getEnvironment().getFontCollection();
        }
    }

    private Record getCoreRecordForSAS(SlideListWithText.SlideAtomsSet sas) {
        SlidePersistAtom spa = sas.getSlidePersistAtom();
        int refID = spa.getRefID();
        return this.getCoreRecordForRefID(refID);
    }

    private Record getCoreRecordForRefID(int refID) {
        Integer coreRecordId = this._sheetIdToCoreRecordsLookup.get(refID);
        if (coreRecordId != null) {
            Record r = this._mostRecentCoreRecords[coreRecordId];
            return r;
        }
        this.logger.log(7, "We tried to look up a reference to a core record, but there was no core ID for reference ID " + refID);
        return null;
    }

    private void buildSlidesAndNotes() {
        int i;
        Slide[] slidesRecords;
        Notes[] notesRecords;
        Record r;
        if (this._documentRecord == null) {
            throw new CorruptPowerPointFileException("The PowerPoint file didn't contain a Document Record in its PersistPtr blocks. It is probably corrupt.");
        }
        SlideListWithText masterSLWT = this._documentRecord.getMasterSlideListWithText();
        SlideListWithText slidesSLWT = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText notesSLWT = this._documentRecord.getNotesSlideListWithText();
        SlideListWithText.SlideAtomsSet[] masterSets = new SlideListWithText.SlideAtomsSet[]{};
        if (masterSLWT != null) {
            masterSets = masterSLWT.getSlideAtomsSets();
            ArrayList<MasterSheet> mmr = new ArrayList<MasterSheet>();
            ArrayList<MasterSheet> tmr = new ArrayList<MasterSheet>();
            for (SlideListWithText.SlideAtomsSet sas : masterSets) {
                MasterSheet master;
                r = this.getCoreRecordForSAS(sas);
                int sheetNo = sas.getSlidePersistAtom().getSlideIdentifier();
                if (r instanceof Slide) {
                    master = new TitleMaster((Slide)r, sheetNo);
                    master.setSlideShow(this);
                    tmr.add(master);
                    continue;
                }
                if (!(r instanceof MainMaster)) continue;
                master = new SlideMaster((MainMaster)r, sheetNo);
                ((SlideMaster)master).setSlideShow(this);
                mmr.add(master);
            }
            this._masters = mmr.toArray(new SlideMaster[mmr.size()]);
            this._titleMasters = tmr.toArray(new TitleMaster[tmr.size()]);
        }
        SlideListWithText.SlideAtomsSet[] notesSets = new SlideListWithText.SlideAtomsSet[]{};
        HashMap<Integer, Integer> slideIdToNotes = new HashMap<Integer, Integer>();
        if (notesSLWT == null) {
            notesRecords = new Notes[]{};
        } else {
            notesSets = notesSLWT.getSlideAtomsSets();
            ArrayList<Notes> notesRecordsL = new ArrayList<Notes>();
            for (int i2 = 0; i2 < notesSets.length; ++i2) {
                Record r2 = this.getCoreRecordForSAS(notesSets[i2]);
                if (r2 == null || r2 instanceof Notes) {
                    if (r2 == null) {
                        this.logger.log(5, "A Notes SlideAtomSet at " + i2 + " said its record was at refID " + notesSets[i2].getSlidePersistAtom().getRefID() + ", but that record didn't exist - record ignored.");
                    }
                    Notes notesRecord = (Notes)r2;
                    notesRecordsL.add(notesRecord);
                    SlidePersistAtom spa = notesSets[i2].getSlidePersistAtom();
                    int slideId = spa.getSlideIdentifier();
                    slideIdToNotes.put(slideId, i2);
                    continue;
                }
                this.logger.log(7, "A Notes SlideAtomSet at " + i2 + " said its record was at refID " + notesSets[i2].getSlidePersistAtom().getRefID() + ", but that was actually a " + r2);
            }
            notesRecords = new Notes[notesRecordsL.size()];
            notesRecords = notesRecordsL.toArray(notesRecords);
        }
        SlideListWithText.SlideAtomsSet[] slidesSets = new SlideListWithText.SlideAtomsSet[]{};
        if (slidesSLWT == null) {
            slidesRecords = new Slide[]{};
        } else {
            slidesSets = slidesSLWT.getSlideAtomsSets();
            slidesRecords = new Slide[slidesSets.length];
            for (int i3 = 0; i3 < slidesSets.length; ++i3) {
                r = this.getCoreRecordForSAS(slidesSets[i3]);
                if (r instanceof Slide) {
                    slidesRecords[i3] = (Slide)r;
                    continue;
                }
                this.logger.log(7, "A Slide SlideAtomSet at " + i3 + " said its record was at refID " + slidesSets[i3].getSlidePersistAtom().getRefID() + ", but that was actually a " + r);
            }
        }
        this._notes = new org.apache.poi.hslf.model.Notes[notesRecords.length];
        for (i = 0; i < this._notes.length; ++i) {
            if (notesRecords[i] == null) continue;
            this._notes[i] = new org.apache.poi.hslf.model.Notes(notesRecords[i]);
            this._notes[i].setSlideShow(this);
        }
        this._slides = new org.apache.poi.hslf.model.Slide[slidesRecords.length];
        for (i = 0; i < this._slides.length; ++i) {
            SlideListWithText.SlideAtomsSet sas = slidesSets[i];
            int slideIdentifier = sas.getSlidePersistAtom().getSlideIdentifier();
            org.apache.poi.hslf.model.Notes notes = null;
            int noteId = slidesRecords[i].getSlideAtom().getNotesID();
            if (noteId != 0) {
                Integer notesPos = (Integer)slideIdToNotes.get(noteId);
                if (notesPos != null) {
                    notes = this._notes[notesPos];
                } else {
                    this.logger.log(7, "Notes not found for noteId=" + noteId);
                }
            }
            this._slides[i] = new org.apache.poi.hslf.model.Slide(slidesRecords[i], notes, sas, slideIdentifier, i + 1);
            this._slides[i].setSlideShow(this);
        }
    }

    public void write(OutputStream out) throws IOException {
        this._hslfSlideShow.write(out);
    }

    public Record[] getMostRecentCoreRecords() {
        return this._mostRecentCoreRecords;
    }

    public org.apache.poi.hslf.model.Slide[] getSlides() {
        return this._slides;
    }

    public org.apache.poi.hslf.model.Notes[] getNotes() {
        return this._notes;
    }

    public SlideMaster[] getSlidesMasters() {
        return this._masters;
    }

    public TitleMaster[] getTitleMasters() {
        return this._titleMasters;
    }

    public PictureData[] getPictureData() {
        return this._hslfSlideShow.getPictures();
    }

    public ObjectData[] getEmbeddedObjects() {
        return this._hslfSlideShow.getEmbeddedObjects();
    }

    public SoundData[] getSoundData() {
        return SoundData.find(this._documentRecord);
    }

    public Dimension getPageSize() {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        int pgx = (int)docatom.getSlideSizeX() * 72 / 576;
        int pgy = (int)docatom.getSlideSizeY() * 72 / 576;
        return new Dimension(pgx, pgy);
    }

    public void setPageSize(Dimension pgsize) {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        docatom.setSlideSizeX(pgsize.width * 576 / 72);
        docatom.setSlideSizeY(pgsize.height * 576 / 72);
    }

    protected FontCollection getFontCollection() {
        return this._fonts;
    }

    public Document getDocumentRecord() {
        return this._documentRecord;
    }

    public void reorderSlide(int oldSlideNumber, int newSlideNumber) {
        if (oldSlideNumber < 1 || newSlideNumber < 1) {
            throw new IllegalArgumentException("Old and new slide numbers must be greater than 0");
        }
        if (oldSlideNumber > this._slides.length || newSlideNumber > this._slides.length) {
            throw new IllegalArgumentException("Old and new slide numbers must not exceed the number of slides (" + this._slides.length + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] sas = slwt.getSlideAtomsSets();
        SlideListWithText.SlideAtomsSet tmp = sas[oldSlideNumber - 1];
        sas[oldSlideNumber - 1] = sas[newSlideNumber - 1];
        sas[newSlideNumber - 1] = tmp;
        ArrayList<Record> lst = new ArrayList<Record>();
        for (int i = 0; i < sas.length; ++i) {
            lst.add(sas[i].getSlidePersistAtom());
            Record[] r = sas[i].getSlideRecords();
            for (int j = 0; j < r.length; ++j) {
                lst.add(r[j]);
            }
            this._slides[i].setSlideNumber(i + 1);
        }
        Record[] r = lst.toArray(new Record[lst.size()]);
        slwt.setChildRecord(r);
    }

    public org.apache.poi.hslf.model.Slide removeSlide(int index) {
        int notesId;
        int lastSlideIdx = this._slides.length - 1;
        if (index < 0 || index > lastSlideIdx) {
            throw new IllegalArgumentException("Slide index (" + index + ") is out of range (0.." + lastSlideIdx + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] sas = slwt.getSlideAtomsSets();
        org.apache.poi.hslf.model.Slide removedSlide = null;
        ArrayList<Record> records = new ArrayList<Record>();
        ArrayList<SlideListWithText.SlideAtomsSet> sa = new ArrayList<SlideListWithText.SlideAtomsSet>();
        ArrayList<org.apache.poi.hslf.model.Slide> sl = new ArrayList<org.apache.poi.hslf.model.Slide>();
        ArrayList<org.apache.poi.hslf.model.Notes> nt = new ArrayList<org.apache.poi.hslf.model.Notes>();
        for (org.apache.poi.hslf.model.Notes notes : this.getNotes()) {
            nt.add(notes);
        }
        int num = 0;
        for (int i = 0; i < this._slides.length; ++i) {
            if (i != index) {
                sl.add(this._slides[i]);
                sa.add(sas[i]);
                this._slides[i].setSlideNumber(num++);
                records.add(sas[i].getSlidePersistAtom());
                records.addAll(Arrays.asList(sas[i].getSlideRecords()));
                continue;
            }
            removedSlide = this._slides[i];
            nt.remove(this._slides[i].getNotesSheet());
        }
        if (sa.size() == 0) {
            this._documentRecord.removeSlideListWithText(slwt);
        } else {
            slwt.setSlideAtomsSets(sa.toArray(new SlideListWithText.SlideAtomsSet[sa.size()]));
            slwt.setChildRecord(records.toArray(new Record[records.size()]));
        }
        this._slides = sl.toArray(new org.apache.poi.hslf.model.Slide[sl.size()]);
        if (removedSlide != null && (notesId = removedSlide.getSlideRecord().getSlideAtom().getNotesID()) != 0) {
            SlideListWithText nslwt = this._documentRecord.getNotesSlideListWithText();
            records = new ArrayList();
            ArrayList<SlideListWithText.SlideAtomsSet> na = new ArrayList<SlideListWithText.SlideAtomsSet>();
            for (SlideListWithText.SlideAtomsSet ns : nslwt.getSlideAtomsSets()) {
                if (ns.getSlidePersistAtom().getSlideIdentifier() == notesId) continue;
                na.add(ns);
                records.add(ns.getSlidePersistAtom());
                if (ns.getSlideRecords() == null) continue;
                records.addAll(Arrays.asList(ns.getSlideRecords()));
            }
            if (na.size() == 0) {
                this._documentRecord.removeSlideListWithText(nslwt);
            } else {
                nslwt.setSlideAtomsSets(na.toArray(new SlideListWithText.SlideAtomsSet[na.size()]));
                nslwt.setChildRecord(records.toArray(new Record[records.size()]));
            }
        }
        this._notes = nt.toArray(new org.apache.poi.hslf.model.Notes[nt.size()]);
        return removedSlide;
    }

    public org.apache.poi.hslf.model.Slide createSlide() {
        SlideListWithText slist = null;
        slist = this._documentRecord.getSlideSlideListWithText();
        if (slist == null) {
            slist = new SlideListWithText();
            slist.setInstance(0);
            this._documentRecord.addSlideListWithText(slist);
        }
        SlidePersistAtom prev = null;
        for (SlideListWithText.SlideAtomsSet sas : slist.getSlideAtomsSets()) {
            SlidePersistAtom spa = sas.getSlidePersistAtom();
            if (spa.getSlideIdentifier() < 0) continue;
            if (prev == null) {
                prev = spa;
            }
            if (prev.getSlideIdentifier() >= spa.getSlideIdentifier()) continue;
            prev = spa;
        }
        SlidePersistAtom sp = new SlidePersistAtom();
        sp.setSlideIdentifier(prev == null ? 256 : prev.getSlideIdentifier() + 1);
        slist.addSlidePersistAtom(sp);
        org.apache.poi.hslf.model.Slide slide = new org.apache.poi.hslf.model.Slide(sp.getSlideIdentifier(), sp.getRefID(), this._slides.length + 1);
        slide.setSlideShow(this);
        slide.onCreate();
        org.apache.poi.hslf.model.Slide[] s = new org.apache.poi.hslf.model.Slide[this._slides.length + 1];
        System.arraycopy(this._slides, 0, s, 0, this._slides.length);
        s[this._slides.length] = slide;
        this._slides = s;
        this.logger.log(3, "Added slide " + this._slides.length + " with ref " + sp.getRefID() + " and identifier " + sp.getSlideIdentifier());
        Slide slideRecord = slide.getSlideRecord();
        int psrId = this.addPersistentObject(slideRecord);
        sp.setRefID(psrId);
        slideRecord.setSheetId(psrId);
        slide.setMasterSheet(this._masters[0]);
        return slide;
    }

    public int addPicture(byte[] data, int format) throws IOException {
        EscherBSERecord bse;
        byte[] uid = PictureData.getChecksum(data);
        EscherContainerRecord dggContainer = this._documentRecord.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            bstore = new EscherContainerRecord();
            bstore.setRecordId((short)-4095);
            dggContainer.addChildBefore(bstore, -4085);
        } else {
            Iterator<EscherRecord> iter = bstore.getChildIterator();
            int i = 0;
            while (iter.hasNext()) {
                bse = (EscherBSERecord)iter.next();
                if (Arrays.equals(bse.getUid(), uid)) {
                    return i + 1;
                }
                ++i;
            }
        }
        PictureData pict = PictureData.create(format);
        pict.setData(data);
        int offset = this._hslfSlideShow.addPicture(pict);
        bse = new EscherBSERecord();
        bse.setRecordId((short)-4089);
        bse.setOptions((short)(2 | format << 4));
        bse.setSize(pict.getRawData().length + 8);
        bse.setUid(uid);
        bse.setBlipTypeMacOS((byte)format);
        bse.setBlipTypeWin32((byte)format);
        if (format == 2) {
            bse.setBlipTypeMacOS((byte)4);
        } else if (format == 3) {
            bse.setBlipTypeMacOS((byte)4);
        } else if (format == 4) {
            bse.setBlipTypeWin32((byte)3);
        }
        bse.setRef(0);
        bse.setOffset(offset);
        bse.setRemainingData(new byte[0]);
        bstore.addChildRecord(bse);
        int count = bstore.getChildRecords().size();
        bstore.setOptions((short)(count << 4 | 0xF));
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPicture(File pict, int format) throws IOException {
        int length = (int)pict.length();
        byte[] data = new byte[length];
        FileInputStream is = null;
        try {
            is = new FileInputStream(pict);
            is.read(data);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return this.addPicture(data, format);
    }

    public int addFont(PPFont font) {
        FontCollection fonts = this.getDocumentRecord().getEnvironment().getFontCollection();
        int idx = fonts.getFontIndex(font.getFontName());
        if (idx == -1) {
            idx = fonts.addFont(font.getFontName(), font.getCharSet(), font.getFontFlags(), font.getFontType(), font.getPitchAndFamily());
        }
        return idx;
    }

    public PPFont getFont(int idx) {
        FontCollection fonts = this.getDocumentRecord().getEnvironment().getFontCollection();
        for (Record ch : fonts.getChildRecords()) {
            FontEntityAtom atom;
            if (!(ch instanceof FontEntityAtom) || (atom = (FontEntityAtom)ch).getFontIndex() != idx) continue;
            return new PPFont(atom);
        }
        return null;
    }

    public int getNumberOfFonts() {
        return this.getDocumentRecord().getEnvironment().getFontCollection().getNumberOfFonts();
    }

    public HeadersFooters getSlideHeadersFooters() {
        String tag = this.getSlidesMasters()[0].getProgrammableTag();
        boolean ppt2007 = "___PPT12".equals(tag);
        HeadersFootersContainer hdd = null;
        for (Record ch : this._documentRecord.getChildRecords()) {
            if (!(ch instanceof HeadersFootersContainer) || ((HeadersFootersContainer)ch).getOptions() != 63) continue;
            hdd = (HeadersFootersContainer)ch;
            break;
        }
        boolean newRecord = false;
        if (hdd == null) {
            hdd = new HeadersFootersContainer(63);
            newRecord = true;
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    public HeadersFooters getNotesHeadersFooters() {
        String tag = this.getSlidesMasters()[0].getProgrammableTag();
        boolean ppt2007 = "___PPT12".equals(tag);
        HeadersFootersContainer hdd = null;
        for (Record ch : this._documentRecord.getChildRecords()) {
            if (!(ch instanceof HeadersFootersContainer) || ((HeadersFootersContainer)ch).getOptions() != 79) continue;
            hdd = (HeadersFootersContainer)ch;
            break;
        }
        boolean newRecord = false;
        if (hdd == null) {
            hdd = new HeadersFootersContainer(79);
            newRecord = true;
        }
        if (ppt2007 && this._notes.length > 0) {
            return new HeadersFooters(hdd, this._notes[0], newRecord, ppt2007);
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    public int addMovie(String path, int type) {
        ExMCIMovie mci;
        switch (type) {
            case 1: {
                mci = new ExMCIMovie();
                break;
            }
            case 2: {
                mci = new ExAviMovie();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Movie: " + type);
            }
        }
        ExVideoContainer exVideo = mci.getExVideo();
        exVideo.getExMediaAtom().setMask(0xE80000);
        exVideo.getPathAtom().setText(path);
        int objectId = this.addToObjListAtom(mci);
        exVideo.getExMediaAtom().setObjectId(objectId);
        return objectId;
    }

    public int addControl(String name, String progId) {
        ExControl ctrl = new ExControl();
        ctrl.setProgId(progId);
        ctrl.setMenuName(name);
        ctrl.setClipboardName(name);
        ExOleObjAtom oleObj = ctrl.getExOleObjAtom();
        oleObj.setDrawAspect(1);
        oleObj.setType(2);
        oleObj.setSubType(0);
        int objectId = this.addToObjListAtom(ctrl);
        oleObj.setObjID(objectId);
        return objectId;
    }

    public int addHyperlink(Hyperlink link) {
        ExHyperlink ctrl = new ExHyperlink();
        ExHyperlinkAtom obj = ctrl.getExHyperlinkAtom();
        if (link.getType() == 7) {
            ctrl.setLinkURL(link.getAddress(), 48);
        } else {
            ctrl.setLinkURL(link.getAddress());
        }
        ctrl.setLinkTitle(link.getTitle());
        int objectId = this.addToObjListAtom(ctrl);
        link.setId(objectId);
        obj.setNumber(objectId);
        return objectId;
    }

    public int addEmbed(POIFSFileSystem poiData) {
        DirectoryNode root = poiData.getRoot();
        if (new ClassID().equals(root.getStorageClsid())) {
            Map<String, ClassID> olemap = SlideShow.getOleMap();
            ClassID classID = null;
            for (Map.Entry<String, ClassID> entry : olemap.entrySet()) {
                if (!root.hasEntry(entry.getKey())) continue;
                classID = entry.getValue();
                break;
            }
            if (classID == null) {
                throw new IllegalArgumentException("Unsupported embedded document");
            }
            root.setStorageClsid(classID);
        }
        ExEmbed exEmbed = new ExEmbed();
        Record[] children = exEmbed.getChildRecords();
        exEmbed.removeChild(children[2]);
        exEmbed.removeChild(children[3]);
        exEmbed.removeChild(children[4]);
        ExEmbedAtom eeEmbed = exEmbed.getExEmbedAtom();
        eeEmbed.setCantLockServerB(true);
        ExOleObjAtom eeAtom = exEmbed.getExOleObjAtom();
        eeAtom.setDrawAspect(1);
        eeAtom.setType(0);
        eeAtom.setOptions(1226240);
        ExOleObjStg exOleObjStg = new ExOleObjStg();
        try {
            String OLESTREAM_NAME = "\u0001Ole";
            if (!root.hasEntry("\u0001Ole")) {
                byte[] oleBytes = new byte[]{1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                poiData.createDocument(new ByteArrayInputStream(oleBytes), "\u0001Ole");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            poiData.writeFilesystem(bos);
            exOleObjStg.setData(bos.toByteArray());
        }
        catch (IOException e2) {
            throw new HSLFException(e2);
        }
        int psrId = this.addPersistentObject(exOleObjStg);
        exOleObjStg.setPersistId(psrId);
        eeAtom.setObjStgDataRef(psrId);
        int objectId = this.addToObjListAtom(exEmbed);
        eeAtom.setObjID(objectId);
        return objectId;
    }

    protected int addToObjListAtom(RecordContainer exObj) {
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        lst.addChildAfter(exObj, objAtom);
        return objectId;
    }

    protected static Map<String, ClassID> getOleMap() {
        HashMap<String, ClassID> olemap = new HashMap<String, ClassID>();
        olemap.put("PowerPoint Document", ClassID.PPT_SHOW);
        olemap.put("Workbook", ClassID.EXCEL97);
        olemap.put("WORKBOOK", ClassID.EXCEL97);
        olemap.put("BOOK", ClassID.EXCEL97);
        return olemap;
    }

    protected int addPersistentObject(PositionDependentRecord slideRecord) {
        slideRecord.setLastOnDiskOffset(-1);
        this._hslfSlideShow.appendRootLevelRecord((Record)((Object)slideRecord));
        HashMap<RecordTypes.Type, PositionDependentRecord> interestingRecords = new HashMap<RecordTypes.Type, PositionDependentRecord>();
        try {
            this._hslfSlideShow.updateAndWriteDependantRecords(null, interestingRecords);
        }
        catch (IOException e2) {
            throw new HSLFException(e2);
        }
        PersistPtrHolder ptr = (PersistPtrHolder)interestingRecords.get(RecordTypes.PersistPtrIncrementalBlock);
        UserEditAtom usr = (UserEditAtom)interestingRecords.get(RecordTypes.UserEditAtom);
        int psrId = usr.getMaxPersistWritten() + 1;
        usr.setLastViewType((short)1);
        usr.setMaxPersistWritten(psrId);
        int slideOffset = slideRecord.getLastOnDiskOffset();
        slideRecord.setLastOnDiskOffset(slideOffset);
        ptr.addSlideLookup(psrId, slideOffset);
        this.logger.log(3, "New slide/object ended up at " + slideOffset);
        return psrId;
    }
}

