/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.hslf.usermodel.SoundData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;

public final class DataExtraction {
    public static void main(String[] args) throws Exception {
        FileOutputStream out;
        String name;
        Object data;
        Shape[] shape;
        int i;
        if (args.length == 0) {
            DataExtraction.usage();
            return;
        }
        FileInputStream is = new FileInputStream(args[0]);
        SlideShow ppt = new SlideShow(is);
        is.close();
        SoundData[] sound = ppt.getSoundData();
        for (int i2 = 0; i2 < sound.length; ++i2) {
            String type = sound[i2].getSoundType();
            String name2 = sound[i2].getSoundName();
            byte[] data2 = sound[i2].getData();
            FileOutputStream out2 = new FileOutputStream(name2 + type);
            out2.write(data2);
            out2.close();
        }
        Slide[] slide = ppt.getSlides();
        for (i = 0; i < slide.length; ++i) {
            shape = slide[i].getShapes();
            for (int j = 0; j < shape.length; ++j) {
                int count;
                if (!(shape[j] instanceof OLEShape)) continue;
                OLEShape ole = (OLEShape)shape[j];
                data = ole.getObjectData();
                name = ole.getInstanceName();
                if ("Worksheet".equals(name)) {
                    HSSFWorkbook wb = new HSSFWorkbook(((ObjectData)data).getData());
                    continue;
                }
                if ("Document".equals(name)) {
                    HWPFDocument doc = new HWPFDocument(((ObjectData)data).getData());
                    Range r = doc.getRange();
                    for (int k = 0; k < r.numParagraphs(); ++k) {
                        Paragraph p = r.getParagraph(k);
                        System.out.println(p.text());
                    }
                    out = new FileOutputStream(name + "-(" + j + ").doc");
                    doc.write(out);
                    out.close();
                    continue;
                }
                FileOutputStream out3 = new FileOutputStream(ole.getProgID() + "-" + (j + 1) + ".dat");
                InputStream dis = ((ObjectData)data).getData();
                byte[] chunk = new byte[2048];
                while ((count = dis.read(chunk)) >= 0) {
                    out3.write(chunk, 0, count);
                }
                is.close();
                out3.close();
            }
        }
        for (i = 0; i < slide.length; ++i) {
            shape = slide[i].getShapes();
            block14: for (int j = 0; j < shape.length; ++j) {
                String ext;
                if (!(shape[j] instanceof Picture)) continue;
                Picture p = (Picture)shape[j];
                data = p.getPictureData();
                name = p.getPictureName();
                int type = ((PictureData)data).getType();
                switch (type) {
                    case 5: {
                        ext = ".jpg";
                        break;
                    }
                    case 6: {
                        ext = ".png";
                        break;
                    }
                    case 3: {
                        ext = ".wmf";
                        break;
                    }
                    case 2: {
                        ext = ".emf";
                        break;
                    }
                    case 4: {
                        ext = ".pict";
                        break;
                    }
                    case 7: {
                        ext = ".dib";
                        break;
                    }
                    default: {
                        continue block14;
                    }
                }
                out = new FileOutputStream("pict-" + j + ext);
                out.write(((PictureData)data).getData());
                out.close();
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: DataExtraction  ppt");
    }
}

