/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.DecodeOptions;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.image.CCITTFactory;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PNGConverter;
import org.apache.pdfbox.pdmodel.graphics.image.SampledImageReader;
import org.apache.pdfbox.util.filetypedetector.FileType;
import org.apache.pdfbox.util.filetypedetector.FileTypeDetector;

public final class PDImageXObject
extends PDXObject
implements PDImage {
    private static final Log LOG = LogFactory.getLog(PDImageXObject.class);
    private SoftReference<BufferedImage> cachedImage;
    private PDColorSpace colorSpace;
    private int cachedImageSubsampling = Integer.MAX_VALUE;
    private final PDResources resources;

    public PDImageXObject(PDDocument document) throws IOException {
        this(new PDStream(document), (PDResources)null);
    }

    public PDImageXObject(PDDocument document, InputStream encodedStream, COSBase cosFilter, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        super(PDImageXObject.createRawStream(document, encodedStream), COSName.IMAGE);
        this.getCOSObject().setItem(COSName.FILTER, cosFilter);
        this.resources = null;
        this.colorSpace = null;
        this.setBitsPerComponent(bitsPerComponent);
        this.setWidth(width);
        this.setHeight(height);
        this.setColorSpace(initColorSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDImageXObject(PDStream stream, PDResources resources) throws IOException {
        super(stream, COSName.IMAGE);
        this.resources = resources;
        List<COSName> filters = stream.getFilters();
        if (filters != null && !filters.isEmpty() && COSName.JPX_DECODE.equals(filters.get(filters.size() - 1))) {
            COSInputStream is = null;
            try {
                is = stream.createInputStream();
                DecodeResult decodeResult = is.getDecodeResult();
                stream.getCOSObject().addAll(decodeResult.getParameters());
                this.colorSpace = decodeResult.getJPXColorSpace();
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    public static PDImageXObject createThumbnail(COSStream cosStream) throws IOException {
        PDStream pdStream = new PDStream(cosStream);
        return new PDImageXObject(pdStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static COSStream createRawStream(PDDocument document, InputStream rawInput) throws IOException {
        COSStream stream = document.getDocument().createCOSStream();
        OutputStream output = null;
        try {
            output = stream.createRawOutputStream();
            IOUtils.copy(rawInput, output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return stream;
    }

    public static PDImageXObject createFromFile(String imagePath, PDDocument doc) throws IOException {
        return PDImageXObject.createFromFileByExtension(new File(imagePath), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDImageXObject createFromFileByExtension(File file, PDDocument doc) throws IOException {
        String name = file.getName();
        int dot = file.getName().lastIndexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("Image type not supported: " + name);
        }
        String ext = name.substring(dot + 1).toLowerCase();
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            PDImageXObject pDImageXObject;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                pDImageXObject = JPEGFactory.createFromStream(doc, fis);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return pDImageXObject;
        }
        if ("tif".equals(ext) || "tiff".equals(ext)) {
            return CCITTFactory.createFromFile(doc, file);
        }
        if ("gif".equals(ext) || "bmp".equals(ext) || "png".equals(ext)) {
            BufferedImage bim = ImageIO.read(file);
            return LosslessFactory.createFromImage(doc, bim);
        }
        throw new IllegalArgumentException("Image type not supported: " + name);
    }

    public static PDImageXObject createFromFileByContent(File file, PDDocument doc) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileType fileType = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            fileType = FileTypeDetector.detectFileType(bufferedInputStream);
        }
        catch (IOException e2) {
            try {
                throw new IOException("Could not determine file type: " + file.getName(), e2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileInputStream);
        IOUtils.closeQuietly(bufferedInputStream);
        if (fileType == null) {
            throw new IllegalArgumentException("Image type not supported: " + file.getName());
        }
        if (fileType.equals((Object)FileType.JPEG)) {
            FileInputStream fis = new FileInputStream(file);
            PDImageXObject imageXObject = JPEGFactory.createFromStream(doc, fis);
            fis.close();
            return imageXObject;
        }
        if (fileType.equals((Object)FileType.TIFF)) {
            try {
                return CCITTFactory.createFromFile(doc, file);
            }
            catch (IOException ex) {
                LOG.debug("Reading as TIFF failed, setting fileType to PNG", ex);
                fileType = FileType.PNG;
            }
        }
        if (fileType.equals((Object)FileType.BMP) || fileType.equals((Object)FileType.GIF) || fileType.equals((Object)FileType.PNG)) {
            BufferedImage bim = ImageIO.read(file);
            return LosslessFactory.createFromImage(doc, bim);
        }
        throw new IllegalArgumentException("Image type " + (Object)((Object)fileType) + " not supported: " + file.getName());
    }

    public static PDImageXObject createFromByteArray(PDDocument document, byte[] byteArray, String name) throws IOException {
        PDImageXObject image;
        FileType fileType;
        try {
            fileType = FileTypeDetector.detectFileType(byteArray);
        }
        catch (IOException e2) {
            throw new IOException("Could not determine file type: " + name, e2);
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Image type not supported: " + name);
        }
        if (fileType.equals((Object)FileType.JPEG)) {
            return JPEGFactory.createFromByteArray(document, byteArray);
        }
        if (fileType.equals((Object)FileType.PNG) && (image = PNGConverter.convertPNGImage(document, byteArray)) != null) {
            return image;
        }
        if (fileType.equals((Object)FileType.TIFF)) {
            try {
                return CCITTFactory.createFromByteArray(document, byteArray);
            }
            catch (IOException ex) {
                LOG.debug("Reading as TIFF failed, setting fileType to PNG", ex);
                fileType = FileType.PNG;
            }
        }
        if (fileType.equals((Object)FileType.BMP) || fileType.equals((Object)FileType.GIF) || fileType.equals((Object)FileType.PNG)) {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            BufferedImage bim = ImageIO.read(bais);
            return LosslessFactory.createFromImage(document, bim);
        }
        throw new IllegalArgumentException("Image type " + (Object)((Object)fileType) + " not supported: " + name);
    }

    public PDMetadata getMetadata() {
        COSStream cosStream = this.getCOSObject().getCOSStream(COSName.METADATA);
        if (cosStream != null) {
            return new PDMetadata(cosStream);
        }
        return null;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSObject().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSObject().getInt(COSName.STRUCT_PARENT);
    }

    public void setStructParent(int key) {
        this.getCOSObject().setInt(COSName.STRUCT_PARENT, key);
    }

    @Override
    public BufferedImage getImage() throws IOException {
        return this.getImage(null, 1);
    }

    @Override
    public BufferedImage getImage(Rectangle region, int subsampling) throws IOException {
        BufferedImage cached;
        if (region == null && subsampling == this.cachedImageSubsampling && this.cachedImage != null && (cached = this.cachedImage.get()) != null) {
            return cached;
        }
        BufferedImage image = SampledImageReader.getRGBImage(this, region, subsampling, this.getColorKeyMask());
        PDImageXObject softMask = this.getSoftMask();
        if (softMask != null) {
            float[] matte = this.extractMatte(softMask);
            image = this.applyMask(image, softMask.getOpaqueImage(), true, matte);
        } else {
            PDImageXObject mask = this.getMask();
            if (mask != null && mask.isStencil()) {
                image = this.applyMask(image, mask.getOpaqueImage(), false, null);
            }
        }
        if (region == null && subsampling <= this.cachedImageSubsampling) {
            this.cachedImageSubsampling = subsampling;
            this.cachedImage = new SoftReference<BufferedImage>(image);
        }
        return image;
    }

    @Override
    public BufferedImage getRawImage() throws IOException {
        return this.getColorSpace().toRawImage(this.getRawRaster());
    }

    @Override
    public WritableRaster getRawRaster() throws IOException {
        return SampledImageReader.getRawRaster(this);
    }

    private float[] extractMatte(PDImageXObject softMask) throws IOException {
        COSBase base = softMask.getCOSObject().getItem(COSName.MATTE);
        float[] matte = null;
        if (base instanceof COSArray) {
            matte = ((COSArray)base).toFloatArray();
            if (matte.length < this.getColorSpace().getNumberOfComponents()) {
                LOG.error("Image /Matte entry not long enough for colorspace, skipped");
                return null;
            }
            matte = this.getColorSpace().toRGB(matte);
        }
        return matte;
    }

    @Override
    public BufferedImage getStencilImage(Paint paint) throws IOException {
        if (!this.isStencil()) {
            throw new IllegalStateException("Image is not a stencil");
        }
        return SampledImageReader.getStencilImage(this, paint);
    }

    public BufferedImage getOpaqueImage() throws IOException {
        return SampledImageReader.getRGBImage(this, null);
    }

    private BufferedImage applyMask(BufferedImage image, BufferedImage mask, boolean isSoft, float[] matte) {
        if (mask == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (mask.getWidth() < width || mask.getHeight() < height) {
            mask = this.scaleImage(mask, width, height);
        } else if (mask.getWidth() > width || mask.getHeight() > height) {
            width = mask.getWidth();
            height = mask.getHeight();
            image = this.scaleImage(image, width, height);
        } else if (image.getRaster().getPixel(0, 0, (int[])null).length < 3) {
            image = this.scaleImage(image, width, height);
        }
        BufferedImage masked = new BufferedImage(width, height, 2);
        WritableRaster src = image.getRaster();
        WritableRaster dest = masked.getRaster();
        WritableRaster alpha = mask.getRaster();
        float[] rgb = new float[4];
        float[] rgba = new float[4];
        float[] alphaPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                src.getPixel(x, y, rgb);
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                alphaPixel = alpha.getPixel(x, y, alphaPixel);
                if (isSoft) {
                    rgba[3] = alphaPixel[0];
                    if (matte != null && Float.compare(alphaPixel[0], 0.0f) != 0) {
                        rgba[0] = this.clampColor(((rgba[0] / 255.0f - matte[0]) / (alphaPixel[0] / 255.0f) + matte[0]) * 255.0f);
                        rgba[1] = this.clampColor(((rgba[1] / 255.0f - matte[1]) / (alphaPixel[0] / 255.0f) + matte[1]) * 255.0f);
                        rgba[2] = this.clampColor(((rgba[2] / 255.0f - matte[2]) / (alphaPixel[0] / 255.0f) + matte[2]) * 255.0f);
                    }
                } else {
                    rgba[3] = 255.0f - alphaPixel[0];
                }
                dest.setPixel(x, y, rgba);
            }
        }
        return masked;
    }

    private float clampColor(float color) {
        return color < 0.0f ? 0.0f : (color > 255.0f ? 255.0f : color);
    }

    private BufferedImage scaleImage(BufferedImage image, int width, int height) {
        BufferedImage image2 = new BufferedImage(width, height, 1);
        Graphics2D g = image2.createGraphics();
        if (this.getInterpolate()) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        g.drawImage(image, 0, 0, width, height, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return image2;
    }

    public PDImageXObject getMask() throws IOException {
        COSBase mask = this.getCOSObject().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return null;
        }
        COSStream cosStream = this.getCOSObject().getCOSStream(COSName.MASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    public COSArray getColorKeyMask() {
        COSBase mask = this.getCOSObject().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return (COSArray)mask;
        }
        return null;
    }

    public PDImageXObject getSoftMask() throws IOException {
        COSStream cosStream = this.getCOSObject().getCOSStream(COSName.SMASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        return this.getCOSObject().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC);
    }

    @Override
    public void setBitsPerComponent(int bpc) {
        this.getCOSObject().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSObject().getItem(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                COSObject indirect = null;
                if (cosBase instanceof COSObject && this.resources != null && this.resources.getResourceCache() != null) {
                    indirect = (COSObject)cosBase;
                    this.colorSpace = this.resources.getResourceCache().getColorSpace(indirect);
                    if (this.colorSpace != null) {
                        return this.colorSpace;
                    }
                }
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
                if (indirect != null) {
                    this.resources.getResourceCache().put(indirect, this.colorSpace);
                }
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.getStream().createInputStream();
    }

    @Override
    public InputStream createInputStream(DecodeOptions options) throws IOException {
        return this.getStream().createInputStream(options);
    }

    @Override
    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        return this.getStream().createInputStream(stopFilters);
    }

    @Override
    public boolean isEmpty() {
        return this.getStream().getCOSObject().getLength() == 0L;
    }

    @Override
    public void setColorSpace(PDColorSpace cs) {
        this.getCOSObject().setItem(COSName.COLORSPACE, cs != null ? cs.getCOSObject() : null);
        this.colorSpace = null;
        this.cachedImage = null;
    }

    @Override
    public int getHeight() {
        return this.getCOSObject().getInt(COSName.HEIGHT);
    }

    @Override
    public void setHeight(int h) {
        this.getCOSObject().setInt(COSName.HEIGHT, h);
    }

    @Override
    public int getWidth() {
        return this.getCOSObject().getInt(COSName.WIDTH);
    }

    @Override
    public void setWidth(int w) {
        this.getCOSObject().setInt(COSName.WIDTH, w);
    }

    @Override
    public boolean getInterpolate() {
        return this.getCOSObject().getBoolean(COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.getCOSObject().setBoolean(COSName.INTERPOLATE, value);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.getCOSObject().setItem(COSName.DECODE, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        COSBase decode = this.getCOSObject().getDictionaryObject(COSName.DECODE);
        if (decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    @Override
    public boolean isStencil() {
        return this.getCOSObject().getBoolean(COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.getCOSObject().setBoolean(COSName.IMAGE_MASK, isStencil);
    }

    @Override
    public String getSuffix() {
        List<COSName> filters = this.getStream().getFilters();
        if (filters == null) {
            return "png";
        }
        if (filters.contains(COSName.DCT_DECODE)) {
            return "jpg";
        }
        if (filters.contains(COSName.JPX_DECODE)) {
            return "jpx";
        }
        if (filters.contains(COSName.CCITTFAX_DECODE)) {
            return "tiff";
        }
        if (filters.contains(COSName.FLATE_DECODE) || filters.contains(COSName.LZW_DECODE) || filters.contains(COSName.RUN_LENGTH_DECODE)) {
            return "png";
        }
        if (filters.contains(COSName.JBIG2_DECODE)) {
            return "jb2";
        }
        LOG.warn("getSuffix() returns null, filters: " + filters);
        return null;
    }

    public PDPropertyList getOptionalContent() {
        COSBase base = this.getCOSObject().getDictionaryObject(COSName.OC);
        if (base instanceof COSDictionary) {
            return PDPropertyList.create((COSDictionary)base);
        }
        return null;
    }

    public void setOptionalContent(PDPropertyList oc) {
        this.getCOSObject().setItem(COSName.OC, (COSObjectable)oc);
    }
}

