/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.stream.Locator;
import org.apache.jena.riot.stream.StreamManager;
import org.apache.jena.riot.system.IRILib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorFile
implements Locator {
    static Logger log = LoggerFactory.getLogger(LocatorFile.class);
    private final String thisDir;
    private final String thisDirLogStr;

    public LocatorFile() {
        this(null);
    }

    public LocatorFile(String dir) {
        if (dir != null) {
            if (dir.endsWith("/") || dir.endsWith(File.separator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            this.thisDirLogStr = " [" + dir + "]";
        } else {
            this.thisDirLogStr = "";
        }
        this.thisDir = dir;
    }

    public String toFileName(String filenameIRI) {
        String scheme = FileUtils.getScheme(filenameIRI);
        String fn = filenameIRI;
        if (scheme != null) {
            if (scheme.length() == 1) {
                return fn;
            }
            if (scheme.length() > 1) {
                if (!scheme.equalsIgnoreCase("file")) {
                    return null;
                }
                fn = IRILib.IRIToFilename(filenameIRI);
            }
        }
        return this.absolute(fn);
    }

    private String absolute(String fn) {
        if (this.thisDir != null && !fn.startsWith("/") && !fn.startsWith(File.separator)) {
            fn = this.thisDir + File.separator + fn;
        }
        return fn;
    }

    public String getThisDir() {
        return this.thisDir;
    }

    public boolean hasCurrentDir() {
        return this.thisDir != null;
    }

    public boolean exists(String fileIRI) {
        String fn = this.toFileName(fileIRI);
        if (fn == null) {
            return false;
        }
        return this.exists$(fn);
    }

    private boolean exists$(String fn) {
        return new File(fn).exists();
    }

    @Override
    public TypedInputStream open(String filenameIRI) {
        String fn = this.toFileName(filenameIRI);
        if (fn == null) {
            return null;
        }
        try {
            if (!this.exists$(fn)) {
                if (StreamManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameIRI + this.thisDirLogStr);
                }
                return null;
            }
        }
        catch (AccessControlException e2) {
            log.warn("Security problem testing for file", (Throwable)e2);
            return null;
        }
        try {
            InputStream in = IO.openFileEx(fn);
            if (StreamManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameIRI + this.thisDirLogStr);
            }
            ContentType ct = RDFLanguages.guessContentType(filenameIRI);
            return new TypedInputStream(in, ct, filenameIRI);
        }
        catch (IOException ioEx) {
            log.warn("File unreadable (but exists): " + fn + " Exception: " + ioEx.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        String tmp = "LocatorFile";
        if (this.thisDir != null) {
            tmp = tmp + "(" + this.thisDir + ")";
        }
        return tmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.thisDir == null ? 0 : this.thisDir.hashCode());
        result = 31 * result + (this.thisDirLogStr == null ? 0 : this.thisDirLogStr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocatorFile other = (LocatorFile)obj;
        if (this.thisDir == null ? other.thisDir != null : !this.thisDir.equals(other.thisDir)) {
            return false;
        }
        return !(this.thisDirLogStr == null ? other.thisDirLogStr != null : !this.thisDirLogStr.equals(other.thisDirLogStr));
    }
}

