/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.sparql.util.Context;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.StreamRDF;

public class RDFParserRegistry {
    private static Map<String, Lang> mapJenaNameToLang = DS.map();
    private static Map<Lang, ReaderRIOTFactory> langToParserFactory = DS.map();
    private static Set<Lang> langTriples = DS.set();
    private static Set<Lang> langQuads = DS.set();
    private static ReaderRIOTFactory parserFactory = new ReaderRIOTFactoryImpl();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RDFParserRegistry.initStandard();
    }

    private static void initStandard() {
        RDFLanguages.init();
        RDFParserRegistry.registerLangTriples(RDFLanguages.RDFXML, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.NTRIPLES, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.N3, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.TURTLE, parserFactory);
        RDFParserRegistry.registerLangTriples(RDFLanguages.RDFJSON, parserFactory);
        RDFParserRegistry.registerLangQuads(RDFLanguages.NQUADS, parserFactory);
        RDFParserRegistry.registerLangQuads(RDFLanguages.TRIG, parserFactory);
    }

    private static void registerLang(Lang lang, ReaderRIOTFactory factory) {
        RDFLanguages.register(lang);
        langToParserFactory.put(lang, factory);
    }

    public static void registerLangTriples(Lang lang, ReaderRIOTFactory factory) {
        langTriples.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void registerLangQuads(Lang lang, ReaderRIOTFactory factory) {
        langQuads.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void removeRegistration(Lang lang) {
        RDFLanguages.unregister(lang);
        langToParserFactory.remove(lang);
    }

    public static ReaderRIOTFactory getFactory(Lang language) {
        return langToParserFactory.get(language);
    }

    public static boolean isTriples(Lang lang) {
        return langTriples.contains(lang);
    }

    public static boolean isQuads(Lang lang) {
        return langQuads.contains(lang);
    }

    static {
        RDFParserRegistry.init();
    }

    private static class ReaderRIOTFactoryImpl
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryImpl() {
        }

        @Override
        public ReaderRIOT create(final Lang lang) {
            return new ReaderRIOT(){

                @Override
                public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
                    LangRIOT parser = RiotReader.createParser(in, lang, baseURI, output);
                    parser.parse();
                }

                @Override
                public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context) {
                    LangRIOT parser = RiotReader.createParser(in, lang, baseURI, output);
                    parser.parse();
                }
            };
        }
    }
}

