/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import org.apache.jena.atlas.web.MediaType;

public class ContentType {
    private MediaType mediaType;
    private static final String charsetParamName = "charset";

    @Deprecated
    public static ContentType parse(String string) {
        return ContentType.create(string);
    }

    public static ContentType create(String string) {
        if (string == null) {
            return null;
        }
        ContentType ct = new ContentType(MediaType.create(string));
        return ct;
    }

    public static ContentType create(String ctString, String charset) {
        MediaType.ParsedMediaType x = MediaType.parse(ctString);
        x.params.put(charsetParamName, charset);
        return new ContentType(new MediaType(x));
    }

    private ContentType(MediaType m) {
        this.mediaType = m;
    }

    public String getContentType() {
        return this.mediaType.getContentType();
    }

    public String getCharset() {
        return this.mediaType.getCharset();
    }

    public String getType() {
        return this.mediaType.getType();
    }

    public String getSubType() {
        return this.mediaType.getSubType();
    }

    public String toHeaderString() {
        return this.mediaType.toHeaderString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        return !(this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType));
    }

    public String toString() {
        return this.mediaType.toString();
    }
}

