/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.query;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.rootdev.javardfa.StatementSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCollector
implements StatementSink {
    static final Logger log = LoggerFactory.getLogger(QueryCollector.class);
    private static final Node FormType = Node.createURI("http://www.w3.org/1999/xhtml/vocab/#form");
    private static final TypeMapper TMapper = TypeMapper.getInstance();
    private final Map<String, Query> queries = new HashMap<String, Query>();
    private List<Triple> currentQuery;
    private String currentQueryName;
    private final Map<String, String> prefixMapping = new HashMap<String, String>();

    public Map<String, Query> getQueries() {
        return Collections.unmodifiableMap(this.queries);
    }

    @Override
    public void addLiteral(String arg0, String arg1, String arg2, String arg3, String arg4) {
        Node subject = this.getNode(arg0);
        Node predicate = this.getNode(arg1);
        Node object = this.getLiteralNode(arg2, arg3, arg4);
        this.addTriple(subject, predicate, object);
    }

    @Override
    public void addObject(String arg0, String arg1, String arg2) {
        Node subject = this.getNode(arg0);
        Node predicate = this.getNode(arg1);
        Node object = this.getNode(arg2);
        this.addTriple(subject, predicate, object);
    }

    private void addTriple(Node subject, Node predicate, Node object) {
        if (RDF.type.asNode().equals(predicate) && FormType.equals(object)) {
            if (this.currentQueryName != null) {
                this.queries.put(this.currentQueryName, this.createQuery(this.currentQuery));
            }
            this.currentQueryName = subject.getURI();
            this.currentQuery = new LinkedList<Triple>();
            return;
        }
        if (this.currentQueryName == null) {
            return;
        }
        this.currentQuery.add(Triple.create(subject, predicate, object));
    }

    private Node getLiteralNode(String arg2, String arg3, String arg4) {
        if (arg3 == null && arg4 == null) {
            return Node.createLiteral(arg2);
        }
        if (arg4 == null) {
            return Node.createLiteral(arg2, arg3, false);
        }
        return Node.createLiteral(arg2, null, TMapper.getSafeTypeByName(arg4));
    }

    private Node getNode(String arg0) {
        if (arg0.startsWith("_:")) {
            return Node.createAnon(AnonId.create(arg0.substring(2)));
        }
        if (arg0.startsWith("?")) {
            return Var.alloc(arg0.substring(1));
        }
        return Node.createURI(arg0);
    }

    @Override
    public void end() {
        if (this.currentQueryName != null) {
            this.queries.put(this.currentQueryName, this.createQuery(this.currentQuery));
        }
    }

    @Override
    public void start() {
    }

    public Query createQuery(List<Triple> triples) {
        log.info("Create query");
        Query query2 = new Query();
        ElementGroup body = new ElementGroup();
        for (Triple t : triples) {
            body.addTriplePattern(t);
        }
        ElementNamedGraph pattern = new ElementNamedGraph(Var.alloc("graph"), body);
        query2.setQueryPattern(pattern);
        query2.addProjectVars(Collections.singleton("s"));
        Template templ = new Template(BasicPattern.wrap(triples));
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        query2.setConstructTemplate(templ);
        for (Map.Entry<String, String> e2 : this.prefixMapping.entrySet()) {
            query2.setPrefix(e2.getKey(), e2.getValue());
        }
        return query2;
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void setBase(String base) {
    }
}

