/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.gui.verifier;

import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.gui.ErrorMessages;
import com.janus.qrinvoice.gui.FieldType;
import com.janus.qrinvoice.gui.QRInvoicePreferences;
import com.janus.qrinvoice.gui.VerificationStateCallback;
import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class NotNullVerifier
extends InputVerifier {
    protected JComponent verifiedComponent;
    protected String txt;
    protected FieldType fieldType;
    protected VerificationStateCallback callback;
    protected Color originalBackgroundColor;
    protected ErrorMessages errorMessages;

    public NotNullVerifier(JComponent jComponent, FieldType fieldType, VerificationStateCallback verificationStateCallback, ErrorMessages errorMessages) {
        this.verifiedComponent = jComponent;
        this.fieldType = fieldType;
        this.callback = verificationStateCallback;
        this.errorMessages = errorMessages;
        this.originalBackgroundColor = jComponent.getBackground();
    }

    @Override
    public boolean shouldYieldFocus(JComponent jComponent) {
        super.shouldYieldFocus(jComponent);
        return true;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        this.readValue(jComponent);
        boolean bl = StringUtils.trimToNull(this.txt) != null;
        String string = ApplicationContext.get().text().getString("pleaseFillIn");
        this.setErrorMessage(string);
        if (bl) {
            this.resetMessage();
        }
        this.callback.toggleVerificationState(this.fieldType, bl);
        return bl;
    }

    protected void setErrorMessage(String string) {
        this.verifiedComponent.setBackground(new Color(255, 186, 186));
        this.errorMessages.addErrorMessage(string, this.fieldType);
    }

    protected void setWarningMessage(String string) {
        this.verifiedComponent.setBackground(Color.orange);
        this.errorMessages.addWarningMessage(string, this.fieldType);
    }

    protected void resetMessage() {
        this.verifiedComponent.setBackground(this.originalBackgroundColor);
        this.errorMessages.removeMessages(this.fieldType);
        QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
        qRInvoicePreferences.savePreference(this.fieldType.name(), this.txt);
    }

    protected void readValue(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jComponent;
            this.txt = jTextField.getText();
        }
    }
}

