/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphAltDefaultGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.DynamicDatasets;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.graph.GraphOps;
import com.hp.hpl.jena.sparql.graph.NodeTransformLib;
import com.hp.hpl.jena.sparql.modify.NodeTransformBNodesToVariables;
import com.hp.hpl.jena.sparql.modify.TemplateLib;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateAdd;
import com.hp.hpl.jena.sparql.modify.request.UpdateBinaryOp;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateDropClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.modify.request.UpdateMove;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DefaultDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.openjena.riot.SerializationFactoryFinder;

public class UpdateEngineWorker
implements UpdateVisitor {
    protected final GraphStore graphStore;
    protected final boolean alwaysSilent = true;
    protected final Binding inputBinding;
    protected final Context context;

    public UpdateEngineWorker(GraphStore graphStore, Binding inputBinding, Context context) {
        this.graphStore = graphStore;
        this.inputBinding = inputBinding;
        this.context = context;
    }

    @Override
    public void visit(UpdateDrop update2) {
        this.execDropClear(update2, false);
    }

    @Override
    public void visit(UpdateClear update2) {
        this.execDropClear(update2, true);
    }

    protected void execDropClear(UpdateDropClear update2, boolean isClear) {
        if (update2.isAll()) {
            this.execDropClear(update2, null, true);
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isAllNamed()) {
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isDefault()) {
            this.execDropClear(update2, null, true);
        } else if (update2.isOneGraph()) {
            this.execDropClear(update2, update2.getGraph(), isClear);
        } else {
            throw new ARQInternalErrorException("Target is undefined: " + update2.getTarget());
        }
    }

    protected void execDropClear(UpdateDropClear update2, Node g, boolean isClear) {
        if (isClear) {
            if (g == null || this.graphStore.containsGraph(g)) {
                UpdateEngineWorker.graph(this.graphStore, g).clear();
            }
        } else {
            this.graphStore.removeGraph(g);
        }
    }

    protected void execDropClearAllNamed(UpdateDropClear update2, boolean isClear) {
        List<Node> list = Iter.toList(this.graphStore.listGraphNodes());
        for (Node gn : list) {
            this.execDropClear(update2, gn, isClear);
        }
    }

    @Override
    public void visit(UpdateCreate update2) {
        Node g = update2.getGraph();
        if (g == null) {
            return;
        }
        if (this.graphStore.containsGraph(g)) {
            return;
        }
        this.graphStore.addGraph(g, GraphFactory.createDefaultGraph());
    }

    @Override
    public void visit(UpdateLoad update2) {
        block7: {
            String source = update2.getSource();
            Node dest = update2.getDest();
            try {
                TypedInputStream s = RDFDataMgr.open(source);
                Lang lang = RDFDataMgr.determineLang(source, s.getContentType(), null);
                if (RDFLanguages.isTriples(lang)) {
                    Graph g = GraphFactory.createGraphMem();
                    StreamRDF stream = StreamRDFLib.graph(g);
                    RDFDataMgr.parse(stream, s, source);
                    Graph g2 = UpdateEngineWorker.graph(this.graphStore, dest);
                    GraphUtil.addInto(g2, g);
                } else {
                    if (dest != null) {
                        throw new UpdateException("Attempt to load quads into a graph");
                    }
                    DatasetGraph dsg = DatasetGraphFactory.createMem();
                    StreamRDF stream = StreamRDFLib.dataset(dsg);
                    RDFDataMgr.parse(stream, s, source);
                    Iterator<Quad> iter = dsg.find();
                    while (iter.hasNext()) {
                        Quad q = iter.next();
                        this.graphStore.add(q);
                    }
                }
            }
            catch (RuntimeException ex) {
                if (update2.getSilent()) break block7;
                if (ex instanceof UpdateException) {
                    throw (UpdateException)ex;
                }
                throw new UpdateException("Failed to LOAD '" + source + "'", ex);
            }
        }
    }

    @Override
    public void visit(UpdateAdd update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopyTriples(this.graphStore, update2.getSrc(), update2.getDest());
    }

    @Override
    public void visit(UpdateCopy update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.graphStore, update2.getSrc(), update2.getDest(), update2.getSilent());
    }

    @Override
    public void visit(UpdateMove update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.graphStore, update2.getSrc(), update2.getDest(), update2.getSilent());
        UpdateEngineWorker.gsDrop(this.graphStore, update2.getSrc(), true);
    }

    private boolean validBinaryGraphOp(UpdateBinaryOp update2) {
        if (update2.getSrc().isDefault()) {
            return true;
        }
        if (update2.getSrc().isOneNamedGraph()) {
            Node gn = update2.getSrc().getGraph();
            if (!this.graphStore.containsGraph(gn)) {
                if (!update2.getSilent()) {
                    UpdateEngineWorker.error("No such graph: " + gn);
                }
                return false;
            }
            return true;
        }
        UpdateEngineWorker.error("Invalid source target for oepration; " + update2.getSrc());
        return false;
    }

    protected static void gsCopy(GraphStore gStore, Target src, Target dest, boolean isSilent) {
        if (dest.equals(src)) {
            return;
        }
        UpdateEngineWorker.gsClear(gStore, dest, true);
        UpdateEngineWorker.gsCopyTriples(gStore, src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void gsCopyTriples(GraphStore gStore, Target src, Target dest) {
        Graph gSrc = UpdateEngineWorker.graph(gStore, src);
        Graph gDest = UpdateEngineWorker.graph(gStore, dest);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(gStore.getContext());
        DefaultDataBag<Triple> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.tripleSerializationFactory());
        try {
            ExtendedIterator<Triple> triples = gSrc.find(null, null, null);
            db.addAll(triples);
            Iter.close(triples);
            GraphOps.addAll(gDest, db.iterator());
        }
        finally {
            db.close();
        }
    }

    protected static void gsClear(GraphStore gStore, Target target, boolean isSilent) {
        Graph g = UpdateEngineWorker.graph(gStore, target);
        g.clear();
    }

    protected static void gsDrop(GraphStore gStore, Target target, boolean isSilent) {
        if (target.isDefault()) {
            gStore.getDefaultGraph().clear();
        } else {
            gStore.removeGraph(target.getGraph());
        }
    }

    @Override
    public Sink<Quad> createInsertDataSink() {
        return new Sink<Quad>(){

            @Override
            public void send(Quad quad) {
                UpdateEngineWorker.addToGraphStore(UpdateEngineWorker.this.graphStore, quad);
            }

            @Override
            public void flush() {
                SystemARQ.sync(UpdateEngineWorker.this.graphStore);
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void visit(UpdateDataInsert update2) {
        for (Quad quad : update2.getQuads()) {
            UpdateEngineWorker.addToGraphStore(this.graphStore, quad);
        }
    }

    @Override
    public Sink<Quad> createDeleteDataSink() {
        return new Sink<Quad>(){

            @Override
            public void send(Quad quad) {
                UpdateEngineWorker.deleteFromGraphStore(UpdateEngineWorker.this.graphStore, quad);
            }

            @Override
            public void flush() {
                SystemARQ.sync(UpdateEngineWorker.this.graphStore);
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void visit(UpdateDataDelete update2) {
        for (Quad quad : update2.getQuads()) {
            UpdateEngineWorker.deleteFromGraphStore(this.graphStore, quad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateDeleteWhere update2) {
        List<Quad> quads = update2.getQuads();
        Element el = this.elementFromQuads(quads);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.graphStore.getContext());
        DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());
        try {
            Iterator<Binding> bindings2 = this.evalBindings(el, null);
            db.addAll(bindings2);
            Iter.close(bindings2);
            Iterator<Binding> it = db.iterator();
            this.execDelete(quads, null, it);
            Iter.close(it);
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateModify update2) {
        Node withGraph = update2.getWithIRI();
        Query query2 = this.elementToQuery(update2.getWherePattern());
        DatasetGraph dsg = this.processUsing(update2);
        if (dsg == null && withGraph != null) {
            dsg = this.processWith(update2);
        }
        if (dsg == null) {
            dsg = this.graphStore;
        }
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.graphStore.getContext());
        DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());
        try {
            Iterator<Binding> bindings2 = UpdateEngineWorker.evalBindings(query2, dsg, this.inputBinding, this.context);
            db.addAll(bindings2);
            Iter.close(bindings2);
            Iterator<Binding> it = db.iterator();
            this.execDelete(update2.getDeleteQuads(), withGraph, it);
            Iter.close(it);
            Iterator<Binding> it2 = db.iterator();
            this.execInsert(update2.getInsertQuads(), withGraph, it2);
            Iter.close(it2);
        }
        finally {
            db.close();
        }
    }

    protected DatasetGraph processUsing(UpdateModify update2) {
        if (update2.getUsing().size() == 0 && update2.getUsingNamed().size() == 0) {
            return null;
        }
        return DynamicDatasets.dynamicDataset(update2.getUsing(), update2.getUsingNamed(), this.graphStore, false);
    }

    protected DatasetGraph processWith(UpdateModify update2) {
        Node withGraph = update2.getWithIRI();
        if (withGraph == null) {
            return null;
        }
        Graph g = this.graphOrDummy(this.graphStore, withGraph);
        DatasetGraphAltDefaultGraph dsg = new DatasetGraphAltDefaultGraph(this.graphStore, g);
        return dsg;
    }

    private Graph graphOrDummy(DatasetGraph dsg, Node gn) {
        Graph g = UpdateEngineWorker.graph(this.graphStore, gn);
        if (g == null) {
            g = GraphFactory.createGraphMem();
        }
        return g;
    }

    protected static List<Quad> unused_convertBNodesToVariables(List<Quad> quads) {
        NodeTransformBNodesToVariables bnodesToVariables = new NodeTransformBNodesToVariables();
        return NodeTransformLib.transformQuads(bnodesToVariables, quads);
    }

    protected Element elementFromQuads(List<Quad> quads) {
        ElementGroup el = new ElementGroup();
        ElementTriplesBlock x = new ElementTriplesBlock();
        el.addElement(x);
        Node g = Quad.defaultGraphNodeGenerated;
        for (Quad q : quads) {
            if (q.getGraph() != g) {
                g = q.getGraph();
                x = new ElementTriplesBlock();
                if (g == null || g == Quad.defaultGraphNodeGenerated) {
                    el.addElement(x);
                } else {
                    ElementNamedGraph eng = new ElementNamedGraph(g, x);
                    el.addElement(eng);
                }
            }
            x.addTriple(q.asTriple());
        }
        return el;
    }

    protected void execDelete(List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        Iterator<Quad> it = TemplateLib.template(quads, dftGraph, bindings2);
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Quad q = it.next();
            this.graphStore.delete(q);
        }
    }

    protected void execInsert(List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        Iterator<Quad> it = TemplateLib.template(quads, dftGraph, bindings2);
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Quad q = it.next();
            UpdateEngineWorker.addToGraphStore(this.graphStore, q);
        }
    }

    private static void addToGraphStore(GraphStore graphStore, Quad quad) {
        if (quad.isLegalAsData()) {
            graphStore.add(quad);
        }
    }

    private static void deleteFromGraphStore(GraphStore graphStore, Quad quad) {
        graphStore.delete(quad);
    }

    protected Query elementToQuery(Element pattern) {
        if (pattern == null) {
            return null;
        }
        Query query2 = new Query();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        query2.setResultVars();
        return query2;
    }

    protected Iterator<Binding> evalBindings(Element pattern, Node dftGraph) {
        return this.evalBindings(this.elementToQuery(pattern), dftGraph);
    }

    protected Iterator<Binding> evalBindings(Query query2, Node dftGraph) {
        DatasetGraph dsg = this.graphStore;
        if (query2 != null && dftGraph != null) {
            Graph g = this.graphOrDummy(dsg, dftGraph);
            dsg = new DatasetGraphAltDefaultGraph(dsg, g);
        }
        return UpdateEngineWorker.evalBindings(query2, dsg, this.inputBinding, this.context);
    }

    protected static Iterator<Binding> evalBindings(Query query2, DatasetGraph dsg, Binding inputBinding, Context context) {
        QueryIterator toReturn;
        if (query2 != null) {
            Plan plan = QueryExecutionFactory.createPlan(query2, dsg, inputBinding, context);
            toReturn = plan.iterator();
        } else {
            toReturn = Iter.singleton(null != inputBinding ? inputBinding : BindingRoot.create());
        }
        return toReturn;
    }

    protected static Graph graph(GraphStore graphStore, Node gn) {
        if (gn == null || gn == Quad.defaultGraphNodeGenerated) {
            return graphStore.getDefaultGraph();
        }
        return graphStore.getGraph(gn);
    }

    protected static Graph graph(GraphStore graphStore, Target target) {
        if (target.isDefault()) {
            return graphStore.getDefaultGraph();
        }
        if (target.isOneNamedGraph()) {
            return UpdateEngineWorker.graph(graphStore, target.getGraph());
        }
        UpdateEngineWorker.error("Target does not name one graph: " + target);
        return null;
    }

    protected static void error(String msg) {
        throw new UpdateException(msg);
    }
}

