/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.net.URI;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.odftoolkit.simple.text.AbstractTextHyperlinkContainer;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.TextHyperlink;
import org.odftoolkit.simple.text.TextHyperlinkContainer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Span
extends Component
implements TextHyperlinkContainer {
    private TextSpanElement mSpanElement;
    private Document mOwnerDocument;
    private DefaultStyleHandler mStyleHandler;
    private TextHyperlinkContainerImpl mHyperlinkContainerImpl;

    private Span(TextSpanElement element) {
        this.mSpanElement = element;
        this.mOwnerDocument = (Document)((OdfFileDom)element.getOwnerDocument()).getDocument();
        this.mStyleHandler = new DefaultStyleHandler(element);
    }

    public static Span getInstanceof(TextSpanElement sElement) {
        if (sElement == null) {
            return null;
        }
        Span span = null;
        span = (Span)Component.getComponentByElement(sElement);
        if (span != null) {
            return span;
        }
        span = new Span(sElement);
        Component.registerComponent(span, sElement);
        return span;
    }

    public static Span newSpan(TextSelection textSelection) {
        try {
            TextSpanElement element = textSelection.createSpanElement();
            return Span.getInstanceof(element);
        }
        catch (InvalidNavigationException e2) {
            Logger.getLogger(Span.class.getName()).log(Level.SEVERE, e2.getMessage(), e2);
            return null;
        }
    }

    public DefaultStyleHandler getStyleHandler() {
        if (this.mStyleHandler != null) {
            return this.mStyleHandler;
        }
        this.mStyleHandler = new DefaultStyleHandler(this.mSpanElement);
        return this.mStyleHandler;
    }

    @Override
    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    @Override
    public TextSpanElement getOdfElement() {
        return this.mSpanElement;
    }

    public void removeTextContent() {
        Paragraph.removeTextContentImpl(this.getOdfElement());
        NodeList nodeList = this.getOdfElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodename;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(nodename = node.getNodeName()).equals("text:a") || node.hasChildNodes()) continue;
            this.getOdfElement().removeChild(node);
        }
    }

    public void setTextContent(String content) {
        Paragraph.removeTextContentImpl(this.getOdfElement());
        Node lastNode = this.getOdfElement().getLastChild();
        if (content != null && !content.equals("")) {
            if (lastNode != null && lastNode.getNodeName() != null && lastNode.getNodeName().equals("text:a")) {
                Paragraph.appendTextElements((TextAElement)lastNode, content, true);
            } else {
                Paragraph.appendTextElements(this.getOdfElement(), content, true);
            }
        }
        Paragraph.removeEmptyHyperlink(this.getOdfElement());
    }

    public String getTextContent() {
        return Paragraph.getTextContent(this.getOdfElement());
    }

    public void appendTextContent(String content) {
        this.appendTextContent(content, true);
    }

    public void appendTextContent(String content, boolean isStyleInherited) {
        boolean canInherited = false;
        Node lastNode = this.getOdfElement().getLastChild();
        if (lastNode != null && lastNode.getNodeName() != null && lastNode.getNodeName().equals("text:a")) {
            canInherited = true;
        }
        if (isStyleInherited && canInherited) {
            if (content != null && !content.equals("")) {
                Paragraph.appendTextElements((OdfElement)lastNode, content, true);
            }
        } else if (content != null && !content.equals("")) {
            Paragraph.appendTextElements(this.getOdfElement(), content, true);
        }
    }

    @Override
    public TextHyperlink applyHyperlink(URI linkto) {
        return this.getTextHyperlinkContainerImpl().applyHyperlink(linkto);
    }

    @Override
    public Iterator<TextHyperlink> getHyperlinkIterator() {
        return this.getTextHyperlinkContainerImpl().getHyperlinkIterator();
    }

    @Override
    public void removeHyperlinks() {
        this.getTextHyperlinkContainerImpl().removeHyperlinks();
    }

    @Override
    public TextHyperlink appendHyperlink(String text, URI linkto) {
        return this.getTextHyperlinkContainerImpl().appendHyperlink(text, linkto);
    }

    private TextHyperlinkContainerImpl getTextHyperlinkContainerImpl() {
        if (this.mHyperlinkContainerImpl == null) {
            this.mHyperlinkContainerImpl = new TextHyperlinkContainerImpl(this.getOdfElement());
        }
        return this.mHyperlinkContainerImpl;
    }

    private class TextHyperlinkContainerImpl
    extends AbstractTextHyperlinkContainer {
        public TextHyperlinkContainerImpl(OdfElement parent) {
            super(parent);
        }
    }
}

