/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.parser.excel;

import com.janus.qrinvoice.QRInvoiceDTO;
import com.janus.qrinvoice.QRInvoiceLine;
import com.janus.qrinvoice.gui.QRInvoiceParser;
import com.janus.qrinvoice.parser.ColumnReaderCommand;
import com.janus.qrinvoice.parser.NoObject;
import com.janus.qrinvoice.parser.ParserLineResult;
import com.janus.qrinvoice.parser.ParserResult;
import com.janus.qrinvoice.parser.ParserUtils;
import com.janus.qrinvoice.parser.ValidationException;
import com.janus.qrinvoice.parser.excel.ColumnReaderCommandFactory;
import com.janus.qrinvoice.validator.QRInvoiceValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;

public class ExcelParser
implements QRInvoiceParser {
    private final Logger logger = Logger.getLogger(ExcelParser.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserResult parse(File file, boolean bl) {
        ParserResult parserResult = new ParserResult();
        QRInvoiceDTO qRInvoiceDTO = new QRInvoiceDTO();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Workbook workbook = WorkbookFactory.create(fileInputStream);
            List<QRInvoiceLine> list = this.readDirectDebitTransactions(workbook.getSheetAt(0), parserResult, bl);
            qRInvoiceDTO.addAll(list);
            parserResult.setQrinvoice(qRInvoiceDTO);
            parserResult.setHeaderSuccessfull(true);
        }
        catch (InvalidFormatException invalidFormatException) {
            this.logger.log(Level.WARNING, "Exception while opening Excel file \"" + file.getAbsolutePath() + "\"", invalidFormatException);
            parserResult.setHeaderSuccessfull(false);
            parserResult.setHeaderMessage(invalidFormatException.getMessage());
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Exception while opening Excel file \"" + file.getAbsolutePath() + "\"", exception);
            parserResult.setHeaderSuccessfull(false);
            parserResult.setHeaderMessage(exception.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, "Fehler beim \u00d6ffnen der Excel-Datei \"" + file.getAbsolutePath() + "\"", iOException);
                }
            }
        }
        return parserResult;
    }

    protected List<QRInvoiceLine> readDirectDebitTransactions(Sheet sheet, ParserResult parserResult, boolean bl) {
        ArrayList<QRInvoiceLine> arrayList = new ArrayList<QRInvoiceLine>();
        QRInvoiceLine qRInvoiceLine = null;
        int n = sheet.getLastRowNum();
        int n2 = this.determineStartingRow(sheet.getRow(0));
        parserResult.setStartingRow(n2);
        for (int i = n2; i <= n; ++i) {
            Row row = sheet.getRow(i);
            List<Field> list = Arrays.asList(QRInvoiceLine.class.getDeclaredFields());
            qRInvoiceLine = new QRInvoiceLine();
            ParserLineResult parserLineResult = new ParserLineResult();
            for (Field field : list) {
                ColumnReaderCommand columnReaderCommand = ColumnReaderCommandFactory.create(field, row);
                try {
                    Object object = columnReaderCommand.getValueFromColumnOrColumns();
                    if (NoObject.class == object.getClass()) continue;
                    field.setAccessible(true);
                    field.set(qRInvoiceLine, object);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.log(Level.WARNING, "Cannot read value.", instantiationException);
                    qRInvoiceLine = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.log(Level.WARNING, "Cannot set value into field.", illegalAccessException);
                    qRInvoiceLine = null;
                }
            }
            try {
                QRInvoiceValidator.validateKontoinhaber(qRInvoiceLine.getKontoinhaber());
                QRInvoiceValidator.validateText(qRInvoiceLine.getStrasseHausNr());
                QRInvoiceValidator.validateText(qRInvoiceLine.getPlzOrt());
                if (qRInvoiceLine.getAmount() != null) {
                    QRInvoiceValidator.validateAmount(qRInvoiceLine.getAmount());
                }
                if (qRInvoiceLine.getReferenz() != null || bl) {
                    QRInvoiceValidator.validateReferenz(qRInvoiceLine.getReferenz(), bl);
                }
                if (qRInvoiceLine.getZusaetzlicheInformation() != null) {
                    QRInvoiceValidator.validateText(qRInvoiceLine.getZusaetzlicheInformation());
                }
                if (qRInvoiceLine.getStrukturierteRechnungsInformation() != null) {
                    QRInvoiceValidator.validateStrcuturedBillInformation(qRInvoiceLine.getStrukturierteRechnungsInformation());
                }
                parserLineResult.setSucessfull(true);
                parserLineResult.setLineMessage(qRInvoiceLine.getKontoinhaber() + ", " + qRInvoiceLine.getStrasseHausNr() + ", " + qRInvoiceLine.getPlzOrt() + (qRInvoiceLine.getAmount() != null ? ", " + qRInvoiceLine.getAmount() : "") + (qRInvoiceLine.getReferenz() != null ? ", " + qRInvoiceLine.getReferenz() : "") + (qRInvoiceLine.getZusaetzlicheInformation() != null ? ", " + qRInvoiceLine.getZusaetzlicheInformation() : "") + (qRInvoiceLine.getStrukturierteRechnungsInformation() != null ? ", " + qRInvoiceLine.getStrukturierteRechnungsInformation() : ""));
            }
            catch (ValidationException validationException) {
                parserLineResult.setSucessfull(false);
                parserLineResult.setLineMessage(validationException.getMessage() + (validationException.getNotValidatingValue() != null ? " (" + validationException.getNotValidatingValue() + ")" : ""));
                qRInvoiceLine = null;
                this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), validationException);
            }
            if (qRInvoiceLine != null) {
                arrayList.add(qRInvoiceLine);
                parserResult.setSuccessfull(parserResult.getSuccessfull() + 1);
            } else {
                parserResult.setNotSuccessfull(parserResult.getNotSuccessfull() + 1);
            }
            parserResult.getLineResults().add(parserLineResult);
        }
        return arrayList;
    }

    private int determineStartingRow(Row row) {
        int n = 0;
        try {
            Cell cell = row.getCell(new CellReference("A").getCol());
            if (cell.getCellType() == 1) {
                String string = cell.getStringCellValue();
                if (ParserUtils.isExample(string)) {
                    this.logger.log(Level.INFO, "This is the template with header and example: Start reading from line 2...");
                    n = 2;
                } else if (ParserUtils.isHeader(string)) {
                    this.logger.log(Level.INFO, "This is the template with header: Start reading from line 1...");
                    n = 1;
                } else {
                    this.logger.log(Level.INFO, "This is not the template: Start reading from line 0...");
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Cannot read value.", exception);
        }
        return n;
    }
}

