/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice;

import com.janus.qrinvoice.QRInvoiceDTO;
import com.janus.qrinvoice.QRInvoiceLine;
import com.janus.qrinvoice.gui.QRInvoicePreferences;
import com.janus.qrinvoice.validator.QRValidator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import net.codecrete.qrbill.canvas.PDFCanvas;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.BillFormat;
import net.codecrete.qrbill.generator.GraphicsFormat;
import net.codecrete.qrbill.generator.Language;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.QRBill;
import net.codecrete.qrbill.generator.SeparatorType;
import org.apache.pdfbox.multipdf.PDFMergerUtility;

public class QRInvoiceWriter {
    private static final String COUNTRY_CODE = "COUNTRY_CODE";
    private static final String COUNTRY_CODE_CH = "CH";
    private static final String CURRENCY = "CURRENCY";
    private static final String CURRENCY_CHF = "CHF";
    private static final String INVOICENAMETEMPLATESUFFIX = "INVOICENAMETEMPLATESUFFIX";
    private static final String INVOICENAMETEMPLATESUFFIX_PDF = ".pdf";
    private static final String INVOICENAMETEMPLATE_DE = "INVOICENAMETEMPLATE_DE";
    private static final String INVOICENAMETEMPLATE_DE_RECHNUNG = "Rechnung";
    private static final String INVOICENAMETEMPLATE_FR = "INVOICENAMETEMPLATE_FR";
    private static final String INVOICENAMETEMPLATE_FR_FACTURE = "Facture";
    private static final String INVOICENAMETEMPLATE_IT = "INVOICENAMETEMPLATE_IT";
    private static final String INVOICENAMETEMPLATE_IT_FATTURE = "Fatture";
    private static final String INVOICENAMETEMPLATE_EN = "INVOICENAMETEMPLATE_EN";
    private static final String INVOICENAMETEMPLATE_EN_INVOICE = "Invoice";
    private static final String INVOICENAMETEMPLATE_SEPARATOR = "INVOICENAMETEMPLATE_SEPARATOR";
    private static final String INVOICENAMETEMPLATE_SEPARATOR_UNDERSCORE = "_";

    public void createQRInvoices(QRInvoiceDTO qRInvoiceDTO, Path path, Path path2, boolean bl, boolean bl2, SeparatorType separatorType, OutputSize outputSize) throws IOException {
        Language language;
        String string;
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
        if ("de".equals(string2)) {
            string = qRInvoicePreferences.loadPreference(INVOICENAMETEMPLATE_DE, INVOICENAMETEMPLATE_DE_RECHNUNG);
            language = Language.DE;
        } else if ("fr".equals(string2)) {
            string = qRInvoicePreferences.loadPreference(INVOICENAMETEMPLATE_FR, INVOICENAMETEMPLATE_FR_FACTURE);
            language = Language.FR;
        } else if ("it".equals(string2)) {
            string = qRInvoicePreferences.loadPreference(INVOICENAMETEMPLATE_IT, INVOICENAMETEMPLATE_IT_FATTURE);
            language = Language.IT;
        } else {
            string = qRInvoicePreferences.loadPreference(INVOICENAMETEMPLATE_EN, INVOICENAMETEMPLATE_EN_INVOICE);
            language = Language.EN;
        }
        int n = 0;
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (QRInvoiceLine iterator : qRInvoiceDTO.getLines()) {
            Path path3;
            Bill bill = new Bill();
            bill.setAccount(qRInvoiceDTO.getIBAN());
            bill.setAmount(iterator.getAmount());
            bill.setCurrency(qRInvoicePreferences.loadPreference(CURRENCY, CURRENCY_CHF));
            Address address = new Address();
            address.setName(qRInvoiceDTO.getKontoinhaber());
            address.setAddressLine1(qRInvoiceDTO.getStrasseHausNr());
            address.setAddressLine2(qRInvoiceDTO.getPlzOrt());
            address.setCountryCode(qRInvoicePreferences.loadPreference(COUNTRY_CODE, COUNTRY_CODE_CH));
            bill.setCreditor(address);
            if (iterator.getReferenz() != null) {
                if (QRValidator.validateQRIBAN(qRInvoiceDTO.getIBAN().replace(" ", ""))) {
                    bill.setReference(iterator.getReferenz().replace(" ", ""));
                } else {
                    bill.setReference(iterator.getReferenz().replace(" ", ""));
                }
            }
            bill.setUnstructuredMessage(iterator.getZusaetzlicheInformation());
            bill.setBillInformation(iterator.getStrukturierteRechnungsInformation());
            Address address2 = new Address();
            address2.setName(iterator.getKontoinhaber());
            address2.setAddressLine1(iterator.getStrasseHausNr());
            address2.setAddressLine2(iterator.getPlzOrt());
            address2.setCountryCode(COUNTRY_CODE_CH);
            bill.setDebtor(address2);
            BillFormat billFormat = bill.getFormat();
            billFormat.setLanguage(language);
            String string3 = qRInvoicePreferences.loadPreference(INVOICENAMETEMPLATESUFFIX, INVOICENAMETEMPLATESUFFIX_PDF);
            String string4 = qRInvoicePreferences.loadPreference(INVOICENAMETEMPLATE_SEPARATOR, INVOICENAMETEMPLATE_SEPARATOR_UNDERSCORE);
            if (path2 != null) {
                billFormat.setOutputSize(outputSize);
                billFormat.setSeparatorType(separatorType);
                int n2 = bl ? -2 : -1;
                PDFCanvas pDFCanvas = new PDFCanvas(path2, n2);
                QRBill.draw(bill, pDFCanvas);
                if (bl2) {
                    path3 = Paths.get(new File(path.toString()).getParent(), string + string4 + n + string3);
                    arrayList.add(path3);
                } else {
                    path3 = Paths.get(path.toString(), string + string4 + n + string3);
                }
                pDFCanvas.saveAs(path3);
            } else {
                billFormat.setGraphicsFormat(GraphicsFormat.PDF);
                billFormat.setOutputSize(outputSize);
                billFormat.setSeparatorType(separatorType);
                byte[] byArray = QRBill.generate(bill);
                if (bl2) {
                    path3 = Paths.get(new File(path.toString()).getParent(), string + string4 + n + string3);
                    arrayList.add(path3);
                } else {
                    path3 = Paths.get(path.toString(), string + string4 + n + string3);
                }
                try {
                    Files.write(path3, byArray, new OpenOption[0]);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            ++n;
        }
        if (bl2) {
            PDFMergerUtility pDFMergerUtility = new PDFMergerUtility();
            pDFMergerUtility.setDestinationFileName(path.toString());
            for (Path path4 : arrayList) {
                pDFMergerUtility.addSource(path4.toFile());
            }
            pDFMergerUtility.mergeDocuments(null);
            for (Path path5 : arrayList) {
                path5.toFile().delete();
            }
        }
    }
}

