/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.ValidationMessage;

public class ValidationResult
implements Serializable {
    private static final long serialVersionUID = -791181851684443602L;
    private static final List<ValidationMessage> EMPTY_LIST = Collections.emptyList();
    private List<ValidationMessage> validationMessages;
    private Bill cleanedBill;
    private static final Map<String, String> ERROR_MESSAGES;

    public List<ValidationMessage> getValidationMessages() {
        if (this.validationMessages == null) {
            return EMPTY_LIST;
        }
        return this.validationMessages;
    }

    public boolean hasMessages() {
        return this.validationMessages != null;
    }

    public boolean hasWarnings() {
        if (this.validationMessages == null) {
            return false;
        }
        for (ValidationMessage message : this.validationMessages) {
            if (message.getType() != ValidationMessage.Type.WARNING) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        if (this.validationMessages == null) {
            return false;
        }
        for (ValidationMessage message : this.validationMessages) {
            if (message.getType() != ValidationMessage.Type.ERROR) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public void addMessage(ValidationMessage.Type type, String field, String messageKey) {
        ValidationMessage message = new ValidationMessage(type, field, messageKey);
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList<ValidationMessage>();
        }
        this.validationMessages.add(message);
    }

    public void addMessage(ValidationMessage.Type type, String field, String messageKey, String[] messageParameters) {
        ValidationMessage message = new ValidationMessage(type, field, messageKey, messageParameters);
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList<ValidationMessage>();
        }
        this.validationMessages.add(message);
    }

    public Bill getCleanedBill() {
        return this.cleanedBill;
    }

    public void setCleanedBill(Bill cleanedBill) {
        this.cleanedBill = cleanedBill;
    }

    public String getDescription() {
        if (!this.hasErrors()) {
            return "Valid bill data";
        }
        StringBuilder sb = new StringBuilder();
        for (ValidationMessage message : this.getValidationMessages()) {
            if (message.getType() != ValidationMessage.Type.ERROR) continue;
            if (sb.length() > 0) {
                sb.append("; ");
            }
            String desc = ERROR_MESSAGES.getOrDefault(message.getMessageKey(), "Unknown error");
            if (message.getMessageKey().equals("field_is_mandatory")) {
                desc = String.format(desc, message.getField());
            } else if (message.getMessageKey().equals("field_value_too_long")) {
                desc = String.format(desc, message.getField(), message.getMessageParameters()[0]);
            }
            sb.append(desc);
            sb.append(" (");
            sb.append(message.getMessageKey());
            sb.append(")");
        }
        return sb.toString();
    }

    static {
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        errorMessages.put("currency_is_chf_or_eur", "currency should be \"CHF\" or \"EUR\"");
        errorMessages.put("amount_in_valid_range", "amount should be between 0.01 and 999 999 999.99");
        errorMessages.put("account_is_ch_li_iban", "account number should start with \"CH\" or \"LI\"");
        errorMessages.put("account_is_valid_iban", "IBAN is invalid (format or checksum)");
        errorMessages.put("valid_iso11649_creditor_ref", "reference is invalid (reference should be empty or start with \"RF\")");
        errorMessages.put("valid_qr_ref_no", "reference is invalid (numeric QR reference required)");
        errorMessages.put("mandatory_for_qr_iban", "reference is needed for a payment to this account (QR-IBAN)");
        errorMessages.put("field_is_mandatory", "field \"%s\" may not be empty");
        errorMessages.put("valid_country_code", "country code is invalid; it should consist of two letters");
        errorMessages.put("address_type_conflict", "fields for either structured address or combined elements address may be filled but not both");
        errorMessages.put("alt_scheme_max_exceed", "no more than two alternative schemes may be used");
        errorMessages.put("bill_info_invalid", "structured bill information must start with \"//\"");
        errorMessages.put("field_value_too_long", "the value for field \"%s\" should not exceed a length of %s characters");
        errorMessages.put("additional_info_too_long", "the additional information and the structured bill information combined should not exceed 140 characters");
        ERROR_MESSAGES = Collections.unmodifiableMap(errorMessages);
    }
}

