/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.parser.excel;

import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.parser.ColumnReaderCommand;
import com.janus.qrinvoice.parser.NoObject;
import com.janus.qrinvoice.parser.excel.ExcelColumn;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;

public class SingleColumnReaderCommand
implements ColumnReaderCommand {
    private final Logger logger = Logger.getLogger(SingleColumnReaderCommand.class.getName());
    private final ExcelColumn columnInfo;
    private final Row row;

    public SingleColumnReaderCommand(ExcelColumn excelColumn, Row row) {
        this.columnInfo = excelColumn;
        this.row = row;
    }

    @Override
    public Object getValueFromColumnOrColumns() throws InstantiationException, IllegalAccessException {
        CellReference cellReference;
        Cell cell;
        Object object = new NoObject();
        if (this.row != null && (cell = this.row.getCell((int)(cellReference = new CellReference(this.columnInfo.name())).getCol())) != null) {
            if (cell.getCellType() == this.columnInfo.cellType()) {
                if (this.columnInfo.needsMapping()) {
                    int n = cell.getCellType();
                    switch (n) {
                        case 0: {
                            if (!DateUtil.isCellDateFormatted((Cell)cell)) break;
                            double d = cell.getNumericCellValue();
                            object = this.columnInfo.mapper().newInstance().map("" + d);
                            break;
                        }
                        case 1: {
                            object = this.columnInfo.mapper().newInstance().map(cell.getStringCellValue());
                        }
                    }
                } else {
                    switch (this.columnInfo.cellTypeToJavaType()) {
                        case 0: {
                            object = (long)cell.getNumericCellValue();
                            break;
                        }
                        case 2: {
                            object = (int)cell.getNumericCellValue();
                            break;
                        }
                        case 5: {
                            object = BigDecimal.valueOf(cell.getNumericCellValue()).setScale(2, 4);
                            break;
                        }
                        case 1: {
                            object = cell.getStringCellValue();
                            break;
                        }
                        default: {
                            object = "";
                            break;
                        }
                    }
                }
            } else {
                switch (this.columnInfo.cellType()) {
                    case 0: {
                        try {
                            switch (this.columnInfo.cellTypeToJavaType()) {
                                case 0: {
                                    object = Long.valueOf(cell.getStringCellValue());
                                }
                                case 2: {
                                    object = Integer.valueOf(cell.getStringCellValue());
                                }
                                case 5: {
                                    object = new BigDecimal(cell.getStringCellValue()).setScale(2, 4);
                                }
                                case 1: {
                                    String string = new String(cell.getStringCellValue());
                                    object = new GregorianCalendar();
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
                                    try {
                                        Date date = simpleDateFormat.parse(string.replaceAll(" ", ""));
                                        ((GregorianCalendar)object).setTime(date);
                                        break;
                                    }
                                    catch (ParseException parseException) {
                                        this.logger.log(Level.WARNING, "Could not read String value and convert to Date.", parseException);
                                        object = new NoObject();
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.WARNING, "Could not read Numeric value and convert to String.", exception);
                        }
                        break;
                    }
                    case 1: {
                        try {
                            object = String.format("%.0f", cell.getNumericCellValue());
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.WARNING, "Could not read Numeric value and convert to String.", exception);
                            object = String.valueOf(cell.getStringCellValue());
                        }
                        break;
                    }
                    default: {
                        object = new NoObject();
                    }
                }
            }
        }
        if (object.getClass() != NoObject.class && this.columnInfo.whitespacesAction() == ExcelColumn.WhiteSpacesActionEnum.DELETE_ALL) {
            object = ((String)object).replace(" ", "");
        }
        return object;
    }
}

