/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.parser.csv;

import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.parser.ParserUtils;
import com.janus.qrinvoice.parser.ValidationException;
import com.janus.qrinvoice.validator.QRInvoiceValidator;
import java.math.BigDecimal;
import java.text.MessageFormat;

public class CSVQRInvoiceValidator
extends QRInvoiceValidator {
    public static void validateCSVLine(String string, String string2, boolean bl) throws ValidationException {
        int n = 3;
        if (bl) {
            n = 5;
        }
        if (string == null || string.isEmpty() || string.replaceAll(" ", "").isEmpty()) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.row.empty"), (Object)null);
        }
        string = string.replaceAll(" ", "");
        string = string.replaceAll("\"", "");
        String[] stringArray = (string = string.replaceAll("'", "")).split(string2);
        if (stringArray.length < n) {
            throw new ValidationException(MessageFormat.format(ApplicationContext.get().text().getString("validation.columnNo"), stringArray.length, n), (Object)null);
        }
        CSVQRInvoiceValidator.validateKontoinhaber(ParserUtils.removeBOM(stringArray[0]));
        CSVQRInvoiceValidator.validateText(stringArray[1]);
        CSVQRInvoiceValidator.validateText(stringArray[2]);
        if (stringArray.length > 3) {
            CSVQRInvoiceValidator.validateAmount(new BigDecimal(stringArray[3]));
        }
        if (stringArray.length > 4) {
            QRInvoiceValidator.validateReferenz(stringArray[4], bl);
        }
        if (stringArray.length > 5) {
            CSVQRInvoiceValidator.validateText(stringArray[5]);
        }
        if (stringArray.length > 6) {
            CSVQRInvoiceValidator.validateStrcuturedBillInformation(stringArray[6]);
        }
    }
}

