/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.awt.Rectangle;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeFormsElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleSectionPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexBodyElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexEntryLinkStartElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexEntryTabStopElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexSourceStylesElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexTitleElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexTitleTemplateElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.dom.element.text.TextSequenceDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableOfContentElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableOfContentEntryTemplateElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableOfContentSourceElement;
import org.odftoolkit.odfdom.dom.element.text.TextTocMarkElement;
import org.odftoolkit.odfdom.dom.element.text.TextTocMarkStartElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.type.CellRangeAddressList;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.chart.AbstractChartContainer;
import org.odftoolkit.simple.chart.Chart;
import org.odftoolkit.simple.chart.ChartContainer;
import org.odftoolkit.simple.chart.DataSet;
import org.odftoolkit.simple.common.field.AbstractVariableContainer;
import org.odftoolkit.simple.common.field.VariableContainer;
import org.odftoolkit.simple.common.field.VariableField;
import org.odftoolkit.simple.draw.Control;
import org.odftoolkit.simple.draw.ControlContainer;
import org.odftoolkit.simple.form.AbstractFormContainer;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormContainer;
import org.odftoolkit.simple.style.MasterPage;
import org.odftoolkit.simple.style.TOCStyle;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.odftoolkit.simple.text.Footer;
import org.odftoolkit.simple.text.Header;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.odftoolkit.simple.text.Section;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocument
extends Document
implements ListContainer,
ParagraphContainer,
VariableContainer,
ChartContainer,
FormContainer,
ControlContainer {
    private static final String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    static final OdfPackageDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfTextDocument.odt");
    private ListContainerImpl listContainerImpl;
    private ParagraphContainerImpl paragraphContainerImpl;
    private VariableContainerImpl variableContainerImpl;
    private ChartContainerImpl chartContainerImpl;
    private FormContainerImpl formContainerImpl = null;
    private Header firstPageHeader;
    private Header standardHeader;
    private Footer firstPageFooter;
    private Footer standardFooter;

    public static TextDocument newTextDocument() throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT);
    }

    public static TextDocument newTextDocument(OdfMediaType mimeType) throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT);
    }

    public static TextDocument newTextTemplateDocument() throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_TEMPLATE);
    }

    public static TextDocument newTextMasterDocument() throws Exception {
        TextDocument doc = (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_MASTER);
        doc.changeMode(OdfMediaType.TEXT_MASTER);
        return doc;
    }

    public static TextDocument newTextWebDocument() throws Exception {
        TextDocument doc = (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_WEB);
        doc.changeMode(OdfMediaType.TEXT_WEB);
        return doc;
    }

    public static TextDocument loadDocument(InputStream inputStream) throws Exception {
        return (TextDocument)Document.loadDocument(inputStream);
    }

    public static TextDocument loadDocument(String documentPath) throws Exception {
        return (TextDocument)Document.loadDocument(documentPath);
    }

    public static TextDocument loadDocument(File file) throws Exception {
        return (TextDocument)Document.loadDocument(file);
    }

    protected TextDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public OfficeTextElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeTextElement.class);
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)n : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public Section appendSection(Section section, boolean isResourceCopied) {
        boolean isForeignNode = false;
        try {
            if (section.getOdfElement().getOwnerDocument() != this.getContentDom()) {
                isForeignNode = true;
            }
            TextSectionElement oldSectionEle = section.getOdfElement();
            TextSectionElement newSectionEle = (TextSectionElement)oldSectionEle.cloneNode(true);
            if (isResourceCopied || isForeignNode) {
                this.copyLinkedRefInBatch((OdfElement)newSectionEle, section.getOwnerDocument());
            }
            if (isForeignNode) {
                this.copyForeignStyleRef((OdfElement)newSectionEle, section.getOwnerDocument());
            }
            if (isForeignNode) {
                newSectionEle = (TextSectionElement)this.cloneForeignElement((Node)newSectionEle, (OdfFileDom)this.getContentDom(), true);
            }
            this.updateNames((OdfElement)newSectionEle);
            this.updateXMLIds((OdfElement)newSectionEle);
            OfficeTextElement contentRoot = this.getContentRoot();
            contentRoot.appendChild((Node)newSectionEle);
            return Section.getInstance(newSectionEle);
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public Section appendSection(String name) {
        TextSectionElement newSectionEle = null;
        try {
            OdfContentDom contentDocument = this.getContentDom();
            OdfOfficeAutomaticStyles styles = contentDocument.getAutomaticStyles();
            OdfStyle style = styles.newStyle(OdfStyleFamily.Section);
            StyleSectionPropertiesElement sProperties = style.newStyleSectionPropertiesElement();
            sProperties.setTextDontBalanceTextColumnsAttribute(Boolean.valueOf(false));
            sProperties.setStyleEditableAttribute(Boolean.valueOf(false));
            StyleColumnsElement columnEle = sProperties.newStyleColumnsElement(1);
            columnEle.setFoColumnGapAttribute("0in");
            newSectionEle = this.getContentRoot().newTextSectionElement("true", name);
            newSectionEle.setStyleName(style.getStyleNameAttribute());
            return Section.getInstance(newSectionEle);
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(name + "Section appends failed.", e);
        }
    }

    public Header getHeader() {
        return this.getHeader(false);
    }

    public Header getHeader(boolean isFirstPage) {
        Header tmpHeader;
        Header header = tmpHeader = isFirstPage ? this.firstPageHeader : this.standardHeader;
        if (tmpHeader == null) {
            try {
                StyleMasterPageElement masterPageElement = this.getMasterPage(isFirstPage);
                StyleHeaderElement headerElement = (StyleHeaderElement)OdfElement.findFirstChildNode(StyleHeaderElement.class, (Node)masterPageElement);
                if (headerElement == null) {
                    headerElement = masterPageElement.newStyleHeaderElement();
                }
                tmpHeader = new Header(headerElement);
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            if (isFirstPage) {
                this.firstPageHeader = tmpHeader;
            } else {
                this.standardHeader = tmpHeader;
            }
        }
        return tmpHeader;
    }

    public Footer getFooter() {
        return this.getFooter(false);
    }

    public Footer getFooter(boolean isFirstPage) {
        Footer tmpFooter;
        Footer footer = tmpFooter = isFirstPage ? this.firstPageFooter : this.standardFooter;
        if (tmpFooter == null) {
            try {
                StyleMasterPageElement masterPageElement = this.getMasterPage(isFirstPage);
                StyleFooterElement footerElement = (StyleFooterElement)OdfElement.findFirstChildNode(StyleFooterElement.class, (Node)masterPageElement);
                if (footerElement == null) {
                    footerElement = masterPageElement.newStyleFooterElement();
                }
                tmpFooter = new Footer(footerElement);
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            if (isFirstPage) {
                this.firstPageFooter = tmpFooter;
            } else {
                this.standardFooter = tmpFooter;
            }
        }
        return tmpFooter;
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.getListContainerImpl().removeList(list);
    }

    public void addPageBreak() {
        this.addPageOrColumnBreak(null, "page");
    }

    public void addPageBreak(Paragraph refParagraph) {
        this.addPageOrColumnBreak(refParagraph, "page");
    }

    public void setPageColumns(int columnsNumber, double spacing) {
        String vSpacingColumn = (new DecimalFormat("#0.###").format(spacing) + Length.Unit.CENTIMETER.abbr()).replace(",", ".");
        try {
            String stylePageLayoutName = null;
            int pageLayoutNameCount = 0;
            NodeList list = this.getStylesDom().getElementsByTagName("office:master-styles");
            if (list.getLength() > 0) {
                StyleMasterPageElement syleMasterPage;
                int i;
                OdfOfficeMasterStyles officeMasterStyles = (OdfOfficeMasterStyles)list.item(0);
                for (i = 0; i < officeMasterStyles.getLength(); ++i) {
                    syleMasterPage = (StyleMasterPageElement)officeMasterStyles.item(i);
                    if (!syleMasterPage.getStyleNameAttribute().equals("Standard")) continue;
                    stylePageLayoutName = syleMasterPage.getStylePageLayoutNameAttribute();
                    break;
                }
                for (i = 0; i < officeMasterStyles.getLength(); ++i) {
                    syleMasterPage = (StyleMasterPageElement)officeMasterStyles.item(i);
                    if (!syleMasterPage.getStylePageLayoutNameAttribute().equals(stylePageLayoutName)) continue;
                    ++pageLayoutNameCount;
                }
            }
            OdfOfficeAutomaticStyles autoStyles = this.getStylesDom().getAutomaticStyles();
            int autoStylesCount = autoStyles.getLength();
            OdfStylePageLayout pageLayout = autoStyles.getPageLayout(stylePageLayoutName);
            if (pageLayout != null) {
                if (pageLayoutNameCount > 1) {
                    Node pageLayoutNew = pageLayout.cloneNode(true);
                    String oldPageLayoutName = pageLayout.getStyleNameAttribute();
                    pageLayout.setStyleNameAttribute("Mpm" + (autoStylesCount + 1));
                    if (list.getLength() > 0) {
                        OdfOfficeMasterStyles masterpage = (OdfOfficeMasterStyles)list.item(0);
                        for (int i = 0; i < masterpage.getLength(); ++i) {
                            StyleMasterPageElement vSyleMasterPage = (StyleMasterPageElement)masterpage.item(i);
                            if (!vSyleMasterPage.getStyleNameAttribute().equals("Standard") || !vSyleMasterPage.getStylePageLayoutNameAttribute().equals(oldPageLayoutName)) continue;
                            vSyleMasterPage.setStylePageLayoutNameAttribute(pageLayout.getStyleNameAttribute());
                        }
                    }
                    autoStyles.appendChild(pageLayoutNew);
                }
                NodeList vListStlePageLprop = pageLayout.getElementsByTagName("style:page-layout-properties");
                StylePageLayoutPropertiesElement vStlePageLprop = (StylePageLayoutPropertiesElement)vListStlePageLprop.item(0);
                StyleColumnsElement vStyleColumnsElement = vStlePageLprop.newStyleColumnsElement(columnsNumber);
                vStyleColumnsElement.setFoColumnGapAttribute(vSpacingColumn);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException("Page column sets failed.", e);
        }
    }

    public void addColumnBreak() {
        this.addPageOrColumnBreak(null, "column");
    }

    public void addColumnBreak(Paragraph refParagraph) {
        this.addPageOrColumnBreak(refParagraph, "column");
    }

    private void addPageOrColumnBreak(Paragraph refParagraph, String breakAttribute) {
        TextPElement pEle = null;
        try {
            OdfContentDom contentDocument = this.getContentDom();
            OdfOfficeAutomaticStyles styles = contentDocument.getAutomaticStyles();
            OdfStyle style = styles.newStyle(OdfStyleFamily.Paragraph);
            style.newStyleParagraphPropertiesElement().setFoBreakBeforeAttribute(breakAttribute);
            if (refParagraph == null) {
                pEle = this.getContentRoot().newTextPElement();
            } else {
                OfficeTextElement contentRoot = this.getContentRoot();
                pEle = contentRoot.newTextPElement();
                TextParagraphElementBase refEle = refParagraph.getOdfElement();
                contentRoot.insertBefore((Node)pEle, refEle.getNextSibling());
            }
            pEle.setStyleName(style.getStyleNameAttribute());
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(breakAttribute + "Break appends failed.", e);
        }
    }

    public void addPageBreak(Paragraph refParagraph, MasterPage master) {
        TextPElement pEle = null;
        try {
            OdfContentDom contentDocument = this.getContentDom();
            OdfOfficeAutomaticStyles styles = contentDocument.getAutomaticStyles();
            OdfStyle style = styles.newStyle(OdfStyleFamily.Paragraph);
            style.setStyleMasterPageNameAttribute(master.getName());
            if (refParagraph == null) {
                pEle = this.getContentRoot().newTextPElement();
            } else {
                OfficeTextElement contentRoot = this.getContentRoot();
                pEle = contentRoot.newTextPElement();
                TextParagraphElementBase refEle = refParagraph.getOdfElement();
                contentRoot.insertBefore((Node)pEle, refEle.getNextSibling());
            }
            pEle.setStyleName(style.getStyleNameAttribute());
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException("PageBreak with mater page - " + master.getName() + " - appends failed.", e);
        }
    }

    @Override
    public Paragraph addParagraph(String text) {
        Paragraph para = this.getParagraphContainerImpl().addParagraph(text);
        return para;
    }

    @Override
    public boolean removeParagraph(Paragraph para) {
        return this.getParagraphContainerImpl().removeParagraph(para);
    }

    @Override
    public OdfElement getParagraphContainerElement() {
        return this.getParagraphContainerImpl().getParagraphContainerElement();
    }

    @Override
    public Paragraph getParagraphByIndex(int index, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByIndex(index, isEmptyParagraphSkipped);
    }

    @Override
    public Paragraph getParagraphByReverseIndex(int reverseIndex, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByReverseIndex(reverseIndex, isEmptyParagraphSkipped);
    }

    @Override
    public Iterator<Paragraph> getParagraphIterator() {
        return this.getParagraphContainerImpl().getParagraphIterator();
    }

    @Override
    public VariableField declareVariable(String name, VariableField.VariableType type) {
        return this.getVariableContainerImpl().declareVariable(name, type);
    }

    @Override
    public VariableField getVariableFieldByName(String name) {
        return this.getVariableContainerImpl().getVariableFieldByName(name);
    }

    @Override
    public OdfElement getVariableContainerElement() {
        return this.getVariableContainerImpl().getVariableContainerElement();
    }

    @Override
    public Chart createChart(String title, DataSet dataset, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, dataset, rect);
    }

    @Override
    public Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, document, cellRangeAddr, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries, rect);
    }

    @Override
    public Chart createChart(String title, String[] labels, String[] legends, double[][] data, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, labels, legends, data, rect);
    }

    @Override
    public void deleteChartById(String chartId) {
        this.getChartContainerImpl().deleteChartById(chartId);
    }

    @Override
    public void deleteChartByTitle(String title) {
        this.getChartContainerImpl().deleteChartByTitle(title);
    }

    @Override
    public Chart getChartById(String chartId) {
        return this.getChartContainerImpl().getChartById(chartId);
    }

    @Override
    public java.util.List<Chart> getChartByTitle(String title) {
        return this.getChartContainerImpl().getChartByTitle(title);
    }

    @Override
    public int getChartCount() {
        return this.getChartContainerImpl().getChartCount();
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    private StyleMasterPageElement getMasterPage(boolean pFirstPage) throws Exception {
        String pageStyleName = pFirstPage ? "First_20_Page" : "Standard";
        OfficeDocumentStylesElement rootElement = this.getStylesDom().getRootElement();
        OfficeMasterStylesElement masterStyles = (OfficeMasterStylesElement)OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, (Node)rootElement);
        if (masterStyles == null) {
            masterStyles = rootElement.newOfficeMasterStylesElement();
        }
        StyleMasterPageElement masterPageEle = null;
        NodeList lastMasterPages = masterStyles.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "master-page");
        if (lastMasterPages != null && lastMasterPages.getLength() > 0) {
            for (int i = 0; i < lastMasterPages.getLength(); ++i) {
                StyleMasterPageElement masterPage = (StyleMasterPageElement)lastMasterPages.item(i);
                String styleName = masterPage.getStyleNameAttribute();
                if (!pageStyleName.equals(styleName)) continue;
                masterPageEle = masterPage;
                break;
            }
        }
        if (masterPageEle == null) {
            OdfStylePageLayout layout = (OdfStylePageLayout)OdfElement.findFirstChildNode(OdfStylePageLayout.class, (Node)this.getStylesDom().getAutomaticStyles());
            masterPageEle = masterStyles.newStyleMasterPageElement(pageStyleName, layout.getStyleNameAttribute());
        }
        return masterPageEle;
    }

    private ParagraphContainerImpl getParagraphContainerImpl() {
        if (this.paragraphContainerImpl == null) {
            this.paragraphContainerImpl = new ParagraphContainerImpl();
        }
        return this.paragraphContainerImpl;
    }

    private VariableContainer getVariableContainerImpl() {
        if (this.variableContainerImpl == null) {
            this.variableContainerImpl = new VariableContainerImpl();
        }
        return this.variableContainerImpl;
    }

    private ChartContainerImpl getChartContainerImpl() {
        if (this.chartContainerImpl == null) {
            this.chartContainerImpl = new ChartContainerImpl(this);
        }
        return this.chartContainerImpl;
    }

    public TextTableOfContentElement createDefaultTOC(Paragraph refParagraph, boolean before) {
        TextTableOfContentElement textTableOfContent = null;
        if (refParagraph == null) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, "Failed to create Default TOC, The refParagraph where the TOC be inserted is null");
            throw new RuntimeException("Failed to create Default TOC, The refParagraph where the TOC be inserted is null");
        }
        TextParagraphElementBase refparagraphNode = refParagraph.getOdfElement();
        Node rootNode = refparagraphNode.getParentNode();
        try {
            OdfContentDom content = this.getContentDom();
            textTableOfContent = (TextTableOfContentElement)content.newOdfElement(TextTableOfContentElement.class);
            textTableOfContent.setTextNameAttribute("Table of Contents");
            textTableOfContent.setTextProtectedAttribute(Boolean.valueOf(true));
            TextTableOfContentSourceElement textTableOfContentSource = textTableOfContent.newTextTableOfContentSourceElement();
            textTableOfContentSource.setTextOutlineLevelAttribute(Integer.valueOf(10));
            textTableOfContentSource.setTextUseIndexMarksAttribute(Boolean.valueOf(true));
            TextIndexTitleTemplateElement textIndexTitleTemplate = textTableOfContentSource.newTextIndexTitleTemplateElement();
            textIndexTitleTemplate.setTextStyleNameAttribute("Contents_20_Heading");
            textIndexTitleTemplate.setTextContent("Table of Contents");
            for (int i = 1; i <= 10; ++i) {
                TextTableOfContentEntryTemplateElement textTableOfContentEntryTemplate = textTableOfContentSource.newTextTableOfContentEntryTemplateElement(i, "Contents_20_" + i);
                TextIndexEntryLinkStartElement TextIndexEntryLinkStart = textTableOfContentEntryTemplate.newTextIndexEntryLinkStartElement();
                TextIndexEntryLinkStart.setTextStyleNameAttribute("Index_20_Link");
                textTableOfContentEntryTemplate.newTextIndexEntryChapterElement();
                textTableOfContentEntryTemplate.newTextIndexEntryTextElement();
                TextIndexEntryTabStopElement TextIndexEntryTabStop = textTableOfContentEntryTemplate.newTextIndexEntryTabStopElement("right");
                TextIndexEntryTabStop.setStyleLeaderCharAttribute(".");
                textTableOfContentEntryTemplate.newTextIndexEntryPageNumberElement();
                textTableOfContentEntryTemplate.newTextIndexEntryLinkEndElement();
            }
            TextIndexBodyElement textIndexBody = textTableOfContent.newTextIndexBodyElement();
            TextIndexTitleElement TextIndexTitle = textIndexBody.newTextIndexTitleElement("Table of Contents_Head");
            TextPElement texp = TextIndexTitle.newTextPElement();
            texp.setTextStyleNameAttribute("Contents_20_Heading");
            texp.setTextContent("Table of Contents");
            Iterator<Paragraph> paragraphIterator = this.getParagraphIterator();
            while (paragraphIterator.hasNext()) {
                Paragraph paragraph = paragraphIterator.next();
                String text = paragraph.getTextContent();
                String stylename = paragraph.getStyleName();
                if (paragraph.isHeading()) {
                    int headingLevel = paragraph.getHeadingLevel();
                    if (stylename.length() <= 0) {
                        stylename = "Contents_20_" + headingLevel;
                    }
                    this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                }
                TextParagraphElementBase podf = paragraph.getOdfElement();
                NodeList cns = podf.getChildNodes();
                for (int i = 0; i < cns.getLength(); ++i) {
                    Node node = cns.item(i);
                    if (node instanceof TextTocMarkElement) {
                        TextTocMarkElement textTocMarkElement = (TextTocMarkElement)node;
                        text = textTocMarkElement.getTextStringValueAttribute();
                        int headingLevel = textTocMarkElement.getTextOutlineLevelAttribute();
                        stylename = "Contents_20_" + headingLevel;
                        this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                    }
                    if (!(node instanceof TextTocMarkStartElement)) continue;
                    TextTocMarkStartElement textTocMarkStartElement = (TextTocMarkStartElement)node;
                    Node tmp = node.getNextSibling();
                    while (!(tmp instanceof Text)) {
                        tmp = node.getNextSibling();
                    }
                    text = tmp.getTextContent();
                    int headingLevel = textTocMarkStartElement.getTextOutlineLevelAttribute();
                    stylename = "Contents_20_" + headingLevel;
                    this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                }
            }
            if (before) {
                rootNode.insertBefore((Node)textTableOfContent, (Node)refparagraphNode);
            } else {
                Node refNextNode = refparagraphNode.getNextSibling();
                if (refNextNode == null) {
                    rootNode.appendChild((Node)textTableOfContent);
                } else {
                    rootNode.insertBefore((Node)textTableOfContent, refNextNode);
                }
            }
            return textTableOfContent;
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, "Failed to create Default TOC", e);
            throw new RuntimeException("Failed to create Default TOC", e);
        }
    }

    private void ceateIndexBodyEntry(TextIndexBodyElement textIndexBody, String stylename, String text) {
        TextPElement textp = textIndexBody.newTextPElement();
        textp.setTextStyleNameAttribute(stylename);
        textp.newTextNode(text);
        textp.newTextTabElement();
        textp.newTextNode("1");
    }

    public TextTableOfContentElement createTOCwithStyle(Paragraph refParagraph, TOCStyle additionalStyle, boolean before) {
        if (refParagraph == null) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, "Failed to create Default TOC, The refParagraph where the TOC be inserted is null");
            throw new RuntimeException("Failed to create Default TOC, The refParagraph where the TOC be inserted is null");
        }
        if (additionalStyle == null) {
            TextTableOfContentElement textTableOfContentElement = this.createDefaultTOC(refParagraph, before);
            return textTableOfContentElement;
        }
        HashMap<Integer, String> tocstyleList = additionalStyle.getStyle();
        if (tocstyleList.isEmpty()) {
            TextTableOfContentElement textTableOfContentElement = this.createDefaultTOC(refParagraph, before);
            return textTableOfContentElement;
        }
        Collection<String> tocvalues = tocstyleList.values();
        OdfOfficeStyles docstyles = this.getOrCreateDocumentStyles();
        Iterable paragraphStyles = docstyles.getStylesForFamily(OdfStyleFamily.Paragraph);
        ArrayList<String> pstyle = new ArrayList<String>();
        for (OdfStyle style : paragraphStyles) {
            String name = style.getStyleNameAttribute();
            pstyle.add(name);
        }
        if (!pstyle.containsAll(tocvalues)) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, "Failed to create TOC with Styles. Some of addtional Styles that you want to include in the TOC can't be found in the document.\n" + tocvalues.toString());
            throw new RuntimeException("Failed to create TOC Styles.Some of addtional Styles that you want to include in the TOC can't be found in the document.");
        }
        TextTableOfContentElement textTableOfContent = null;
        HashMap<String, Integer> tmptocstyleList = new HashMap<String, Integer>();
        if (!tocstyleList.isEmpty()) {
            Set<Integer> key = tocstyleList.keySet();
            for (Integer textOutlineLevelValue : key) {
                String textStyleNameValue = tocstyleList.get(textOutlineLevelValue);
                tmptocstyleList.put(textStyleNameValue, textOutlineLevelValue);
            }
        }
        TextParagraphElementBase refparagraphNode = refParagraph.getOdfElement();
        Node rootNode = refparagraphNode.getParentNode();
        try {
            OdfContentDom content = this.getContentDom();
            textTableOfContent = (TextTableOfContentElement)content.newOdfElement(TextTableOfContentElement.class);
            textTableOfContent.setTextNameAttribute("Table of Contents");
            textTableOfContent.setTextProtectedAttribute(Boolean.valueOf(true));
            TextTableOfContentSourceElement textTableOfContentSource = textTableOfContent.newTextTableOfContentSourceElement();
            textTableOfContentSource.setTextOutlineLevelAttribute(Integer.valueOf(10));
            textTableOfContentSource.setTextUseIndexMarksAttribute(Boolean.valueOf(true));
            textTableOfContentSource.setTextUseIndexSourceStylesAttribute(Boolean.valueOf(true));
            TextIndexTitleTemplateElement textIndexTitleTemplate = textTableOfContentSource.newTextIndexTitleTemplateElement();
            textIndexTitleTemplate.setTextStyleNameAttribute("Contents_20_Heading");
            textIndexTitleTemplate.setTextContent("Table of Contents");
            for (int i = 1; i <= 10; ++i) {
                TextTableOfContentEntryTemplateElement textTableOfContentEntryTemplate = textTableOfContentSource.newTextTableOfContentEntryTemplateElement(i, "Contents_20_" + i);
                TextIndexEntryLinkStartElement TextIndexEntryLinkStart = textTableOfContentEntryTemplate.newTextIndexEntryLinkStartElement();
                TextIndexEntryLinkStart.setTextStyleNameAttribute("Index_20_Link");
                textTableOfContentEntryTemplate.newTextIndexEntryChapterElement();
                textTableOfContentEntryTemplate.newTextIndexEntryTextElement();
                TextIndexEntryTabStopElement TextIndexEntryTabStop = textTableOfContentEntryTemplate.newTextIndexEntryTabStopElement("right");
                TextIndexEntryTabStop.setStyleLeaderCharAttribute(".");
                textTableOfContentEntryTemplate.newTextIndexEntryPageNumberElement();
                textTableOfContentEntryTemplate.newTextIndexEntryLinkEndElement();
            }
            if (!tocstyleList.isEmpty()) {
                Set<Integer> key = tocstyleList.keySet();
                for (Integer textOutlineLevelValue : key) {
                    String textStyleNameValue = tocstyleList.get(textOutlineLevelValue);
                    TextIndexSourceStylesElement textIndexSourceStyles = textTableOfContentSource.newTextIndexSourceStylesElement(textOutlineLevelValue.intValue());
                    textIndexSourceStyles.newTextIndexSourceStyleElement(textStyleNameValue);
                }
            }
            TextIndexBodyElement textIndexBody = textTableOfContent.newTextIndexBodyElement();
            TextIndexTitleElement TextIndexTitle = textIndexBody.newTextIndexTitleElement("Table of Contents_Head");
            TextPElement texp = TextIndexTitle.newTextPElement();
            texp.setTextStyleNameAttribute("Contents_20_Heading");
            texp.setTextContent("Table of Contents");
            Iterator<Paragraph> paragraphIterator = this.getParagraphIterator();
            while (paragraphIterator.hasNext()) {
                int headingLevel;
                Paragraph paragraph = paragraphIterator.next();
                String text = paragraph.getTextContent();
                String stylename = paragraph.getStyleName();
                if (paragraph.isHeading()) {
                    headingLevel = paragraph.getHeadingLevel();
                    if (stylename.length() <= 0) {
                        stylename = "Contents_20_" + headingLevel;
                    }
                    this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                }
                if (tmptocstyleList.containsKey(stylename)) {
                    headingLevel = (Integer)tmptocstyleList.get(stylename);
                    stylename = "Contents_20_" + headingLevel;
                    this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                }
                TextParagraphElementBase podf = paragraph.getOdfElement();
                NodeList cns = podf.getChildNodes();
                for (int i = 0; i < cns.getLength(); ++i) {
                    Node node = cns.item(i);
                    if (node instanceof TextTocMarkElement) {
                        TextTocMarkElement textTocMarkElement = (TextTocMarkElement)node;
                        text = textTocMarkElement.getTextStringValueAttribute();
                        int headingLevel2 = textTocMarkElement.getTextOutlineLevelAttribute();
                        stylename = "Contents_20_" + headingLevel2;
                        this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                    }
                    if (!(node instanceof TextTocMarkStartElement)) continue;
                    TextTocMarkStartElement textTocMarkStartElement = (TextTocMarkStartElement)node;
                    Node tmp = node.getNextSibling();
                    while (!(tmp instanceof Text)) {
                        tmp = node.getNextSibling();
                    }
                    text = tmp.getTextContent();
                    int headingLevel3 = textTocMarkStartElement.getTextOutlineLevelAttribute();
                    stylename = "Contents_20_" + headingLevel3;
                    this.ceateIndexBodyEntry(textIndexBody, stylename, text);
                }
            }
            if (before) {
                rootNode.insertBefore((Node)textTableOfContent, (Node)refparagraphNode);
            } else {
                Node refNextNode = refparagraphNode.getNextSibling();
                if (refNextNode == null) {
                    rootNode.appendChild((Node)textTableOfContent);
                } else {
                    rootNode.insertBefore((Node)textTableOfContent, refNextNode);
                }
            }
            return textTableOfContent;
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, "Failed to create Default TOC", e);
            throw new RuntimeException("Failed to create Default TOC", e);
        }
    }

    public Paragraph insertParagraph(Paragraph referenceParagraph, Paragraph sourceParagraph, boolean before) {
        boolean isForeignNode = false;
        try {
            TextParagraphElementBase refparagraphNode = referenceParagraph.getOdfElement();
            if (sourceParagraph.getOdfElement().getOwnerDocument() != this.getContentDom()) {
                isForeignNode = true;
            }
            TextParagraphElementBase oldParagraphEle = sourceParagraph.getOdfElement();
            TextParagraphElementBase newParagraphEle = (TextParagraphElementBase)oldParagraphEle.cloneNode(true);
            if (isForeignNode) {
                this.copyForeignStyleRef((OdfElement)sourceParagraph.getOdfElement(), sourceParagraph.getOwnerDocument());
            }
            if (isForeignNode) {
                newParagraphEle = (TextParagraphElementBase)this.cloneForeignElement((Node)newParagraphEle, (OdfFileDom)this.getContentDom(), true);
            }
            if (before) {
                refparagraphNode.getParentNode().insertBefore((Node)newParagraphEle, (Node)refparagraphNode);
            } else {
                Node refNextNode = refparagraphNode.getNextSibling();
                if (refNextNode == null) {
                    refparagraphNode.getParentNode().appendChild((Node)newParagraphEle);
                } else {
                    refparagraphNode.getParentNode().insertBefore((Node)newParagraphEle, refNextNode);
                }
            }
            return Paragraph.getInstanceof(newParagraphEle);
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public Table insertTable(Paragraph referenceParagraph, Table sourceTable, boolean before) {
        Document ownDocument = sourceTable.getOwnerDocument();
        TableTableElement newTEle = (TableTableElement)this.insertOdfElement((OdfElement)referenceParagraph.getOdfElement(), ownDocument, (OdfElement)sourceTable.getOdfElement(), before);
        Table table = Table.getInstance(newTEle);
        return table;
    }

    public OdfElement insertOdfElement(OdfElement referenceOdfElement, Document sourceDocument, OdfElement sourceOdfElement, boolean before) {
        boolean isForeignNode = false;
        try {
            if (sourceOdfElement.getOwnerDocument() != this.getContentDom()) {
                isForeignNode = true;
            }
            OdfElement newOdfElement = (OdfElement)sourceOdfElement.cloneNode(true);
            if (isForeignNode) {
                this.copyForeignStyleRef(newOdfElement, sourceDocument);
                this.copyLinkedRef(newOdfElement);
                newOdfElement = (OdfElement)this.cloneForeignElement((Node)newOdfElement, (OdfFileDom)this.getContentDom(), true);
            }
            if (before) {
                referenceOdfElement.getParentNode().insertBefore((Node)newOdfElement, (Node)referenceOdfElement);
            } else {
                Node refNextNode = referenceOdfElement.getNextSibling();
                if (refNextNode == null) {
                    referenceOdfElement.getParentNode().appendChild((Node)newOdfElement);
                } else {
                    referenceOdfElement.getParentNode().insertBefore((Node)newOdfElement, refNextNode);
                }
            }
            return newOdfElement;
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    private OdfElement insertOdfElementwithoutstyle(OdfElement referenceOdfElement, Document sourceDocument, OdfElement sourceOdfElement, boolean before) {
        try {
            OdfElement newOdfElement = (OdfElement)sourceOdfElement.cloneNode(true);
            newOdfElement = (OdfElement)this.cloneForeignElement((Node)newOdfElement, (OdfFileDom)this.getContentDom(), true);
            if (before) {
                referenceOdfElement.getParentNode().insertBefore((Node)newOdfElement, (Node)referenceOdfElement);
            } else {
                Node refNextNode = referenceOdfElement.getNextSibling();
                if (refNextNode == null) {
                    referenceOdfElement.getParentNode().appendChild((Node)newOdfElement);
                } else {
                    referenceOdfElement.getParentNode().insertBefore((Node)newOdfElement, refNextNode);
                }
            }
            return newOdfElement;
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public void insertContentFromDocumentAfter(TextDocument sourceDocument, Paragraph referenceParagraph, boolean isCopyStyle) {
        try {
            OfficeTextElement sroot = sourceDocument.getContentRoot();
            NodeList clist = sroot.getChildNodes();
            for (int i = clist.getLength() - 1; i >= 0; --i) {
                OdfElement node = (OdfElement)clist.item(i);
                if (isCopyStyle) {
                    this.insertOdfElement((OdfElement)referenceParagraph.getOdfElement(), sourceDocument, node, false);
                    continue;
                }
                this.insertOdfElementwithoutstyle((OdfElement)referenceParagraph.getOdfElement(), sourceDocument, node, false);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void insertContentFromDocumentBefore(TextDocument sourceDocument, Paragraph referenceParagraph, boolean isCopyStyle) {
        try {
            OfficeTextElement sroot = sourceDocument.getContentRoot();
            NodeList clist = sroot.getChildNodes();
            for (int i = 0; i < clist.getLength(); ++i) {
                OdfElement node = (OdfElement)clist.item(i);
                if (isCopyStyle) {
                    this.insertOdfElement((OdfElement)referenceParagraph.getOdfElement(), sourceDocument, node, true);
                    continue;
                }
                this.insertOdfElementwithoutstyle((OdfElement)referenceParagraph.getOdfElement(), sourceDocument, node, true);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private FormContainerImpl getFormContainerImpl() {
        if (this.formContainerImpl == null) {
            this.formContainerImpl = new FormContainerImpl();
        }
        return this.formContainerImpl;
    }

    @Override
    public Form createForm(String name) {
        return this.getFormContainerImpl().createForm(name);
    }

    @Override
    public Iterator<Form> getFormIterator() {
        return this.getFormContainerImpl().getFormIterator();
    }

    @Override
    public boolean removeForm(Form form) {
        return this.getFormContainerImpl().removeForm(form);
    }

    @Override
    public Form getFormByName(String name) {
        return this.getFormContainerImpl().getFormByName(name);
    }

    @Override
    public OfficeFormsElement getFormContainerElement() {
        return this.getFormContainerImpl().getFormContainerElement();
    }

    @Override
    public boolean getApplyDesignMode() {
        return this.getFormContainerImpl().getApplyDesignMode();
    }

    @Override
    public boolean getAutomaticFocus() {
        return this.getFormContainerImpl().getAutomaticFocus();
    }

    @Override
    public void setApplyDesignMode(boolean isDesignMode) {
        this.getFormContainerImpl().setApplyDesignMode(isDesignMode);
    }

    @Override
    public void setAutomaticFocus(boolean isAutoFocus) {
        this.getFormContainerImpl().setAutomaticFocus(isAutoFocus);
    }

    @Override
    public Control createDrawControl() {
        OdfElement parent = this.getDrawControlContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        DrawControlElement element = (DrawControlElement)ownerDom.newOdfElement(DrawControlElement.class);
        OdfElement refChild = OdfElement.findFirstChildNode(TextSequenceDeclsElement.class, (Node)parent);
        parent.insertBefore((Node)element, refChild.getNextSibling());
        Control control = new Control(element);
        Component.registerComponent(control, (OdfElement)element);
        return control;
    }

    @Override
    public OdfElement getDrawControlContainerElement() {
        OfficeTextElement element = null;
        try {
            element = this.getContentRoot();
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
        return element;
    }

    private class FormContainerImpl
    extends AbstractFormContainer {
        private FormContainerImpl() {
        }

        public OfficeFormsElement getFormContainerElement() {
            OfficeFormsElement forms = null;
            try {
                OfficeTextElement root = TextDocument.this.getContentRoot();
                forms = (OfficeFormsElement)OdfElement.findFirstChildNode(OfficeFormsElement.class, (Node)root);
                if (forms == null) {
                    Node firstChild = root.getFirstChild();
                    OfficeFormsElement officeForms = (OfficeFormsElement)TextDocument.this.getContentDom().newOdfElement(OfficeFormsElement.class);
                    forms = (OfficeFormsElement)root.insertBefore((Node)officeForms, firstChild);
                }
                return forms;
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
                return forms;
            }
        }
    }

    private class ChartContainerImpl
    extends AbstractChartContainer {
        TextDocument sdoc;

        protected ChartContainerImpl(Document doc) {
            super(doc);
            this.sdoc = (TextDocument)doc;
        }

        protected DrawFrameElement getChartFrame() throws Exception {
            OdfContentDom contentDom2 = this.sdoc.getContentDom();
            DrawFrameElement drawFrame = (DrawFrameElement)contentDom2.newOdfElement(DrawFrameElement.class);
            TextPElement lastPara = this.sdoc.getContentRoot().newTextPElement();
            lastPara.appendChild((Node)drawFrame);
            drawFrame.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
            return drawFrame;
        }
    }

    private class VariableContainerImpl
    extends AbstractVariableContainer {
        private VariableContainerImpl() {
        }

        public OdfElement getVariableContainerElement() {
            try {
                return TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
                return null;
            }
        }
    }

    private class ParagraphContainerImpl
    extends AbstractParagraphContainer {
        private ParagraphContainerImpl() {
        }

        public OdfElement getParagraphContainerElement() {
            OfficeTextElement containerElement = null;
            try {
                containerElement = TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            return containerElement;
        }
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            OfficeTextElement containerElement = null;
            try {
                containerElement = TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            return containerElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        TEXT(Document.OdfMediaType.TEXT),
        TEXT_TEMPLATE(Document.OdfMediaType.TEXT_TEMPLATE),
        TEXT_MASTER(Document.OdfMediaType.TEXT_MASTER),
        TEXT_WEB(Document.OdfMediaType.TEXT_WEB);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

