/*
 * Decompiled with CFR 0.152.
 */
package io.nayuki.qrcodegen;

import io.nayuki.qrcodegen.QrCode;
import java.util.BitSet;
import java.util.Objects;

public final class BitBuffer
implements Cloneable {
    private BitSet data = new BitSet();
    private int bitLength = 0;

    public int bitLength() {
        assert (this.bitLength >= 0);
        return this.bitLength;
    }

    public int getBit(int index) {
        if (index < 0 || index >= this.bitLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.get(index) ? 1 : 0;
    }

    public void appendBits(int val, int len) {
        if (len < 0 || len > 31 || val >>> len != 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        if (Integer.MAX_VALUE - this.bitLength < len) {
            throw new IllegalStateException("Maximum length reached");
        }
        int i = len - 1;
        while (i >= 0) {
            this.data.set(this.bitLength, QrCode.getBit(val, i));
            --i;
            ++this.bitLength;
        }
    }

    public void appendData(BitBuffer bb) {
        Objects.requireNonNull(bb);
        if (Integer.MAX_VALUE - this.bitLength < bb.bitLength) {
            throw new IllegalStateException("Maximum length reached");
        }
        int i = 0;
        while (i < bb.bitLength) {
            this.data.set(this.bitLength, bb.data.get(i));
            ++i;
            ++this.bitLength;
        }
    }

    public BitBuffer clone() {
        try {
            BitBuffer result = (BitBuffer)super.clone();
            result.data = (BitSet)result.data.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

